/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.EBuildException;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.ElementC;
import ebuild.core.impl.TaskSet;
import ebuild.core.run.ReleaseRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseBuildPlan
extends BuildPlan {
    final ReleaseRunner runner;
    final Collection<ElementC> cElements;
    private final List<BuildPlan> subPlans;

    public ReleaseBuildPlan(ReleaseRunner runner, Collection<ElementC> cElements) {
        super(runner, "release");
        this.cElements = cElements;
        this.subPlans = new ArrayList<BuildPlan>(cElements.size());
        this.runner = runner;
    }

    @Override
    protected void resolveBuilders(TaskSet tasks) throws EBuildException {
    }

    @Override
    protected void resolveAndConfigure_(TaskSet tasks) throws EBuildException {
        this.report.startResolveMain();
        this.resolveDependencies();
        this.report.endResolveMain();
        for (BuildPlan bp : this.subPlans) {
            bp.resolveAndConfigure(tasks);
        }
    }

    void resolveDependencies() {
        for (ElementC ce : this.cElements) {
            BuildPlan subPlan = this.runner.newBuildPlan(ce, Scope.MAIN);
            this.subPlans.add(subPlan);
            this.report.addPlan(subPlan);
            this.report.configure(ce.key.ekey, ce.getConfigurationSelected());
        }
    }

    @Override
    protected void buildActionList_(ActionQueue queue, TaskSet tasks) throws Exception {
        for (BuildPlan subPlan : this.subPlans) {
            subPlan.buildActionList(queue, tasks);
        }
    }
}

