/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.IRepository;
import ebuild.base.EBuildException;
import ebuild.core.EBuildContext;
import ebuild.core.RepositoryContext;
import ebuild.core.impl.Version;

public abstract class RepositoryRef {
    public final EBuildContext context;
    public final String name;
    private RepositoryContext repositoryContext;
    private String defaultOrg;
    private Version defaultVersion;

    RepositoryRef(EBuildContext context, String name, String defaultOrg) {
        this(context, name);
        this.defaultOrg = defaultOrg;
    }

    public RepositoryRef(EBuildContext context, String name) {
        this.context = context;
        this.name = name;
    }

    protected abstract IRepository locateRepository() throws EBuildException;

    private IRepository getRepository() throws EBuildException {
        return this.getContext().repo;
    }

    public String expectDefaultOrg() throws EBuildException {
        if (this.defaultOrg == null) {
            throw EBuildException.newProblem("\"org\" must be specified for repository: " + this.name);
        }
        return this.defaultOrg;
    }

    public String getDefaultOrg() {
        return this.defaultOrg;
    }

    public void setDefaultOrg(String defaultOrg) {
        this.defaultOrg = defaultOrg;
    }

    public Version getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(Version defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public String getUniverse() throws EBuildException {
        IRepository repo = this.getRepository();
        if (repo == null) {
            return "project";
        }
        String r = repo.getUniverse();
        if ("ebuild".equals(r)) {
            if (repo instanceof AbstractSourceRepository) {
                return "project";
            }
            return "release";
        }
        return r;
    }

    public RepositoryContext getContext() throws EBuildException {
        if (this.repositoryContext == null) {
            IRepository repo = this.locateRepository();
            this.repositoryContext = repo instanceof AbstractSourceRepository ? new RepositoryContext.Source(this.context, this.name, (AbstractSourceRepository)repo) : new RepositoryContext(repo);
        }
        return this.repositoryContext;
    }

    public String toString() {
        return this.context + "--" + this.name;
    }
}

