/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.Project;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.BuildMode;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkspaceProject<P extends Element>
extends Project<P> {
    private boolean configurationChange = false;
    private static final String CONF_FILENAME = ".configuration";

    public WorkspaceProject(ElementC cElement) {
        super(cElement);
    }

    public void setup() throws Exception {
        ((Element)this.cElement.getPart()).addIgnores(CollectionUtil.newList(CONF_FILENAME, ".project", ".settings", "gen", ".classpath"));
    }

    public void unsetup() throws Exception {
        ((Element)this.getPart()).getFile(".project").delete();
    }

    public boolean isProjectDirty() {
        return this.configurationChange;
    }

    @Override
    public BuildMode mode() {
        return BuildMode.eclipse;
    }

    public void storeConfiguration() throws IOException {
        ConfSet old;
        File f = ((Element)this.getPart()).getFile(CONF_FILENAME);
        if (f.exists()) {
            old = ConfSet.fromJson(IOUtil.fileToString(f));
            FileUtil.deleteOrFail(f);
        } else {
            old = ConfSet.EMPTY;
        }
        if (!this.getConfigurationSelected().isEmpty()) {
            IOUtil.stringToFile(this.getConfigurationSelected().asJson(), f);
        }
        this.configurationChange = !old.equals(this.getConfigurationSelected());
    }
}

