/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.base.EBuildException;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.Exclude;
import ebuild.util.ObjectUtil;

public class SubKey {
    public static final SubKey DEFAULT = new SubKey(ConfSet.EMPTY, null);
    public final ConfSet conf;
    public final String artifact;
    public final Exclude exclude;

    public SubKey(String confs, String artifact) throws EBuildException {
        this(EBuildUtil.parseConfSet(confs), artifact, Exclude.NONE);
    }

    public SubKey(ConfSet conf, String artifact) {
        this(conf, artifact, Exclude.NONE);
    }

    public SubKey(ConfSet conf, String artifact, Exclude exclude) {
        this.conf = conf;
        this.artifact = artifact;
        this.exclude = exclude;
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.conf) + ObjectUtil.hashOf(this.artifact);
    }

    public boolean equals(Object obj) {
        SubKey b = (SubKey)obj;
        return ObjectUtil.areEqual(this.conf, b.conf) && ObjectUtil.areEqual(this.artifact, b.artifact);
    }

    public String toString() {
        return String.valueOf(this.artifact == null ? "[default]" : this.artifact) + " " + this.conf + " " + this.exclude;
    }
}

