/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.run;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.base.EBuildException;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildRunner;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementRelease;
import ebuild.core.Module;
import ebuild.core.ModuleDeps;
import ebuild.core.Product;
import ebuild.core.ProductRelease;
import ebuild.core.ReleaseBuildPlan;
import ebuild.core.RepositoryRef;
import ebuild.core.impl.ArtifactKey;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Select;
import ebuild.core.impl.SubKey;
import ebuild.core.impl.Task;
import ebuild.core.impl.Version;
import ebuild.options.DisplayOrder;
import ebuild.options.OptionsBuilder;
import ebuild.options.OptionsUtil;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.Logger;
import ebuild.util.StringUtil;
import ebuild.util.ZipUtil;
import ebuild.xml.CmnXml;
import ebuild.xml.OptXml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseRunner
extends EBuildRunner {
    public final Options options;
    public final EBuildContext releaseContext;
    public final List<Select> selected = new ArrayList<Select>();
    public final Set<ElementC> selectedCElements = new LinkedHashSet<ElementC>();
    private Map<String, RepositoryRef> projectRepos = new HashMap<String, RepositoryRef>();

    public static void run(ClassLoader apiClassLoader, String[] args) throws Exception {
        if (OptionsUtil.isPrintOptions(args)) {
            System.err.println(OptionsUtil.formatOptions(Options.class));
        } else {
            System.err.println("Pass argument ? to print out options");
            Options optionsObj = new Options();
            OptionsBuilder optionsBuilder = new OptionsBuilder(optionsObj);
            Map<String, String> optionsMap = OptionsUtil.read(args);
            optionsBuilder.merge(optionsMap);
            OptXml.EBuildReleaseOptions fileOptions = null;
            if (optionsObj.optionsFile != null) {
                fileOptions = OptXml.deserialize(optionsObj.optionsFile);
                optionsBuilder.merge(fileOptions.options);
            }
            if (!optionsObj.home.exists()) {
                optionsBuilder.addError("_ebuild directory does not exist: " + optionsObj.home);
            }
            optionsBuilder.verify();
            ReleaseRunner doRelease = new ReleaseRunner(apiClassLoader, optionsObj);
            doRelease.formatOptionValues(optionsBuilder.getSetOptions());
            doRelease.interpretOptions(fileOptions);
            doRelease.run();
        }
    }

    public ReleaseRunner(ClassLoader apiClassLoader, Options options) {
        super(apiClassLoader, options);
        this.options = options;
        this.releaseContext = new EBuildContext(this.ebuild);
        this.releaseContext.addParents(this.ebuild.context);
    }

    private void interpretOptions(OptXml.EBuildReleaseOptions fileOptions) throws EBuildException {
        List<OptXml.Select> selects = CollectionUtil.EMPTY_LIST;
        if (fileOptions != null) {
            this.addRepos(fileOptions.repositories);
            selects = fileOptions.selects;
        }
        this.addKeys(selects, this.getSelect(this.options));
        if (this.selected.size() == 0) {
            throw EBuildException.newProblem("No element selected - set org,name ... etc. or  <select/> in options file ");
        }
    }

    private void addRepos(List<CmnXml.Repository> repos) throws EBuildException {
        this.releaseContext.addRepository("workspace", (IRepository)this.ebuild.getWorkspaceWorkingCopy().getRepository(), null);
        for (CmnXml.Repository r : repos) {
            this.releaseContext.addRepository(r);
        }
    }

    private OptXml.Select getSelect(Options options) throws EBuildException {
        OptXml.Select r = new OptXml.Select();
        r.elementType = options.elementType;
        r.org = options.org;
        r.name = options.name;
        r.tag = options.tag;
        r.branch = options.branch;
        r.revision = options.revision;
        r.confs = options.confs;
        return r;
    }

    private void addKeys(List<OptXml.Select> selects, OptXml.Select prototype) throws EBuildException {
        if (selects.size() == 0) {
            Version version = EBuildUtil.asVersion(prototype, Version.TRUNK_HEAD);
            EKey ekey = new EKey(prototype.elementType, "project", prototype.org, prototype.name, version);
            ArtifactKey cekey = new ArtifactKey(ekey, new SubKey(prototype.confs, prototype.artifact));
            this.selected.add(new Select(prototype.source, cekey));
        } else {
            for (OptXml.Select selDef : selects) {
                OptXml.Select prototype2 = prototype.clone(selDef);
                this.addKeys(selDef.subSelects, prototype2);
            }
        }
    }

    private void formatOptionValues(final Set<String> set) {
        this.log("////////////////////////////////////////////////////////////");
        this.log(OptionsUtil.formatOptionValues((Object)this.options, new CollectionUtil.Filter<String>(){

            @Override
            public boolean accept(String f) {
                Object v = OptionsUtil.getValue(ReleaseRunner.this.options, f);
                if ("noSkipping".equals(f) || "verbose".equals(f) || "debug".equals(f)) {
                    return v == Boolean.TRUE;
                }
                if ("home".equals(f)) {
                    return ReleaseRunner.this.options.debug;
                }
                return set.contains(f);
            }
        }));
        this.log("////////////////////////////////////////////////////////////");
        this.log("");
    }

    @Override
    public void go() throws Exception {
        this.releaseContext.addRepository(new RepositoryRef(this.releaseContext, "local"){

            protected IRepository locateRepository() {
                try {
                    return ReleaseRunner.this.useRepo(ReleaseRunner.this.logger, ReleaseRunner.this.ebuild.getWorkspaceWorkingCopy(), "_ebuild");
                }
                catch (EBuildException e) {
                    throw new Error(e);
                }
            }
        });
        for (Select select : this.selected) {
            this.selectedCElements.add(this.resolveTop(select));
        }
        ReleaseBuildPlan plan = new ReleaseBuildPlan(this, this.selectedCElements);
        if (this.options.source) {
            this.go(plan, Task.fetch_source);
        } else {
            this.go(plan, Task.build_release);
        }
        if (this.options.source) {
            for (ElementC ce : this.selectedCElements) {
                this.copySource(((Element)ce.element).key);
            }
        } else {
            this.copyReleases();
        }
    }

    private Element resolveTop(String source, EKey key) throws Exception {
        Version v;
        RepositoryRef repoRef = source == null ? this.guessInitialSourceRepository(key) : this.releaseContext.lookupRepository(source);
        if (StringUtil.isEmptyString(key.org) && repoRef != null) {
            key = key.withOrg(repoRef.expectDefaultOrg());
        }
        if ((v = key.version).isHead()) {
            AbstractSourceRepository srepo = repoRef.getContext().expectSourceRepo(key);
            String revision = this.ebuild.getWorkspaceHeadRevision(srepo);
            this.logger.log("");
            this.logger.log("head -> " + revision);
            this.logger.log("");
            v = Version.newRevision(v.getBranch(), revision);
            key = key.withVersion(v);
        }
        return this.ebuild.resolveLibraryPart(repoRef, key);
    }

    private ElementC resolveTop(Select select) throws Exception {
        Element el = this.resolveTop(select.source, select.key.ekey);
        SubKey subKey = select.key.subkey;
        return el.getCPart(subKey);
    }

    private IRepository useRepo(ILogger logger, AbstractWorkingCopy wc, String path) throws EBuildException {
        if (wc != null) {
            AbstractSourceRepository r = wc.getRepository();
            logger.log("... using location [workspace]/" + path + " to locate repository");
            logger.log("Repository: " + r);
            return r;
        }
        logger.log("[workspace]/" + path + " exists, but not linked to a repository");
        return null;
    }

    private RepositoryRef guessInitialSourceRepository(EKey key) throws Exception {
        Logger logger = this.ebuild.logger.newSubLogger("Guess initial repository");
        logger.log("No repository supplied, attempting to guess repository");
        logger.log("");
        Element ebd = this.ebuild.resolveWorkspaceElement(key.withVersion(Version.newRevision("[any]", "working")));
        if (ebd != null) {
            IRepository r = this.useRepo(logger, ebd.getWorkingCopy(), ebd.javaFile().getName());
            String n = r.getUri();
            RepositoryRef ref = this.projectRepos.get(n);
            if (ref == null) {
                ref = this.releaseContext.addRepository(n, r, null);
                this.projectRepos.put(n, ref);
            }
            return ref;
        }
        logger.log("... " + key + " not in workspace");
        return this.releaseContext.getRepository("local");
    }

    private String sourceReleaseName() {
        if (this.selectedCElements.size() != 1) {
            throw new Error("Multiple released elements for source release not supported");
        }
        Object p = this.selectedCElements.iterator().next().element;
        if (p instanceof Product) {
            return ((Product)p).releaseSourceFileName();
        }
        return ((Element)p).key.fullnameAndVersion();
    }

    void copySource(EKey key) throws Exception {
        String sourceReleaseName = this.sourceReleaseName();
        File releaseDir = new File(this.options.outputDirectory, this.sourceReleaseName());
        this.log("");
        this.log("Releasing to library: " + this.ebuild.formatAsDisplayPath(releaseDir));
        File library = new File(releaseDir, "_ebuild/library/ebuild");
        File seed = new File(releaseDir, "_ebuild/seed");
        library.mkdirs();
        seed.mkdirs();
        for (Element e : this.ebuild.getResolvedLibraryElements()) {
            Element p;
            if (!e.hasMetaDirectory()) continue;
            File releasePartDir = e.key.getSubDirectory(library);
            releasePartDir.mkdirs();
            File builtMeta = e.getMetaDirectory();
            FileUtil.copyToDir(builtMeta, releasePartDir);
            if (!(e instanceof Element) || !(p = e).isSource()) continue;
            File builtSource = p.getProjectDirectory();
            FileUtil.copyToDir(builtSource, releasePartDir);
        }
        FileUtil.copyToDir(this.ebuild.getFile("seed/version"), seed);
        FileUtil.copyToDir(this.ebuild.getFile("seed/build.xml"), seed);
        File archive = new File(this.options.outputDirectory, String.valueOf(sourceReleaseName) + "-source.zip");
        this.log("Archiving library as: " + this.ebuild.formatAsDisplayPath(archive));
        ZipUtil.zipDirectoryIncludeName(archive, releaseDir);
        FileUtil.deleteDir(releaseDir);
    }

    private void doCopy(File f, File toDir) throws IOException {
        this.log("  <-" + this.ebuild.formatAsDisplayPath(f));
        FileUtil.copyToDir(f, toDir);
    }

    private void copyToReleaseLib(File releaseLib, ElementRelease builtRelease) throws IOException {
        Object builtPart = builtRelease.cElement.element;
        File builtMeta = new File(((Element)builtPart).getMetaDirectory(), EBuildUtil.elementType2xmlName(((Element)builtPart).getType()));
        File builtPlugin = new File(((Element)builtPart).getMetaDirectory(), "build-plugin.xml");
        File releasePartDir = ((Element)builtPart).key.getSubDirectory(releaseLib);
        File releaseReleaseDir = new File(releasePartDir, "release");
        File releaseMetaDir = new File(releasePartDir, "meta");
        releaseReleaseDir.mkdirs();
        releaseMetaDir.mkdirs();
        this.doCopy(builtRelease.getFile(), releaseReleaseDir);
        this.doCopy(builtMeta, releaseMetaDir);
        if (builtPlugin.exists()) {
            this.doCopy(builtPlugin, releaseMetaDir);
        }
    }

    void copyReleases() throws Exception {
        File releaseDir;
        File releaseLib = this.options.outputLibrary;
        if (releaseLib != null) {
            this.log("");
            this.log("Releasing to library: " + this.ebuild.formatAsDisplayPath(releaseLib));
            ModuleDeps.GathererOfReleases gatherer = new ModuleDeps.GathererOfReleases(Module.NOAPI);
            for (ElementC elementC : this.selectedCElements) {
                if (elementC.element instanceof Module) {
                    ModuleDeps deps = (ModuleDeps)elementC.getDependencies(Scope.MAIN);
                    deps.startDeepGather(gatherer, false, false);
                }
                gatherer.releases.add(elementC.release);
            }
            for (ElementRelease elementRelease : gatherer.releases) {
                this.copyToReleaseLib(releaseLib, elementRelease);
            }
        }
        if ((releaseDir = this.options.outputDirectory) != null) {
            releaseDir.mkdirs();
            this.log("");
            this.log("Copying released components to " + this.ebuild.formatAsDisplayPath(releaseDir));
            for (ElementC elementC : this.selectedCElements) {
                if (!(elementC.element instanceof Product)) continue;
                ProductRelease release = (ProductRelease)elementC.release;
                this.doCopy(release.getFile(), releaseDir);
            }
        }
    }

    @Override
    public String getKey() {
        return "release";
    }

    @DisplayOrder(value={"org", "name", "branch", "revision", "tag", "confs", "", "output-library", "output-directory"})
    public static class Options
    extends EBuild.Options {
        public File optionsFile;
        public ElementType elementType;
        public String org;
        public String name;
        public String branch;
        public String revision;
        public String tag;
        public String confs;
        public boolean source;
        public File outputLibrary;
        public File outputDirectory;

        boolean hasTag() {
            return !StringUtil.isEmptyString(this.tag);
        }
    }
}

