/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.run;

import ebuild.base.EBuildException;
import ebuild.core.EBuild;
import ebuild.core.EBuildRunner;
import ebuild.core.Element;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.impl.SubKey;
import ebuild.core.impl.Task;
import ebuild.options.DisplayOrder;
import ebuild.options.OptionsBuilder;
import ebuild.options.OptionsUtil;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceRunner
extends EBuildRunner {
    final Options options;

    public static void run(ClassLoader apiClassLoader, String[] args) throws Exception {
        if (OptionsUtil.isPrintOptions(args)) {
            System.err.println(OptionsUtil.formatOptions(Options.class));
        } else {
            System.err.println("Pass argument ? to print out options");
            Options optionsObj = new Options();
            OptionsBuilder optionsBuilder = new OptionsBuilder(optionsObj);
            Map<String, String> optionsMap = OptionsUtil.read(args);
            optionsBuilder.merge(optionsMap);
            List<String> errors = optionsBuilder.check();
            if (!optionsObj.home.exists()) {
                errors.add("_ebuild directory does not exist: " + optionsObj.home);
            }
            if (errors.size() > 0) {
                for (String e : errors) {
                    System.err.println(e);
                }
                System.exit(1);
            }
            WorkspaceRunner doWorkspace = new WorkspaceRunner(apiClassLoader, optionsObj);
            doWorkspace.formatOptionValues(optionsBuilder.getSetOptions());
            doWorkspace.run();
        }
    }

    public WorkspaceRunner(ClassLoader apiClassLoader, Options options) {
        super(apiClassLoader, options);
        this.options = options;
    }

    private void formatOptionValues(final Set<String> set) {
        this.log("////////////////////////////////////////////////////////////");
        this.log(OptionsUtil.formatOptionValues((Object)this.options, new CollectionUtil.Filter<String>(){

            @Override
            public boolean accept(String f) {
                Object v = OptionsUtil.getValue(WorkspaceRunner.this.options, f);
                if ("noSkipping".equals(f) || "verbose".equals(f) || "debug".equals(f)) {
                    return v == Boolean.TRUE;
                }
                if ("home".equals(f)) {
                    return !"../_ebuild".equals(f) || WorkspaceRunner.this.options.debug;
                }
                return set.contains(f);
            }
        }));
        this.log("////////////////////////////////////////////////////////////");
        this.log("");
    }

    @Override
    public void go() throws Exception {
        Task task = this.options.task;
        Element element = this.resolveFirst(this.options.projectDir);
        ConfSet confSet = EBuildUtil.parseConfSet(this.options.confs);
        this.go(element.getCPart(new SubKey(confSet, null)), task);
    }

    private Element resolveFirst(File projectDir) throws EBuildException {
        EKey elementKey = EKey.newWorkingKey(null, projectDir);
        Element r = this.ebuild.resolveWorkspaceElement(elementKey);
        if (r == null) {
            this.log("Not an ebuild project.");
            System.exit(1);
        }
        return r;
    }

    @Override
    public String getKey() {
        return "workspace";
    }

    @DisplayOrder(value={"task", "confs", "projectDir", ""})
    public static class Options
    extends EBuild.Options {
        public Task task = Task.eclipse_setup;
        public String confs = "";
        public File projectDir = FileUtil.canonicalFile(new File("."));
    }
}

