/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import ebuild.api.log.ILogger;
import ebuild.api.log.ISwitch;
import ebuild.util.ObjectUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Logger
implements ILogger {
    private static ISwitch ALWAYS_ON = new ISwitch(){

        public boolean isOn() {
            return true;
        }
    };
    private static PrintStream system_err = System.err;
    private static String SEPARATOR;
    static Logger current;
    final ISwitch onSwitch;
    final Logger parent;
    final PrintStream out;
    final String name;
    final String indent;
    final String prefix;
    final Object identity;
    private String provisionalHeader;

    private static PrintStream newInterceptStream(final char m) {
        return new PrintStream(new OutputStream(){
            private boolean nl = true;

            public void write(int b) throws IOException {
                if (this.nl) {
                    Logger.current.out.print(Logger.current.indent + m + " ");
                    this.nl = false;
                }
                if (10 == b) {
                    this.nl = true;
                }
                Logger.current.out.print((char)b);
            }
        });
    }

    private static void interceptStd() {
        System.setErr(Logger.newInterceptStream('!'));
        System.setOut(Logger.newInterceptStream('~'));
    }

    public static Logger newRootLogger() {
        return Logger.newRootLogger(system_err);
    }

    public static Logger newRootLogger(PrintStream out) {
        return new Logger(out);
    }

    private Logger(PrintStream out) {
        this.onSwitch = ALWAYS_ON;
        this.parent = null;
        this.name = null;
        this.indent = "";
        this.prefix = " ";
        this.out = out;
        this.identity = this;
        current = this;
    }

    private Logger(Logger parent, String name, ISwitch onSwitch, String indent, String prefix, Object identity) {
        this.onSwitch = onSwitch;
        this.parent = parent;
        this.name = name;
        this.out = parent.out;
        this.indent = indent;
        this.prefix = prefix;
        this.identity = identity == null ? this : identity;
    }

    public boolean isOn() {
        if (this.parent != null && !this.parent.isOn()) {
            return false;
        }
        return this.onSwitch.isOn();
    }

    private boolean isAncestorOf(Logger l) {
        if (l == null) {
            return false;
        }
        if (this.identity.equals(l.identity)) {
            return true;
        }
        return this.isAncestorOf(l.parent);
    }

    private boolean isSameIndentation(Logger l) {
        return this.identity.equals(l.identity);
    }

    private String padSeparator(String s) {
        return s + SEPARATOR.substring(Math.min(SEPARATOR.length(), s.length()));
    }

    public Logger newSubLogger(String name) {
        return this.newSubLogger(name, null);
    }

    public Logger newSubLogger(ISwitch onSwitch) {
        return this.newSubLogger(null, onSwitch);
    }

    public Logger newSubLogger(String name, ISwitch onSwitch) {
        return this.newSubLogger(name, onSwitch, "| ");
    }

    public Logger newSubLogger(String name, ISwitch onSwitch, String prefix2) {
        Object identity2;
        String indent2;
        if (onSwitch == null) {
            onSwitch = ALWAYS_ON;
        }
        if (name == null) {
            indent2 = this.indent;
            identity2 = this.identity;
        } else {
            indent2 = "";
            Logger p = this;
            while (p != null) {
                indent2 = indent2 + "    ";
                p = p.parent;
            }
            identity2 = null;
        }
        prefix2 = indent2 + prefix2;
        return new Logger(this, name, onSwitch, indent2, prefix2, identity2);
    }

    public void prime() {
        if (!this.isSameIndentation(current)) {
            if (this.isAncestorOf(current)) {
                this.out.println(this.padSeparator(this.indent));
            } else {
                if (this.parent != null && this.parent != current && this.parent != Logger.current.parent) {
                    this.parent.log("");
                }
                int insetLength = this.indent.length() - Logger.current.indent.length();
                String inset = SEPARATOR.substring(0, Math.max(0, insetLength));
                this.out.println(this.padSeparator(Logger.current.indent + inset + "-------- " + this.name + " "));
            }
            current = this;
        }
    }

    private void doLog(String msg) {
        if (msg == null) {
            this.out.print(this.prefix);
            this.out.println("*null*");
        } else {
            String[] lines;
            for (String l : lines = msg.split("\n")) {
                this.out.print(this.prefix);
                this.out.println(l);
            }
        }
    }

    public void log(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.log(sw.toString());
    }

    public void log(String msg) {
        if (this.isOn()) {
            this.prime();
            this.printProvisionalHeading();
            this.doLog(msg);
        }
    }

    public void logPartial(String msg) {
        if (this.isOn()) {
            this.printProvisionalHeading();
            this.out.print(msg);
            this.out.flush();
        }
    }

    private String getProvisionalHeading() {
        String r = null;
        if (this.parent != null) {
            r = this.parent.getProvisionalHeading();
        }
        if (r == null) {
            r = this.provisionalHeader;
        }
        return r;
    }

    private void printProvisionalHeading() {
        String h;
        while ((h = this.getProvisionalHeading()) != null) {
            this.doLog(h);
            this.unsetProvisionalHeading(h);
        }
    }

    public void setProvisionalHeading(String provisionalHeader) {
        this.provisionalHeader = provisionalHeader;
    }

    private void unsetProvisionalHeading(String provisionalHeader) {
        if (this.provisionalHeader == provisionalHeader) {
            this.provisionalHeader = null;
        }
        if (this.parent != null) {
            this.parent.unsetProvisionalHeading(provisionalHeader);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Logger b = (Logger)obj;
        if (!ObjectUtil.areEqual(this.parent, b.parent)) {
            return false;
        }
        return ObjectUtil.areEqual(this.name, b.name);
    }

    static {
        Logger.interceptStd();
        SEPARATOR = "------------------------------------------------------------------------------------------------------------------------";
    }
}

