/*
 * Decompiled with CFR 0.152.
 */
package ebuild.version;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EBuildVersion {
    _0_7("0.7"),
    _0_8("0.8");

    public final String string;
    static final String VALID_VERSIONS = "0.7,0.8";
    static Map<String, EBuildVersion> map;

    static {
        map = new HashMap<String, EBuildVersion>(EBuildVersion.values().length + 1);
        String[] stringArray = VALID_VERSIONS.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String k = "_" + s.replace('.', '_');
            EBuildVersion v = EBuildVersion.valueOf(k);
            if (v == null) {
                throw new Error("Invalid version: " + s);
            }
            map.put(s, v);
            ++n2;
        }
        map.put("pre-1.0", _0_7);
    }

    private EBuildVersion(String string2) {
        this.string = string2;
    }

    public String toString() {
        return this.string;
    }

    public static EBuildVersion getLatest() {
        return _0_8;
    }

    public static EBuildVersion readVersion(Reader reader) throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader xreader = factory.createXMLStreamReader(reader);
        xreader.nextTag();
        String versionAttr = xreader.getAttributeValue(null, "ebuild-version");
        if (versionAttr == null) {
            throw new Exception("No 'ebuild-version' attribute defined in root element");
        }
        Object[] versions = versionAttr.split(",");
        Arrays.sort(versions);
        EBuildVersion r = null;
        Object[] objectArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            EBuildVersion ebv = map.get(v);
            if (ebv != null) {
                r = ebv;
            }
            ++n2;
        }
        if (r == null) {
            throw new Exception("Unsupported format-version attribute defined in root element: " + versionAttr);
        }
        return r;
    }

    public static EBuildVersion readVersion(File f) throws Exception {
        FileReader r = new FileReader(f);
        try {
            EBuildVersion eBuildVersion = EBuildVersion.readVersion(r);
            return eBuildVersion;
        }
        finally {
            r.close();
        }
    }
}

