/*
 * Decompiled with CFR 0.152.
 */
package ebuild.xml;

import ebuild.version.EBuildVersion;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.HyphenStyle;

public class CmnXml {
    private static Serializer serializer;

    public static Serializer getSerializer() {
        if (serializer == null) {
            HyphenStyle style = new HyphenStyle();
            Format format = new Format(style);
            TreeStrategy strategy = new TreeStrategy("__class__", "__length__");
            serializer = new Persister((Strategy)strategy, format);
        }
        return serializer;
    }

    public static void serialize(Writer w, EBuildRoot obj) throws Exception {
        Serializer serializer = CmnXml.getSerializer();
        serializer.write((Object)obj, w);
    }

    public String toString() {
        try {
            return CmnXml.writeString(CmnXml.getSerializer(), this);
        }
        catch (Exception e) {
            return "?" + e.getMessage();
        }
    }

    public static String writeString(Serializer serializer, Object obj) throws Exception {
        StringWriter sw = new StringWriter();
        serializer.write(obj, sw);
        return sw.toString();
    }

    public static class BasicSelect
    extends CmnXml
    implements Version {
        @Attribute(required=false)
        public String org;
        @Attribute(required=false)
        public String name;
        @Attribute(required=false)
        public String branch;
        @Attribute(required=false)
        public String revision;
        @Attribute(required=false)
        public String tag;

        public boolean specifiesVersion() {
            return this.hasTag() || this.hasRevision();
        }

        public boolean hasRevision() {
            return this.branch != null || this.revision != null;
        }

        public boolean hasTag() {
            return this.getTag() != null;
        }

        public String getBranch() {
            return this.branch;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getTag() {
            return this.tag;
        }
    }

    public static class Builder
    extends SelectWithSource {
        @Attribute(required=false)
        public String id;
        @Attribute(required=false)
        public String refid;
        @Attribute(required=false)
        public Boolean intermediate;
        @ElementList(empty=false, required=false, inline=true)
        public List<Property> propertiesList;

        public boolean isRefId() {
            return this.refid != null;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class Configuration
    extends CmnXml {
        @Attribute
        public String name;
        @Attribute(required=false)
        public boolean alias = false;
        @Attribute(required=false)
        public String includes;
    }

    public static abstract class EBuildElement
    extends EBuildRoot {
        @ElementList(required=false, empty=false)
        public List<Configuration> configurations;
    }

    public static abstract class EBuildRoot
    extends CmnXml {
        private EBuildVersion ebuildVersion_;
        @Attribute
        public String ebuildVersion;
        @ElementList(empty=false, required=false)
        public List<Repository> repositories;
        @ElementList(empty=false, required=false, inline=true)
        public List<Using> usings;

        public EBuildVersion getEBuildVersion() {
            return this.ebuildVersion_;
        }

        public void setEBuildVersion(EBuildVersion v) {
            this.ebuildVersion_ = v;
        }
    }

    public static class Property
    extends Value {
        @Attribute
        public String key;
        @Attribute(required=false)
        public String conf;
    }

    public static class Repository
    extends CmnXml
    implements Version {
        @Attribute
        public String name;
        @Attribute(required=false)
        public String ref;
        @Attribute(required=false)
        public String type;
        @Attribute(required=false)
        public String url;
        @Attribute(required=false)
        public String org;
        @Attribute(required=false)
        public String branch;
        @Attribute(required=false)
        public String revision;
        @Attribute(required=false)
        public String tag;

        public String getBranch() {
            return this.branch;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getTag() {
            return this.tag;
        }
    }

    public static class SelectAndMap
    extends SelectWithSource {
        @Attribute(required=false)
        public String artifact;
        @Attribute(required=false)
        public String scope;
        @Attribute(required=false)
        public String conf;
        @Attribute(required=false)
        public String scopeMapping;
        @Attribute(required=false)
        public String confMapping;
    }

    public static class SelectWithSource
    extends BasicSelect {
        @Attribute(required=false)
        public String source;
        @Deprecated
        @Attribute(required=false)
        public String version;

        public String getTag() {
            return this.tag == null ? this.version : this.tag;
        }

        public boolean isRefId() {
            return false;
        }

        public String getId() {
            return null;
        }
    }

    public static class Using
    extends SelectWithSource {
        @Attribute(required=false)
        public Context context = Context.main;

        public boolean isBuild() {
            return this.context == Context.build;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Context {
            main,
            build;

        }
    }

    public static class Value
    extends CmnXml {
        @Attribute(required=false)
        private String value;
        @Text(required=false)
        private String text;

        public Object getValue() {
            return this.value != null ? this.value : (this.text != null ? this.text : null);
        }
    }

    public static interface Version {
        public String getTag();

        public String getBranch();

        public String getRevision();
    }
}

