/*
 * Decompiled with CFR 0.152.
 */
package ebuild.launch;

import ebuild.api.core.IEBuildRunner;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;

public class LaunchUtil {
    public static final String PROP_CORE_PATH = "ebuild.core.path";

    public static ClassLoader getClassLoader() {
        URL[] sysUrlsArr;
        HashSet<URL> parentUrls = new HashSet<URL>();
        URLClassLoader parentCL = (URLClassLoader)LaunchUtil.class.getClassLoader();
        URL[] uRLArray = sysUrlsArr = parentCL.getURLs();
        int n = sysUrlsArr.length;
        int n2 = 0;
        while (n2 < n) {
            URL u = uRLArray[n2];
            parentUrls.add(u);
            ++n2;
        }
        String path = System.getProperty(PROP_CORE_PATH);
        if (path == null) {
            throw new Error("System property 'ebuild.core.path' not set!");
        }
        try {
            String[] ps = path.split("[\n:;]");
            ArrayList<URL> urls = new ArrayList<URL>(ps.length);
            int i = 0;
            while (i < ps.length) {
                URL url = new File(ps[i]).toURI().toURL();
                if (!parentUrls.contains(url)) {
                    urls.add(url);
                }
                ++i;
            }
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)parentCL);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static IEBuildRunner instantiateRunner(String runnerClass) throws Exception {
        ClassLoader cl = LaunchUtil.getClassLoader();
        Class<?> c = cl.loadClass(runnerClass);
        return (IEBuildRunner)c.newInstance();
    }
}

