/*
 * Decompiled with CFR 0.152.
 */
package ebuild.base;

import ebuild.api.log.ISwitch;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.base.EBuildException;
import ebuild.base.ReportBuilder;
import ebuild.util.Logger;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

public class EBuildLogger
extends Logger {
    public final List<Logger.Warning> warnings;
    final boolean debug;
    private final EBuildLogger parent;

    public static EBuildLogger newRootLogger(boolean debug) {
        return EBuildLogger.newRootLogger(debug, system_err);
    }

    public static EBuildLogger newRootLogger(boolean debug, PrintStream out) {
        return new EBuildLogger(out, debug);
    }

    protected EBuildLogger(PrintStream out, boolean debug) {
        super(out);
        this.debug = debug;
        this.parent = null;
        this.warnings = new LinkedList<Logger.Warning>();
    }

    protected EBuildLogger(EBuildLogger parent, String name, ISwitch onSwitch, String indent, String prefix, Object identity) {
        super(parent, name, onSwitch, indent, prefix, identity);
        this.debug = parent.debug;
        this.warnings = null;
        this.parent = parent;
    }

    protected EBuildLogger newSubLoggerInstance(String name, ISwitch onSwitch, String indent2, String prefix2, Object identity2) {
        return new EBuildLogger(this, name, onSwitch, indent2, prefix2, identity2);
    }

    private void addWarning(Logger.Warning w) {
        if (this.parent == null) {
            this.warnings.add(w);
        } else {
            this.parent.addWarning(w);
        }
    }

    protected void doLogWarning(Logger.Warning w) {
        this.addWarning(w);
        ReportBuilder.Stream report = new ReportBuilder.Stream(this.out);
        this.printReportOfWarning(report, w);
    }

    public void printReportOfWarning(ReportBuilder report, Logger.Warning warning) {
        report.line("[WARNING]" + warning.message);
        if (warning.throwable != null) {
            this.printReportOfException(report, warning.throwable);
        }
    }

    public void printReportOfError(ReportBuilder report, Throwable t, String versionCode) {
        report.line("");
        report.header("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        report.header("!!!!!!!!! ERROR          (" + versionCode + ") !!!!!!");
        report.header("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        report.line("");
        this.printReportOfException(report, t);
        report.line("");
        report.header("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
    }

    public void printReportOfException(ReportBuilder report, Throwable t) {
        StackTraceElement[] causedTrace = null;
        while (true) {
            report.line("" + t);
            Throwable c = t.getCause();
            boolean handled = t instanceof EBuildException || t instanceof RepositoryPluginException || t instanceof BuildPluginException;
            StackTraceElement[] trace = t.getStackTrace();
            if (!handled || this.debug) {
                if (causedTrace == null) {
                    int i = 0;
                    while (i < trace.length) {
                        report.line("\tat " + trace[i]);
                        ++i;
                    }
                } else {
                    int m = trace.length - 1;
                    int n = causedTrace.length - 1;
                    while (m >= 0 && n >= 0 && trace[m].equals(causedTrace[n])) {
                        --m;
                        --n;
                    }
                    int framesInCommon = trace.length - 1 - m;
                    int i = 0;
                    while (i <= m) {
                        report.line("\tat " + trace[i]);
                        ++i;
                    }
                    if (framesInCommon != 0) {
                        report.line("\t... " + framesInCommon + " more");
                    }
                }
            }
            boolean handledCause = false;
            if (t instanceof EBuildException) {
                handledCause = ((EBuildException)t).handledCause;
            }
            if (c == null || t == c || handledCause && !this.debug) break;
            report.line("... caused by ...");
            t = c;
            causedTrace = trace;
        }
    }

    public void printReportOfWarnings(ReportBuilder report) {
        if (this.warnings.size() > 0) {
            report.header("?????????????????????????????????????????????????????????");
            report.header("??????? The were " + this.warnings.size() + " warnings!? ??");
            report.header("?????????????????????????????????????????????????????????");
            report.line("");
            for (Logger.Warning w : this.warnings) {
                this.printReportOfWarning(report, w);
            }
            report.line("");
            report.header("?????????????????????????????????????????????????????????");
            report.line("");
        }
    }
}

