/*
 * Decompiled with CFR 0.152.
 */
package ebuild.base;

import ebuild.base.BuildPluginType;
import ebuild.base.EBuildException;
import ebuild.base.PathJanitor;
import ebuild.util.FileUtil;
import ebuild.util.StringUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUtil {
    public static String displayClassloader(PathJanitor janitor, ClassLoader cl) {
        if (cl instanceof URLClassLoader) {
            StringBuilder r = new StringBuilder();
            URL[] urls = ((URLClassLoader)cl).getURLs();
            int i = 0;
            while (i < urls.length) {
                r.append("    " + janitor.formatAsDisplayPath(new File(urls[i].getFile())) + "\n");
                ++i;
            }
            return r.toString();
        }
        return "   (cannot display) " + cl;
    }

    public static URL[] asURLArray(Collection<String> classPath) throws EBuildException {
        ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
        for (String s : classPath) {
            File f = new File(s);
            if (!f.exists()) {
                throw EBuildException.newInternalError("Non existent file: " + FileUtil.canonicalFile(f));
            }
            try {
                urls.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new Error(e);
            }
        }
        return urls.toArray(new URL[classPath.size()]);
    }

    public static ClassLoader newUrlClassLoader(ClassLoader parent, Collection<String> classPath) throws EBuildException {
        URL[] urlArray = PluginUtil.asURLArray(classPath);
        return new URLClassLoader(urlArray, parent);
    }

    public static ClassLoader createPluginClassLoader(BuildPluginType pluginType, ClassLoader apiClassLoader, Collection<String> classPath) throws EBuildException {
        if (BuildPluginType.COMPAT == pluginType) {
            HashSet<String> compatApiCP = new HashSet<String>();
            HashSet<String> compatImplCP = new HashSet<String>();
            for (String s : classPath) {
                String fname = new File(s).getName();
                if (fname.contains("ebuild-api")) {
                    compatApiCP.add(s);
                    continue;
                }
                compatImplCP.add(s);
            }
            if (compatApiCP.size() == 0) {
                throw EBuildException.newInternalError("Expected api part:\n    " + StringUtil.join("\n    ", classPath));
            }
            ClassLoader compatApiCL = PluginUtil.newUrlClassLoader(apiClassLoader, compatApiCP);
            ClassLoader compatImplCL = PluginUtil.newUrlClassLoader(compatApiCL, compatImplCP);
            return compatImplCL;
        }
        return PluginUtil.newUrlClassLoader(apiClassLoader, classPath);
    }

    public static Object instantiate(PathJanitor janitor, ClassLoader cl, String class_) throws EBuildException {
        ClassLoader callingCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> pluginClass = cl.loadClass(class_);
            Object obj = pluginClass.newInstance();
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String msg = "Unable to instantiate plugin '" + class_ + "': class does not exist\n" + "Classpath:\n" + PluginUtil.displayClassloader(janitor, cl);
            throw EBuildException.newPluginProblem(msg);
        }
        catch (Exception e) {
            throw EBuildException.newPluginProblem("Could not instantiate plugin", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(callingCL);
        }
    }
}

