/*
 * Decompiled with CFR 0.152.
 */
package ebuild.base;

import ebuild.util.StringUtil;
import java.io.PrintStream;

public abstract class ReportBuilder {
    protected abstract void output(String var1);

    protected void outputn(String msg) {
        this.output(msg);
        this.output("\n");
    }

    public void header(String msg) {
        char padding = msg.charAt(0);
        this.outputn(StringUtil.rpad(120, msg, padding));
    }

    public void line(String msg) {
        this.outputn(msg);
    }

    public static class Memory
    extends ReportBuilder {
        final StringBuilder sb = new StringBuilder(1024);

        protected void output(String msg) {
            this.sb.append(msg);
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    public static class Stream
    extends ReportBuilder {
        final PrintStream out;

        public Stream(PrintStream out) {
            this.out = out;
        }

        protected void output(String msg) {
            this.out.print(msg);
        }
    }
}

