/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.IConfiguration;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractReleaseRepository;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.core.ActionStatus;
import ebuild.core.BuildProject;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementRelease;
import ebuild.core.ModuleC;
import ebuild.core.ModuleRelease;
import ebuild.core.ProductRelease;
import ebuild.core.WorkspaceProject;
import ebuild.core.util.WorkMarker;
import ebuild.util.ObjectUtil;
import ebuild.util.StringUtil;
import java.io.File;
import java.util.Map;

public abstract class Action {
    public final Element element;
    public final ElementC elementC;
    private ActionStatus status;

    private static ActionStatus marker2status(WorkMarker marker) {
        if (marker.isInProgress()) {
            return ActionStatus.dirty;
        }
        if (marker.isComplete()) {
            return ActionStatus.done;
        }
        return ActionStatus.todo;
    }

    private Action(Element element, ElementC elementC) {
        this.element = element;
        this.elementC = elementC;
    }

    public Action(ElementC cElement) {
        this((Element)cElement.element, cElement);
    }

    public abstract String getDisplayName();

    public abstract void run(ILogger var1) throws Exception;

    public abstract ActionStatus checkStatus() throws Exception;

    public ActionStatus getStatus() throws Exception {
        if (this.status == null) {
            this.status = this.checkStatus();
        }
        return this.status;
    }

    public void finish(boolean skipped) throws Exception {
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.element) + ObjectUtil.hashOf(this.elementC);
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Action b = (Action)obj;
        if (!this.element.equals(b.element)) {
            return false;
        }
        return ObjectUtil.areEqual(this.elementC, b.elementC);
    }

    public String format() {
        return String.valueOf(StringUtil.rpad(16, this.getDisplayName())) + " " + this.element.key.toString() + (this.elementC == null ? "" : " " + this.elementC.key.subkey);
    }

    public String toString() {
        return this.format();
    }

    /* synthetic */ Action(Element element, ElementC elementC, Action action) {
        this(element, elementC);
    }

    static class BuildClean
    extends Action {
        public BuildClean(ElementC cElement) {
            super(cElement);
        }

        public String getDisplayName() {
            return "build clean";
        }

        public ActionStatus checkStatus() throws Exception {
            return this.element.buildIsClean() ? ActionStatus.done : ActionStatus.todo;
        }

        public void run(ILogger logger) throws Exception {
            this.element.buildClean();
        }
    }

    static class BuildRelease
    extends Action {
        public BuildRelease(ElementC elementC) {
            super(elementC);
        }

        public ActionStatus checkStatus() throws Exception {
            BuildProject bproject = this.elementC.createBuildProject();
            if (bproject.isDirty(Scope.MAIN)) {
                return ActionStatus.dirty;
            }
            if (bproject.isClean()) {
                return ActionStatus.todo;
            }
            return ActionStatus.done;
        }

        public String getDisplayName() {
            return "build release";
        }

        public void run(ILogger logger) throws Exception {
            BuildProject proj = this.elementC.build;
            if (this.getStatus() == ActionStatus.dirty) {
                proj.clean();
            }
            proj.build();
        }

        public void finish(boolean skipped) throws Exception {
            if (this.elementC instanceof ModuleC) {
                ModuleC moduleC = (ModuleC)this.elementC;
                moduleC.registerRelease();
            }
        }
    }

    static class EclipseSetup
    extends Action {
        public EclipseSetup(ElementC cElement) {
            super(cElement);
        }

        public ActionStatus checkStatus() throws Exception {
            WorkspaceProject eproject = this.elementC.createEclipseProject();
            ActionStatus status = eproject.isProjectDirty() ? ActionStatus.dirty : ActionStatus.todo;
            return status;
        }

        public String getDisplayName() {
            return "eclipse setup";
        }

        public void run(ILogger logger) throws Exception {
            WorkspaceProject proj = this.elementC.eclipse;
            if (this.getStatus() == ActionStatus.dirty) {
                proj.unsetup();
            }
            proj.setup();
        }
    }

    static class EclipseUnsetup
    extends Action {
        public EclipseUnsetup(ElementC cElement) {
            super(cElement);
        }

        public ActionStatus checkStatus() throws Exception {
            return ActionStatus.todo;
        }

        public String getDisplayName() {
            return "eclipse unsetup";
        }

        public void run(ILogger logger) throws Exception {
            this.elementC.eclipse.unsetup();
        }
    }

    static class FetchArtifacts
    extends Action {
        public FetchArtifacts(ElementC cElement) {
            super((Element)cElement.element, cElement, null);
        }

        private boolean isModule() {
            return ((Element)this.elementC.element).key.type == ElementType.module;
        }

        public String getDisplayName() {
            return "fetch artifacts";
        }

        public ActionStatus checkStatus() throws Exception {
            Map rs = this.elementC.getReleases();
            ActionStatus r = ActionStatus.done;
            for (ElementRelease mr : rs.values()) {
                WorkMarker marker = mr.getWorkMarker();
                ActionStatus status = Action.marker2status(marker);
                if (status == ActionStatus.dirty) {
                    return ActionStatus.dirty;
                }
                if (r == null) {
                    r = status;
                    continue;
                }
                if (r == status) continue;
                return ActionStatus.dirty;
            }
            return r;
        }

        public void run(ILogger logger) throws Exception {
            Map rs = this.elementC.getReleases();
            AbstractReleaseRepository repo = (AbstractReleaseRepository)this.element.getRepository();
            for (ElementRelease er : rs.values()) {
                WorkMarker marker = er.getWorkMarker();
                marker.create();
                if (this.isModule()) {
                    File dir = new File(this.elementC.getReleaseDirectory(), "/main");
                    String filename = ((ModuleRelease)er).artifactFile.getName();
                    repo.fetchModuleRelease(dir, (IElementKey)this.element.key, (IConfiguration)this.elementC.getConfiguration(), filename);
                } else {
                    String filename = ((ProductRelease)er).artifactFile.getName();
                    repo.fetchComponentRelease(this.element.getReleaseDirectory(), (IElementKey)this.element.key, filename);
                }
                marker.remove();
            }
        }

        public void finish(boolean skipped) throws Exception {
            if (this.elementC instanceof ModuleC) {
                ModuleC moduleC = (ModuleC)this.elementC;
                moduleC.registerRelease();
            }
        }
    }

    static class FetchSource
    extends Action {
        final WorkMarker marker;

        public FetchSource(WorkMarker marker, Element element) {
            super(element, null, null);
            this.marker = marker;
        }

        public ActionStatus checkStatus() throws Exception {
            return Action.marker2status(this.marker);
        }

        public String getDisplayName() {
            return "fetch source";
        }

        public void run(ILogger logger) throws Exception {
            assert (!this.element.isWorkspace());
            this.marker.create();
            logger.log(String.valueOf(this.element.key.fullnameAndVersionAndUniverse()) + " -> fetching source");
            AbstractSourceRepository repo = (AbstractSourceRepository)this.element.getRepository();
            repo.fetchProject(this.element.getProjectDirectory(), (IElementKey)this.element.key);
            this.marker.remove();
        }
    }
}

