/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPluginDef;
import ebuild.core.BuildResolutionReport;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementDeps;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ModuleC;
import ebuild.core.ProjectHelper;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.Task;
import ebuild.core.impl.TaskSet;
import ebuild.core.util.WorkMarker;
import ebuild.xml.CmnXml;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class BuildPlan {
    final EBuild ebuild;
    final BuildResolutionReport report;
    final Object key;
    protected Set<Object> builderPlans = new LinkedHashSet<Object>();
    private boolean resolvedAndConfigured = false;

    public BuildPlan(EBuild ebuild, Object key) {
        this.ebuild = ebuild;
        this.report = ebuild.report;
        this.key = key;
        ebuild.buildPlans.put(this.getKey(), this);
    }

    public Object getKey() {
        return this.key;
    }

    protected abstract void resolveBuilders(TaskSet var1) throws EBuildException;

    protected abstract void resolveAndConfigureDependencies(TaskSet var1) throws EBuildException;

    protected abstract void buildActionListForPlan(ActionQueue var1, TaskSet var2) throws Exception;

    private TaskSet buildTasks(TaskSet tasks) {
        if (this instanceof ModuleBuildPlan) {
            return tasks.tasksForBuilders();
        }
        return tasks;
    }

    public void resolveAndConfigure(TaskSet tasks) throws EBuildException {
        if (this.resolvedAndConfigured) {
            return;
        }
        Object key = this.getKey();
        Backtrace.startTop("resolve and configure", key);
        try {
            this.resolveAndConfigureDependencies(tasks);
            this.resolveBuilders(tasks);
            TaskSet btasks = this.buildTasks(tasks);
            for (Object subKey : this.builderPlans) {
                ModuleBuildPlan subPlan = (ModuleBuildPlan)this.ebuild.buildPlans.get(subKey);
                subPlan.resolveAndConfigure(btasks);
            }
            this.resolvedAndConfigured = true;
        }
        finally {
            Backtrace.endTop(key);
        }
    }

    public void buildActionList(ActionQueue queue, TaskSet tasks) throws Exception {
        TaskSet btasks = this.buildTasks(tasks);
        for (Object subKey : this.builderPlans) {
            BuildPlan subPlan = this.ebuild.buildPlans.get(subKey);
            subPlan.buildActionList(queue, btasks);
        }
        this.buildActionListForPlan(queue, tasks);
    }

    protected void buildActionListForPart(ActionQueue queue, ElementC cElement, TaskSet tasks) throws Exception {
        for (Task t : tasks) {
            this.buildActionListForPart(queue, cElement, t);
        }
    }

    protected void buildActionListForPart(ActionQueue queue, ElementC cElement, Task task) throws Exception {
        Object element = cElement.getPart();
        if (!((Element)element).isWorkspace()) {
            if (((Element)element).isSource()) {
                WorkMarker marker = new WorkMarker(((Element)element).getProjectDirectory());
                Action.FetchSource action = new Action.FetchSource(marker, (Element)element);
                queue.add(action);
            } else {
                queue.add(new Action.FetchArtifacts(cElement));
            }
            if (task.isIDE()) {
                throw new Error("Tried to do IDE task on a library element: " + cElement);
            }
            if (task == Task.fetch_source) {
                return;
            }
        }
        switch (task) {
            case build_release: {
                if (!((Element)element).isSource()) break;
                queue.add(new Action.BuildRelease(cElement));
                break;
            }
            case build_clean: {
                if (!((Element)element).isSource()) break;
                queue.add(new Action.BuildClean(cElement));
                break;
            }
            case eclipse_setup: {
                if (!((Element)element).isWorkspace()) break;
                queue.add(new Action.EclipseSetup(cElement));
                break;
            }
            case eclipse_unsetup: {
                cElement.createEclipseProject();
                queue.add(new Action.EclipseUnsetup(cElement));
            }
        }
    }

    protected void resolveBuildPluginsForPart(ElementC elementC) throws EBuildException {
        Object element = elementC.element;
        if (!((Element)element).isSource()) {
            return;
        }
        ProjectHelper phelper = ((Element)element).getProjectHelper();
        EBuildContext bcontext = phelper.contextOfBuild.resolveSelf();
        ElementDeps deps = elementC.getDependencies(Scope.MAIN);
        Map<Object, CmnXml.SelectBuildPlugin> ds = phelper.getBuildDependencies(elementC.getSubKey());
        for (Object localKey : ds.keySet()) {
            BuildPluginDef pluginDef = bcontext.expectBuildPluginDefByLocalKey(localKey);
            ConfMap bconf = pluginDef.mapping.evaluate(elementC.getConfiguration());
            Module bmodule = pluginDef.module;
            ModuleC bmoduleC = bmodule.getCPart(new ConfKey(bconf));
            ModuleBuildPlan bplan = (ModuleBuildPlan)this.ebuild.buildPlans.get(bmoduleC.key);
            if (bplan == null) {
                bplan = new ModuleBuildPlan(this.ebuild, bmoduleC);
                assert (bplan.getKey().equals(bmoduleC.key));
                assert (this.ebuild.buildPlans.get(bmoduleC.key) != null);
            }
            Backtrace.checkCycle("resolve and configure", bplan.getKey());
            this.builderPlans.add(bplan.getKey());
            deps.addBuilder(bmoduleC);
        }
    }

    public String toString() {
        return "" + this.getKey();
    }
}

