/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.base.EBuildLogger;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.ActionStatus;
import ebuild.core.BuildPlan;
import ebuild.core.EBuild;
import ebuild.core.ElementC;
import ebuild.core.impl.Task;
import ebuild.core.impl.TaskSet;
import ebuild.util.StringUtil;

public abstract class BuildPlanRunner {
    protected abstract EBuild getEBuild();

    protected EBuildLogger getLogger() {
        return this.getEBuild().logger;
    }

    public abstract String getKey();

    public abstract void go() throws Exception;

    protected void log(String msg) {
        this.getLogger().log(msg);
    }

    protected void loge(String msg) {
        String[] stringArray = msg.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.getLogger().log("!! " + s);
            ++n2;
        }
    }

    public void go(ElementC cElement, Task task) throws Exception {
        this.go(this.getEBuild().newBuildPlan(cElement), task);
    }

    public void go(BuildPlan mainPlan, Task task) throws Exception {
        TaskSet tasks = new TaskSet(task);
        this.log("");
        this.log("");
        this.log("////////////////////////////////////");
        this.log("////// Resolve And Configure ///////");
        this.log("");
        this.resolveAndConfigure(mainPlan, tasks);
        this.log("");
        this.log("");
        this.log("////////////////////////////");
        this.log("////// Plan Task List //////");
        this.log("");
        this.buildActionList(mainPlan, tasks);
        this.log("");
        this.log("");
        this.log("//////////////////////////");
        this.log("////// Execute Plan //////");
        this.log("");
        this.run(this.getEBuild().queue);
    }

    protected void resolveAndConfigure(BuildPlan mainPlan, TaskSet tasks) throws EBuildException {
        mainPlan.resolveAndConfigure(tasks);
        if (this.getEBuild().isDEBUG()) {
            this.log("");
            this.log("Build Plans");
            for (Object k : this.getEBuild().buildPlans.keySet()) {
                this.log("  " + k);
            }
        }
    }

    private void buildActionList(BuildPlan mainPlan, TaskSet tasks) throws Exception {
        String key = this.getKey();
        ActionQueue queue = this.getEBuild().queue;
        Backtrace.startTop("plan actions", key);
        try {
            mainPlan.buildActionList(queue, tasks);
        }
        finally {
            Backtrace.endTop(key);
        }
        queue.removeDuplicates();
        for (Action a : queue) {
            this.log("queued " + StringUtil.rpad(7, a.getStatus().displayString()) + " " + a.format());
        }
    }

    private void run(ActionQueue queue) throws Exception {
        for (Action action : queue) {
            if (action.getStatus() == ActionStatus.done && !this.getEBuild().options.noSkipping) {
                this.log("- skipping  " + action + " -");
                this.getLogger().setProvisionalHeading("\n");
                action.finish(true);
                this.getLogger().setProvisionalHeading(null);
                continue;
            }
            this.log("- executing " + action + " -");
            this.getLogger().setProvisionalHeading("\n");
            action.run(this.getLogger());
            action.finish(false);
            this.getLogger().setProvisionalHeading(null);
        }
    }
}

