/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.log.ILogger;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.Element;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.KeyE;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public abstract class BuildResolutionReport {
    final ILogger logger;

    public static BuildResolutionReport newReport(ILogger logger, boolean verbose) {
        if (verbose) {
            return new Verbose(logger);
        }
        return new Terse(logger);
    }

    static String resolutionMessage(KeyE k1, KeyE k2) {
        if (k1.version.equals(k2.version)) {
            return "" + k1;
        }
        return k1 + " -> " + k2.version;
    }

    BuildResolutionReport(ILogger logger) {
        this.logger = logger;
    }

    public void startResolve(EBuildContext context, String dependencyType) {
    }

    public void endResolve() {
    }

    public abstract void resolve(KeyE var1, Element var2);

    public abstract void configure(KeyE var1, ConfMap var2);

    static class Terse
    extends BuildResolutionReport {
        Set done = new HashSet();

        Terse(ILogger logger) {
            super(logger);
        }

        private void log(String msg) {
            if (!this.done.contains(msg)) {
                this.logger.log(msg);
                this.done.add(msg);
            }
        }

        public void resolve(KeyE k0, Element resolved) {
            this.log("  resolve: " + Terse.resolutionMessage(k0, resolved.key));
        }

        public void configure(KeyE key, ConfMap conf) {
            if (!conf.isEmpty()) {
                this.log("configure: " + key + " <--- " + conf);
            }
        }
    }

    static class Verbose
    extends BuildResolutionReport {
        final Stack<EBuildContext> stack = new Stack();
        private String __ = "  ";

        Verbose(ILogger logger) {
            super(logger);
        }

        public void startResolve(EBuildContext context, String dependencyType) {
            this.logger.log(String.valueOf(this.__) + dependencyType + " of " + context);
            this.__ = String.valueOf(this.__) + "    ";
            this.stack.push(context);
        }

        public void endResolve() {
            this.stack.pop();
            this.__ = this.__.substring(0, this.__.length() - 4);
        }

        public void resolve(KeyE k0, Element resolved) {
            this.logger.log(String.valueOf(this.__) + "resolve: " + Verbose.resolutionMessage(k0, resolved.key));
            if (resolved.key.version.isWorking()) {
                EBuild ebuild = resolved.ebuild;
                if (ebuild.workspaceDirs.size() > 1) {
                    this.logger.log(String.valueOf(this.__) + resolved.ebuild.formatAsDisplayPath(resolved.getProjectDirectory()));
                }
            }
        }

        public void configure(KeyE key, ConfMap conf) {
            this.logger.log(String.valueOf(this.__) + "configure: " + key + " <--- " + conf);
        }
    }
}

