/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IEBuild;
import ebuild.api.common.ElementType;
import ebuild.api.common.IElementKey;
import ebuild.api.log.ISwitch;
import ebuild.api.repo.AbstractReleaseRepository;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.base.EBuildException;
import ebuild.base.EBuildLogger;
import ebuild.compat.AbstractCompatability;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.BuildResolutionReport;
import ebuild.core.EBuildContext;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementNature;
import ebuild.core.ElementResolver;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.Product;
import ebuild.core.ProductBuildPlan;
import ebuild.core.RepositoryContext;
import ebuild.core.RepositoryRef;
import ebuild.core.SystemPlugins;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyC;
import ebuild.core.impl.KeyE;
import ebuild.repo.DerivedRepository;
import ebuild.repo.http.HttpRepositoryProvider;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import ebuild.util.JSONUtil;
import ebuild.util.Logger;
import ebuild.version.EBuildVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBuild
implements IEBuild,
ElementResolver {
    public static final Logger ROOT_LOGGER = Logger.newRootLogger();
    final SystemPlugins PLUGINS;
    public final ClassLoader apiClassLoader;
    private final File home;
    public final EBuildContext context;
    public final EBuildLogger logger;
    public final EBuildLogger logger_verbose;
    public final Options options;
    private final boolean inferWorkingCopies;
    final BuildResolutionReport report;
    public final List<File> workspaceDirs;
    private final File libraryDir;
    private final Map<String, AbstractRepositoryProvider> providers = new HashMap<String, AbstractRepositoryProvider>();
    private final Map<KeyE, Element> libraryParts = new HashMap<KeyE, Element>();
    private final Map<KeyE, Element> workspaceParts = new HashMap<KeyE, Element>();
    private final Map<KeyE, KeyE> workspaceMapping = new HashMap<KeyE, KeyE>();
    private AbstractWorkingCopy workspaceWorkingCopy;
    public final ActionQueue queue = new ActionQueue();
    public final Map<Object, BuildPlan> buildPlans = new LinkedHashMap<Object, BuildPlan>();
    final List<String> builtinRepos = CollectionUtil.newList("public      |http |http://repo.ebuild-project.org/download/0.7/", "maven-public|maven|named://maven-public", "ivy-roundup |ivy  |named://ivy-roundup");
    private Map props = null;
    final Map<EBuildVersion, AbstractCompatability> compatabilities = new HashMap<EBuildVersion, AbstractCompatability>(2);

    public EBuild(ClassLoader apiClassLoader, Options options) {
        this(apiClassLoader, options, EBuildLogger.newRootLogger(options.debug), true);
        System.setProperty("ebuild.verbose", "" + options.verbosity.isVerbose());
        System.setProperty("ebuild.verbosity.one", "" + options.verbosity.isVerbose());
        System.setProperty("ebuild.verbosity.two", "" + options.verbosity.isVeryVerbose());
        System.setProperty("ebuild.debug", "" + options.debug);
    }

    public EBuild(ClassLoader apiClassLoader, Options options, EBuildLogger logger, boolean inferWorkingCopies) {
        this.apiClassLoader = apiClassLoader;
        this.home = options.home;
        this.options = options;
        this.logger = logger;
        this.logger_verbose = (EBuildLogger)logger.newSubLogger(new ISwitch(){

            public boolean isOn() {
                return EBuild.this.options.verbosity.isVerbose();
            }
        });
        this.inferWorkingCopies = inferWorkingCopies;
        this.workspaceDirs = options.workspaces;
        int i = 0;
        while (i < this.workspaceDirs.size()) {
            this.workspaceDirs.set(i, FileUtil.canonicalFile(this.workspaceDirs.get(i)));
            ++i;
        }
        this.libraryDir = FileUtil.canonicalFile(this.getFile("library"));
        this.context = new EBuildContext(this);
        this.providers.put("http", new HttpRepositoryProvider());
        this.addRepos(this.builtinRepos);
        this.addRepos(options.overrideRepositories);
        this.context.addRepository(this.newAliasRepositoryRef("ibiblio", "maven-public"));
        this.context.addRepository(this.newAliasRepositoryRef("ivyroundup", "ivy-roundup"));
        this.context.addRepository(new RepositoryRef(this.context, "ebuild", null){
            private IRepository ebuildRepo;
            {
                this.ebuildRepo = null;
            }

            public IRepository locateRepository() throws EBuildException {
                if (this.ebuildRepo == null) {
                    this.ebuildRepo = new DerivedRepository((AbstractReleaseRepository)this.context.getRepository("public").locateRepository()){

                        protected IElementKey check(IElementKey key) throws RepositoryPluginException {
                            if (!"ebuild".equals(key.getOrg())) {
                                throw new RepositoryPluginException("org must be 'ebuild', got '" + key.getOrg() + "'");
                            }
                            return key;
                        }
                    };
                }
                return this.ebuildRepo;
            }

            public String getDefaultOrg() {
                return "ebuild";
            }
        });
        this.context.addRepository(new RepositoryRef(this.context, "local", null){

            protected IRepository locateRepository() {
                return null;
            }
        });
        this.context.init();
        this.PLUGINS = new SystemPlugins(this);
        this.report = BuildResolutionReport.newReport(logger, this.isVerbose());
    }

    public File getFile(String name) {
        return new File(this.home, name);
    }

    private void addRepos(List<String> repos) {
        for (String value : repos) {
            String[] name_type_url = value.split("\\|", 3);
            if (name_type_url.length != 3) {
                throw new Error("Expected repos to be specified <name>|<type>|<url");
            }
            String name = name_type_url[0].trim();
            String type = this.getSettingProp("repo.type-" + name, name_type_url[1].trim());
            String url = this.getSettingProp("repo.url-" + name, name_type_url[2].trim());
            this.context.addRepository(this.newLazyRepositoryRef(name, type, url));
        }
    }

    private RepositoryRef newLazyRepositoryRef(String name, final String type, final String uri) {
        return new RepositoryRef(this.context, name, null){

            public IRepository locateRepository() throws EBuildException {
                return EBuild.this.getRepository(type, uri);
            }

            public String getUniverse() throws EBuildException {
                if ("http".equals(type)) {
                    return "release";
                }
                return type;
            }
        };
    }

    private RepositoryRef newAliasRepositoryRef(String name, String aliasedName) {
        final RepositoryRef aliased = this.context.getRepository(aliasedName);
        return new RepositoryRef(this.context, name, null){

            public IRepository locateRepository() throws EBuildException {
                return aliased.locateRepository();
            }
        };
    }

    public Collection<Element> getResolvedLibraryElements() {
        return this.libraryParts.values();
    }

    public void log(String msg) {
        this.logger.log(msg);
    }

    public String getPathInWorkspace(File f) {
        f = FileUtil.canonicalFile(f);
        String fpath = f.getPath();
        int i = 0;
        while (i < this.workspaceDirs.size()) {
            String wpath = this.workspaceDirs.get(i).getPath();
            if (fpath.startsWith(wpath)) {
                return fpath.substring(wpath.length());
            }
            ++i;
        }
        return null;
    }

    @Override
    public String formatAsDisplayPath(File f) {
        String fpath = (f = FileUtil.canonicalFile(f)).getPath();
        if (fpath.startsWith(this.libraryDir.getPath())) {
            return "[library]" + fpath.substring(this.libraryDir.getPath().length());
        }
        int nworkspaces = this.workspaceDirs.size();
        int i = 0;
        while (i < nworkspaces) {
            String path = this.workspaceDirs.get(i).getPath();
            String name = "[workspace" + (nworkspaces == 1 ? "" : String.valueOf(i)) + "]";
            if (fpath.startsWith(path)) {
                return String.valueOf(name) + fpath.substring(path.length());
            }
            ++i;
        }
        return fpath;
    }

    public boolean isVerbose() {
        return this.options.verbosity.isVerbose();
    }

    public boolean isDEBUG() {
        return this.options.debug;
    }

    public File getLibraryDirectory() {
        return this.libraryDir;
    }

    public File getUniverseDirectory(String universe) {
        return new File(this.libraryDir, universe);
    }

    public File getCredentialsFile(String path) {
        return this.getFile("credentials/" + path);
    }

    public void registerRepositoryProvider(String type, AbstractRepositoryProvider plugin) {
        this.providers.put(type, plugin);
    }

    private Element newElement(EBuildMode mode, File projectDir, KeyE key, ElementNature nature) throws EBuildException {
        Element r = this.newElement_(mode, projectDir, key, nature);
        r.init();
        return r;
    }

    private Element newElement_(EBuildMode mode, File projectDir, KeyE key, ElementNature nature) throws EBuildException {
        switch (key.type) {
            case product: {
                return new Product(mode, projectDir, this, key, nature);
            }
            case module: {
                return new Module(mode, projectDir, this, key, nature);
            }
        }
        throw new Error("!");
    }

    public KeyE remapKey(KeyE key) {
        KeyE wkey = this.workspaceMapping.get(key);
        if (wkey != null) {
            return wkey;
        }
        return key;
    }

    public List<File> getProjectInWorkspaces(String projectName) {
        ArrayList<File> r = new ArrayList<File>(this.workspaceDirs.size());
        for (File ws : this.workspaceDirs) {
            File projectDir = new File(ws, projectName);
            if (!projectDir.isDirectory()) continue;
            r.add(projectDir);
        }
        return r;
    }

    private Element newWorkspaceElement(KeyE key, File projectDir) throws EBuildException {
        ElementType type;
        String branch = key.getVersion().getBranch();
        AbstractWorkingCopy wc = this.inferWorkingCopy(projectDir);
        if (wc != null) {
            String wcbranch = wc.getBranch();
            if (wcbranch == null) {
                wcbranch = "trunk";
            }
            if ("[any]".equals(branch)) {
                branch = wcbranch;
            } else if (!branch.equals(wcbranch)) {
                return null;
            }
        }
        if ((type = key.type) == null) {
            type = EBuildUtil.determineElementType(projectDir);
        }
        KeyE wkey = key.asWorking(type, branch);
        this.workspaceMapping.put(key, wkey);
        Element r = this.newElement(EBuildMode.workspace, projectDir, wkey, ElementNature.source);
        if (wc != null) {
            r.setRepository((IRepository)wc.getRepository());
            r.setWorkingCopy(wc);
        } else {
            r.setRepository(null);
        }
        return r;
    }

    public Element newWorkspaceElement(KeyE key) throws EBuildException {
        String projectName = key.getDefaultWorkspaceName();
        List<File> projectDirs = this.getProjectInWorkspaces(projectName);
        for (File d : projectDirs) {
            Element r = this.newWorkspaceElement(key, d);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    @Override
    public Element resolveWorkspaceElement(KeyE key) throws EBuildException {
        Element r;
        if (!this.workspaceParts.containsKey(key)) {
            r = this.newWorkspaceElement(key);
            this.workspaceParts.put(key, r);
        } else {
            r = this.workspaceParts.get(key);
        }
        return r;
    }

    @Override
    public Element resolveLibraryPart(RepositoryRef repoRef, KeyE key) throws EBuildException {
        assert (!"workspace".equals(key.version.getRevision()));
        Element r = this.libraryParts.get(key);
        if (r == null) {
            String universe = key.universe;
            File universeDir = new File(this.getLibraryDirectory(), universe);
            File dir4version = key.getSubDirectory(universeDir);
            RepositoryContext repoContext = repoRef.getContext();
            repoContext.fetchMeta(key, dir4version);
            ElementNature nature = repoContext.determineNature(key, dir4version);
            if (key.type == null) {
                ElementType type = EBuildUtil.determineElementType(dir4version);
                key = key.withType(type);
            }
            r = this.newElement(EBuildMode.library, dir4version, key, nature);
            r.setRepository(repoContext.repo);
            this.libraryParts.put(key, r);
        }
        return r;
    }

    public AbstractRepositoryProvider addProviderPlugin(String repoType, AbstractRepositoryProvider provider) {
        this.providers.put(repoType, provider);
        return provider;
    }

    public AbstractRepositoryProvider expectProviderPlugin(String repoType) throws EBuildException {
        AbstractRepositoryProvider r = this.providers.get(repoType);
        if (r == null) {
            r = this.addProviderPlugin(repoType, this.PLUGINS.useRepoProvider(repoType));
            this.providers.put(repoType, r);
        }
        return r;
    }

    public String inferRepositoryType(File dir) {
        if (new File(dir, ".svn").isDirectory()) {
            return "svn";
        }
        if (new File(dir, ".mockvcs").isFile()) {
            return "mockvcs";
        }
        return null;
    }

    public AbstractWorkingCopy inferWorkingCopy(File dir) throws EBuildException {
        String type;
        block5: {
            block4: {
                try {
                    if (this.inferWorkingCopies) break block4;
                    return null;
                }
                catch (RepositoryPluginException e) {
                    throw EBuildException.wrapPluginException("Could not infer source control for dir '" + this.formatAsDisplayPath(dir) + "'", e);
                }
            }
            type = this.inferRepositoryType(dir);
            if (type != null) break block5;
            return null;
        }
        AbstractRepositoryProvider prov = this.expectProviderPlugin(type);
        return prov.getWorkingCopy(dir);
    }

    public IRepository getRepository(String repositoryType, String repositoryUrl) throws EBuildException {
        AbstractRepositoryProvider prov = this.expectProviderPlugin(repositoryType);
        try {
            return prov.getRepository(repositoryUrl);
        }
        catch (RepositoryPluginException e) {
            throw EBuildException.wrapPluginException("Could not creat repository '" + repositoryUrl + "'", e);
        }
    }

    public AbstractWorkingCopy getWorkspaceWorkingCopy() throws EBuildException {
        if (this.workspaceWorkingCopy == null) {
            this.workspaceWorkingCopy = this.inferWorkingCopy(this.home);
        }
        return this.workspaceWorkingCopy;
    }

    private Map readPropFile(File f) {
        if (f.exists()) {
            try {
                return JSONUtil.readMap(IOUtil.fileToString(f));
            }
            catch (Exception e) {
                this.logger.log("[WARNING] Unable to load property file: " + this.formatAsDisplayPath(f));
                this.logger.log(e.getMessage());
            }
        }
        return CollectionUtil.EMPTY_MAP;
    }

    private Map loadProps() {
        if (this.props == null) {
            HashMap m = new HashMap();
            m.putAll(this.readPropFile(this.getFile("seed/settings/properties.json")));
            m.putAll(this.readPropFile(this.getFile("settings/properties.json")));
            this.props = m;
        }
        return this.props;
    }

    public String getSettingProp(String name, String default_) {
        String r = this.getSettingProp(name);
        if (r == null) {
            return default_;
        }
        return r;
    }

    public String getSettingProp(String name) {
        Object v = this.loadProps().get(name);
        try {
            return (String)v;
        }
        catch (ClassCastException classCastException) {
            this.logger.log("[WARNING] Unexpected value for prop '" + name + "': " + v);
            return null;
        }
    }

    public AbstractCompatability getCompatability(EBuildVersion v) throws EBuildException {
        AbstractCompatability r = this.compatabilities.get((Object)v);
        if (r == null) {
            r = this.PLUGINS.useCompatability(v);
            this.compatabilities.put(v, r);
        }
        return r;
    }

    public String getWorkspaceHeadRevision(AbstractSourceRepository repo) throws EBuildException {
        String r = null;
        RepositoryPluginException rpe = null;
        try {
            r = repo.getHeadRevision();
        }
        catch (RepositoryPluginException e) {
            rpe = e;
        }
        try {
            FileUtil.mkdirOrFail(this.getLibraryDirectory());
            File wsRevs = new File(this.getLibraryDirectory(), "workspace.revisions");
            HashMap<String, String> m = null;
            if (wsRevs.isFile()) {
                try {
                    m = JSONUtil.readMap(IOUtil.fileToString(wsRevs));
                }
                catch (IOException iOException) {}
            }
            if (m == null) {
                m = new HashMap<String, String>(1);
            }
            if (r == null) {
                r = (String)m.get(repo.getUri());
                if (r == null) {
                    throw EBuildException.wrapPluginException("Could not fetch head revision of '" + repo.getUri() + "'", rpe);
                }
            } else {
                m.put(repo.getUri(), r);
                JSONUtil.writeObject(wsRevs, m);
            }
            return r;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public BuildPlan newBuildPlan(ElementC elementC) {
        switch (((Element)elementC.element).key.type) {
            case module: {
                return new ModuleBuildPlan(this, elementC);
            }
            case product: {
                return new ProductBuildPlan(this, elementC);
            }
        }
        throw new Error("!");
    }

    public BuildPlan getBuildPlan(ElementC elementC) {
        KeyC key = elementC.key;
        BuildPlan r = this.buildPlans.get(key);
        if (r == null) {
            r = this.newBuildPlan(elementC);
            this.buildPlans.put(elementC, r);
            this.report.configure(key.ekey, elementC.getConfigurationSelected());
        }
        return r;
    }

    public static class Options
    implements Cloneable {
        public boolean noSkipping = false;
        public Verbosity verbosity = Verbosity.normal;
        public boolean debug = false;
        public File home = new File("../_ebuild");
        public List<File> workspaces = CollectionUtil.newList(new File(".."));
        public List<String> overrideRepositories = CollectionUtil.EMPTY_LIST;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Verbosity {
        normal,
        one,
        two;


        public boolean isVerbose() {
            return this != normal;
        }

        public boolean isVeryVerbose() {
            return this == two;
        }
    }
}

