/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.BuildPluginDef;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementResolver;
import ebuild.core.Module;
import ebuild.core.ProjectHelper;
import ebuild.core.RepositoryContext;
import ebuild.core.RepositoryRef;
import ebuild.core.conf.ConfMap;
import ebuild.core.conf.ConfMapping;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyC;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Version;
import ebuild.core.util.PObject;
import ebuild.util.FileUtil;
import ebuild.util.JSONUtil;
import ebuild.util.ObjectUtil;
import ebuild.util.tuple.Pair;
import ebuild.xml.CmnXml;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBuildContext {
    private static final int REPOSITORIES = 0;
    private static final int BUILDERS = 1;
    private static final int SIZE = 2;
    private Map<Object, BuildPluginDef> localBuildPluginDefMap = new HashMap<Object, BuildPluginDef>(0);
    private final PObject[] pobjs = new PObject[2];
    final ElementResolver resolver;
    final EBuild ebuild;
    public final Element element;
    final Type type;
    private List<EBuildContext> parents;
    private boolean inited;
    private Map<Pair<String, KeyE>, Element> resolvedElements;
    private Map<String, String> upstreamRevisions;

    private EBuildContext(EBuild ebuild, Element element, Type type) {
        int i = 0;
        while (i < 2) {
            this.pobjs[i] = new PObject();
            ++i;
        }
        this.parents = new LinkedList<EBuildContext>();
        this.inited = false;
        this.resolvedElements = new HashMap<Pair<String, KeyE>, Element>();
        this.resolver = ebuild;
        this.ebuild = ebuild;
        this.element = element;
        this.type = type;
    }

    public EBuildContext(EBuild ebuild) {
        this(ebuild, null, Type.builtin);
    }

    public EBuildContext(Element element, Type type) {
        this(element.ebuild, element, type);
    }

    public String getExceptionPreface() {
        return this.element == null ? "" : String.valueOf(this.element.toString()) + "\n";
    }

    public boolean isInited() {
        return this.inited;
    }

    public void init() {
        this.inited = true;
    }

    public void addParents(EBuildContext ... parentContexts) {
        EBuildContext[] eBuildContextArray = parentContexts;
        int n = parentContexts.length;
        int n2 = 0;
        while (n2 < n) {
            EBuildContext parentContext = eBuildContextArray[n2];
            this.parents.add(parentContext);
            ++n2;
        }
        int i = 0;
        while (i < 2) {
            PObject[] prototypes = new PObject[parentContexts.length];
            int j = 0;
            EBuildContext[] eBuildContextArray2 = parentContexts;
            int n3 = parentContexts.length;
            int n4 = 0;
            while (n4 < n3) {
                EBuildContext parentContext = eBuildContextArray2[n4];
                prototypes[j] = parentContext.pobjs[i];
                ++j;
                ++n4;
            }
            this.pobjs[i].addPrototypes(prototypes);
            ++i;
        }
        this.inited = true;
    }

    public BuildPluginDef getBuildPluginDefById(String id) {
        return (BuildPluginDef)this.pobjs[1].get(id);
    }

    public void addBuildPluginDef(Object localKey, String id, BuildPluginDef value) {
        if (id != null) {
            this.pobjs[1].put(id, value);
        }
        this.localBuildPluginDefMap.put(localKey, value);
    }

    public BuildPluginDef expectBuildPluginDefById(String id) throws EBuildException {
        BuildPluginDef r = this.getBuildPluginDefById(id);
        if (r == null) {
            throw EBuildException.newConfProblem("No such build plugin in scope: " + id);
        }
        return r;
    }

    public BuildPluginDef expectBuildPluginDefByLocalKey(Object localKey) throws EBuildException {
        BuildPluginDef r = this.localBuildPluginDefMap.get(localKey);
        if (r == null) {
            throw new Error("Build plugin not registered: " + localKey);
        }
        return r;
    }

    public RepositoryRef getRepository(String key) {
        return (RepositoryRef)this.pobjs[0].get(key);
    }

    public void addRepository(RepositoryRef value) {
        this.pobjs[0].put(value.name, value);
    }

    private RepositoryRef addRepository(String name, final IRepository repository, String defaultOrg) {
        RepositoryRef repoRef = new RepositoryRef(this, name, defaultOrg){

            protected IRepository locateRepository() {
                return repository;
            }
        };
        this.addRepository(repoRef);
        return repoRef;
    }

    public RepositoryRef addLocalRepository(IRepository repository, String defaultOrg) {
        return this.addRepository("local", repository, defaultOrg);
    }

    public RepositoryRef addNamedRepository(String name, IRepository repository, String defaultOrg) throws EBuildException {
        if ("local".equals(name)) {
            throw EBuildException.newConfProblem("Cannot name a repository 'local'");
        }
        return this.addRepository(name, repository, defaultOrg);
    }

    public void addRepository(CmnXml.Repository repoXml) throws EBuildException {
        String msg = repoXml.validate();
        if (msg != null) {
            throw EBuildException.newConfProblem("Invalid repository definition: " + msg);
        }
        if (repoXml.ref != null) {
            final RepositoryRef prototype = this.getRepository(repoXml.ref);
            RepositoryRef instance = new RepositoryRef(this, repoXml.name){

                protected IRepository locateRepository() throws EBuildException {
                    return prototype.locateRepository();
                }
            };
            instance.setDefaultOrg(ObjectUtil.coalesce(repoXml.org, prototype.getDefaultOrg()));
            instance.setDefaultVersion(ObjectUtil.coalesce(EBuildUtil.asVersion(repoXml), prototype.getDefaultVersion()));
            this.addRepository(instance);
        } else {
            IRepository repo = ((EBuild)this.resolver).getRepository(repoXml.type, repoXml.url);
            this.addNamedRepository(repoXml.name, repo, repoXml.org);
        }
    }

    public RepositoryRef lookupRepository(String source) throws EBuildException {
        if ("system".equals(source)) {
            return null;
        }
        RepositoryRef repo = this.getRepository(source);
        if (repo == null) {
            if (!this.isInited()) {
                throw new Error("!" + this + " " + source);
            }
            throw EBuildException.newConfProblem("Bad source, no repository defined in scope '" + this + "'for '" + source + "'");
        }
        return repo;
    }

    private String name() {
        switch (this.type) {
            case main: {
                return this.element.elementName();
            }
            case build: {
                return this.element.builderName();
            }
        }
        return "builtin";
    }

    public EBuildContext resolveSelf() throws EBuildException {
        if (this.isInited()) {
            return this;
        }
        switch (this.type) {
            case main: {
                this.resolveSelf(this.element.getDeclaration());
                break;
            }
            case build: {
                this.resolveSelfBuild(this.element.expectProjectHelper());
                break;
            }
            default: {
                throw new Error("!");
            }
        }
        this.init();
        return this;
    }

    private EBuildContext resolveSelfBuild(ProjectHelper phelper) throws EBuildException {
        Element element = phelper.element;
        EBuildContext context = phelper.contextOfBuild;
        this.resolveSelf(phelper.getBuildXml());
        Backtrace.start("resolve " + element.builderName() + "s", context);
        this.ebuild.report.startResolve(context, String.valueOf(element.builderName()) + "s");
        try {
            Map<Object, CmnXml.SelectBuildPlugin> bdeps = phelper.getBuildDependencies();
            for (Object k : bdeps.keySet()) {
                BuildPluginDef pluginDef;
                CmnXml.SelectBuildPlugin bxml = bdeps.get(k);
                ConfMapping mapping = EBuildUtil.parseMapping(bxml.confMapping);
                if (bxml.refid != null) {
                    BuildPluginDef prototype = context.expectBuildPluginDefById(bxml.refid);
                    pluginDef = prototype.clone(mapping, bxml.propertiesList);
                } else {
                    KeyE bkeyE = context.newModuleKeyE(bxml);
                    Module bmodule = context.resolveModule(bxml.source, bkeyE);
                    pluginDef = phelper.newBuildPluginDef(bmodule, mapping, bxml.propertiesList);
                }
                context.addBuildPluginDef(k, bxml.id, pluginDef);
            }
        }
        finally {
            Backtrace.end(context);
        }
        this.ebuild.report.endResolve();
        return context;
    }

    private EBuildContext resolveSelf(CmnXml.EBuildRoot xml) throws EBuildException {
        String contextNoun = String.valueOf(this.name()) + " context";
        Backtrace.start("resolving " + contextNoun, this);
        try {
            EBuildContext eBuildContext = this.resolveSelfInner(xml, contextNoun);
            return eBuildContext;
        }
        finally {
            Backtrace.end(this);
        }
    }

    private EBuildContext resolveSelfInner(CmnXml.EBuildRoot xml, String contextNoun) throws EBuildException {
        this.addParents(this.ebuild.context);
        for (CmnXml.Repository repoXml : xml.repositories) {
            this.addRepository(repoXml);
        }
        int l = xml.usings.size();
        EBuildContext[] add = new EBuildContext[l];
        this.ebuild.report.startResolve(this, contextNoun);
        int i = 0;
        while (i < l) {
            CmnXml.Using d = xml.usings.get(i);
            Module delement = this.resolveModule(d);
            EBuildContext dcontext = d.isBuild() ? delement.expectProjectHelper().contextOfBuild.resolveSelf() : delement.context.resolveSelf();
            add[i] = dcontext;
            ++i;
        }
        this.ebuild.report.endResolve();
        this.addParents(add);
        return this;
    }

    public KeyC newModuleKeyC(CmnXml.SelectWithConf select, ConfMap inputConfs) throws EBuildException {
        ConfMapping dmapping = EBuildUtil.parseMapping(select.confMapping, ConfMapping.EMPTY);
        ConfMap confs = dmapping.evaluate(inputConfs);
        return new KeyC(this.newElementKey(ElementType.module, select), confs);
    }

    public KeyE newModuleKeyE(CmnXml.SelectWithSource select) throws EBuildException {
        return this.newElementKey(ElementType.module, select);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KeyE newElementKey(ElementType type, CmnXml.SelectWithSource select) throws EBuildException {
        String universe;
        String source = select.source;
        String name = select.name;
        if (source == null) {
            throw EBuildException.newConfProblem("'source' not set: " + select);
        }
        if (name == null) {
            throw EBuildException.newConfProblem("'name' not set: " + select);
        }
        boolean local = "local".equals(select.source);
        String org = select.org;
        Version version = EBuildUtil.asVersion(select);
        KeyE ourKey = this.element.key;
        if (local) {
            universe = ourKey.universe;
            if (version == null) {
                Version ourV = ourKey.version;
                if (ourV.isWorking()) {
                    AbstractWorkingCopy wc = this.element.getWorkingCopy();
                    String branch = "trunk";
                    if (wc != null) {
                        branch = wc.getBranch();
                    }
                    version = Version.newRevision(branch, "head");
                } else {
                    version = ourV.isTag() ? (ourV.hasTagSub() ? ourV.withoutTagSub() : ourV) : ourV;
                }
            }
        } else {
            RepositoryRef repoRef = this.lookupRepository(select.source);
            if (repoRef == null) {
                if (!"system".equals(source)) throw EBuildException.newConfProblem("Unknown source: " + source);
                universe = source;
            } else {
                universe = repoRef.getUniverse();
                if (org == null) {
                    org = repoRef.getDefaultOrg();
                }
                if (version == null) {
                    version = repoRef.getDefaultVersion();
                }
            }
        }
        if (org == null) {
            org = ourKey.org;
        }
        if (version != null) return new KeyE(type, universe, org, name, version);
        version = Version.TRUNK_HEAD;
        return new KeyE(type, universe, org, name, version);
    }

    public Element resolveElement(String source, KeyE dkey) throws EBuildException {
        Backtrace.start("resolve", dkey);
        try {
            Pair<String, KeyE> key = new Pair<String, KeyE>(source, dkey);
            Element r = this.resolvedElements.get(key);
            if (r == null) {
                r = this.resolveElement_(source, dkey);
                this.resolvedElements.put(key, r);
            }
            this.ebuild.report.resolve(dkey, r);
            Element element = r;
            return element;
        }
        finally {
            Backtrace.end(dkey);
        }
    }

    private Module resolveModule(CmnXml.SelectWithSource d) throws EBuildException {
        KeyE dkey = this.newElementKey(ElementType.module, d);
        return this.resolveModule(d.source, dkey);
    }

    public Module resolveModule(String source, KeyE dkey) throws EBuildException {
        return (Module)this.resolveElement(source, dkey);
    }

    private Element resolveLibraryPart(RepositoryRef repoRef, KeyE key) throws EBuildException {
        return this.resolver.resolveLibraryPart(repoRef, key);
    }

    private Element resolveElement_(String source, KeyE dkey) throws EBuildException {
        RepositoryRef repoRef = this.lookupRepository(source);
        if (dkey.version.isMoving()) {
            return this.resolveMoving(repoRef, dkey);
        }
        return this.resolveLibraryPart(repoRef, dkey);
    }

    private Element resolveMoving(RepositoryRef repoRef, KeyE dkey) throws EBuildException {
        boolean local = repoRef.isLocal();
        RepositoryContext repoContext = repoRef.getContext();
        RepositoryContext.Source srepoContext = null;
        if (repoContext instanceof RepositoryContext.Source) {
            srepoContext = (RepositoryContext.Source)repoContext;
        }
        if (this.element == null || this.element.isWorkspace()) {
            String revision;
            Element we = this.resolver.resolveWorkspaceElement(dkey);
            if (we != null) {
                if (!local) {
                    if (srepoContext != null && srepoContext.context.element.isWorkspace()) {
                        srepoContext.setFixedRevisionToWorkspace(this, dkey);
                        return we;
                    }
                } else {
                    return we;
                }
            }
            if (srepoContext == null) {
                String msg = "Repository '" + repoRef.name + "' does not support head versions";
                if (repoContext.repo == null) {
                    msg = String.valueOf(msg) + " (project not connected to a repository)";
                }
                throw EBuildException.newConfProblem(String.valueOf(msg) + ":" + dkey);
            }
            if (!local) {
                revision = srepoContext.getUpdatedFixedRevision(repoRef, this, dkey);
            } else {
                if (srepoContext.getRepository() == null) {
                    throw EBuildException.newConfProblem("'" + this.element.key + "' not connected to a repository, and cannot resolve local depondency '" + dkey + "' in the workspace");
                }
                revision = this.element.ebuild.getWorkspaceHeadRevision(srepoContext.getRepository());
            }
            Version v2 = dkey.version.withRevision(revision);
            KeyE dkey2 = dkey.withVersion(v2);
            return this.resolveLibraryPart(repoRef, dkey2);
        }
        String revision = !local ? srepoContext.expectFixedRevision() : this.element.key.version.getRevision();
        Version v2 = dkey.version.withRevision(revision);
        KeyE dkey2 = dkey.withVersion(v2);
        return this.resolveLibraryPart(repoRef, dkey2);
    }

    private File getUpstreamRevisionsFile() {
        File metaDir = this.element.getMetaDirectory();
        File old = new File(metaDir, "upstream.revisions");
        if (old.exists()) {
            return old;
        }
        String filename = String.valueOf(FileUtil.removeSuffix(this.filename())) + ".revisions";
        return new File(metaDir, filename);
    }

    private Map<String, String> readUpstreamRevisions() {
        File f = this.getUpstreamRevisionsFile();
        if (!f.exists()) {
            return new HashMap<String, String>();
        }
        try {
            return JSONUtil.readMap(new FileReader(f));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public Map<String, String> getUpstreamRevisions() {
        if (this.upstreamRevisions == null) {
            this.upstreamRevisions = this.readUpstreamRevisions();
        }
        return this.upstreamRevisions;
    }

    public void updateUpstreamRevisions(Map<String, String> upstreamRevisions) {
        this.upstreamRevisions = upstreamRevisions;
        File f = this.getUpstreamRevisionsFile();
        try {
            JSONUtil.writeObject(new FileWriter(f), upstreamRevisions);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write: " + f, e);
        }
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.element) + ObjectUtil.hashOf((Object)this.type);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EBuildContext)) {
            return false;
        }
        EBuildContext b = (EBuildContext)obj;
        return ObjectUtil.areEqual(this.element, b.element) && ObjectUtil.areEqual((Object)this.type, (Object)b.type);
    }

    public String filename() {
        switch (this.type) {
            case main: {
                return EBuildUtil.elementType2xmlName(this.element.getType());
            }
            case build: {
                return EBuildUtil.elementType2buildXmlName(this.element.getType());
            }
            case builtin: {
                return "<builtin>";
            }
        }
        throw new Error("!");
    }

    public String toString() {
        return this.element + "," + this.filename();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        builtin,
        main,
        build;

    }
}

