/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.compat.AbstractCompatability;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.ElementC;
import ebuild.core.ElementNature;
import ebuild.core.ElementResolver;
import ebuild.core.ProjectHelper;
import ebuild.core.WorkspaceProject;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Version;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.StringUtil;
import ebuild.version.EBuildVersion;
import ebuild.xml.CmnXml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element {
    public final EBuild ebuild;
    private final File dir;
    public final ElementResolver resolver;
    public final EBuildMode mode;
    public final EBuildContext context;
    private IRepository repository = null;
    private AbstractWorkingCopy workingCopy = null;
    public final KeyE key;
    private final File metaDir;
    private final File buildDir;
    private final File releaseDir;
    private final File projectDir;
    public final ElementNature nature;
    private ProjectHelper projectHelper;
    private WorkspaceProject eclipseProject;
    private Map<ConfKey, ElementC> cElements = new HashMap<ConfKey, ElementC>();
    private Long lastModified = null;
    private Map<MetaType, CmnXml.EBuildRoot> metas = new HashMap<MetaType, CmnXml.EBuildRoot>(3);
    private final Map<String, ConfMap> confMap = new HashMap<String, ConfMap>();
    private final Set<String> confNorecur = new LinkedHashSet<String>();

    public Element(EBuildMode mode, File directory, EBuild ebuild, KeyE key, ElementNature nature) throws EBuildException {
        assert (key.universe != null);
        this.ebuild = ebuild;
        this.dir = FileUtil.canonicalFile(directory);
        this.mode = mode;
        this.resolver = ebuild;
        this.context = new EBuildContext(this, EBuildContext.Type.main);
        this.key = key;
        this.metaDir = FileUtil.canonicalFile(this.getFile("meta"));
        this.projectDir = FileUtil.canonicalFile(this.getFile(mode == EBuildMode.library ? "project" : "."));
        this.buildDir = FileUtil.canonicalFile(this.getFile("build"));
        this.releaseDir = FileUtil.canonicalFile(this.getFile("release"));
        this.nature = nature;
        if (this.isSource()) {
            this.projectHelper = this.newProjectHelper();
        }
    }

    public abstract ElementC newCElement(ConfKey var1, ConfMap var2);

    public abstract ProjectHelper newProjectHelper() throws EBuildException;

    public abstract void check() throws EBuildException;

    public abstract CmnXml.EBuildElement getDeclaration();

    public abstract ElementType getType();

    public abstract MetaType getMetaType();

    public abstract MetaType getMetaTypeOfBuild();

    public void init() throws EBuildException {
        this.expectMeta(this.getMetaType());
        if (this.isSource()) {
            this.getMeta(this.getMetaTypeOfBuild());
        }
        this.check();
    }

    public static EBuildVersion readVersion(Reader reader) throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader xreader = factory.createXMLStreamReader(reader);
        xreader.nextTag();
        String versionAttr = xreader.getAttributeValue(null, "ebuild-version");
        if (versionAttr == null) {
            throw EBuildException.newConfProblem("No 'ebuild-version' attribute defined in root element");
        }
        Object[] versions = versionAttr.split(",");
        Arrays.sort(versions);
        EBuildVersion r = null;
        Object[] objectArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            EBuildVersion ebv = EBuildVersion.map.get(v);
            if (ebv != null) {
                r = ebv;
            }
            ++n2;
        }
        if (r == null) {
            throw new Exception("Unsupported format-version attribute defined in root element: " + versionAttr);
        }
        return r;
    }

    public static EBuildVersion readVersion(File f) throws Exception {
        FileReader r = new FileReader(f);
        try {
            EBuildVersion eBuildVersion = Element.readVersion(r);
            return eBuildVersion;
        }
        finally {
            r.close();
        }
    }

    protected EBuildVersion readMetaVersion(File f) throws EBuildException {
        block4: {
            if (f != null) break block4;
            return null;
        }
        try {
            return Element.readVersion(f);
        }
        catch (EBuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw EBuildException.newConfProblem(String.valueOf(this.ebuild.formatAsDisplayPath(this.dir)) + "\n" + e.getMessage());
        }
    }

    private CmnXml.EBuildRoot readMeta(MetaType type) throws EBuildException {
        FileInputStream fi;
        File f = this.getMetaFile(type);
        if (f == null) {
            return null;
        }
        try {
            fi = new FileInputStream(f);
        }
        catch (IOException e) {
            throw EBuildException.newInternalError("Could not read file: " + f, e);
        }
        EBuildVersion v = this.readMetaVersion(f);
        if (v == null) {
            return null;
        }
        AbstractCompatability compat = this.ebuild.getCompatability(v);
        boolean verbose = false;
        CmnXml.EBuildRoot r = compat.parseXml(type, fi, verbose);
        r.setEBuildVersion(v);
        return r;
    }

    private CmnXml.EBuildRoot getMeta(MetaType type) throws EBuildException {
        CmnXml.EBuildRoot r = this.metas.get((Object)type);
        if (r == null) {
            r = this.readMeta(type);
            this.metas.put(type, r);
        }
        return r;
    }

    private CmnXml.EBuildRoot expectMeta(MetaType type) throws EBuildException {
        CmnXml.EBuildRoot r = this.getMeta(type);
        if (r == null) {
            throw EBuildException.newConfProblem("Expected meta file: " + type.name);
        }
        return r;
    }

    public CmnXml.EBuildRoot getMetaAlreadyParsed(MetaType type) {
        return this.metas.get((Object)type);
    }

    public CmnXml.EBuildRoot expectMetaAlreadyParsed(MetaType type) {
        CmnXml.EBuildRoot r = this.getMetaAlreadyParsed(type);
        if (r == null) {
            throw new Error("Expected " + (Object)((Object)type));
        }
        return r;
    }

    public File javaFile() {
        return this.dir;
    }

    public File getFile(String name) {
        return new File(this.dir, name);
    }

    public boolean isWorkspace() {
        return this.mode == EBuildMode.workspace;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IRepository repository) {
        this.repository = repository;
        this.context.addLocalRepository(repository, this.key.org);
        if (this.isSource()) {
            this.getProjectHelper().contextOfBuild.addLocalRepository(repository, this.key.org);
        }
    }

    public AbstractWorkingCopy getWorkingCopy() {
        return this.workingCopy;
    }

    public void setWorkingCopy(AbstractWorkingCopy workingCopy) {
        this.workingCopy = workingCopy;
    }

    public boolean hasMetaDirectory() {
        return this.metaDir.exists();
    }

    public File getMetaDirectory() {
        return this.metaDir;
    }

    public File getMetaFile(MetaType type) {
        File r = new File(this.metaDir, String.valueOf(EBuildVersion.getLatest().string) + "/" + type.name);
        if (r.isFile()) {
            return r;
        }
        r = new File(this.metaDir, type.name);
        if (r.isFile()) {
            return r;
        }
        String name = type.getAlternativeName();
        if (name != null) {
            r = new File(this.metaDir, name);
        }
        if (r.isFile()) {
            return r;
        }
        return null;
    }

    public boolean hasMetaFile(MetaType type) {
        return this.getMetaFile(type) != null;
    }

    public String getName() {
        return this.key.fullname();
    }

    public Version getVersion() {
        return this.key.version;
    }

    public String toString() {
        return "" + this.key;
    }

    public long lastModificationOfSource() {
        if (this.lastModified == null) {
            long r = Long.MIN_VALUE;
            File[] fs = this.getProjectDirectory().listFiles();
            if (fs != null) {
                File[] fileArray = fs;
                int n = fs.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().startsWith("src")) {
                        r = Math.max(r, FileUtil.deepLastModified(f));
                    }
                    ++n2;
                }
                r = Math.max(r, FileUtil.deepLastModified(this.getMetaDirectory()));
            } else {
                r = Long.MAX_VALUE;
            }
            this.lastModified = r;
        }
        return this.lastModified;
    }

    public boolean hasBuildDirectory() {
        return this.buildDir.exists();
    }

    public File getBuildDirectory() {
        return this.buildDir;
    }

    public boolean hasReleaseDirectory() {
        return this.releaseDir.exists();
    }

    public File getReleaseDirectory() {
        return this.releaseDir;
    }

    public boolean hasProjectDirectory() {
        return this.projectDir.exists();
    }

    public File getProjectDirectory() {
        return this.projectDir;
    }

    public boolean buildIsClean() {
        return !this.hasBuildDirectory() && !this.hasReleaseDirectory();
    }

    public void buildClean() {
        FileUtil.deleteDir(this.getBuildDirectory());
        FileUtil.deleteDir(this.getReleaseDirectory());
    }

    public ProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public ProjectHelper expectProjectHelper() throws EBuildException {
        ProjectHelper r = this.getProjectHelper();
        if (r == null) {
            throw EBuildException.newConfProblem("Build context unavailable: " + this.key);
        }
        return r;
    }

    private CmnXml.Configuration getConfXml(String name) throws EBuildException {
        for (CmnXml.Configuration c : this.getDeclaration().configurations) {
            if (!name.equals(c.name)) continue;
            return c;
        }
        return null;
    }

    private ConfMap getConfs(String conf) throws EBuildException {
        if (this.confNorecur.contains(conf)) {
            throw EBuildException.newConfProblem("Loop: " + StringUtil.join(",", this.confNorecur));
        }
        this.confNorecur.add(conf);
        try {
            ConfMap r = this.confMap.get(conf);
            if (r == null) {
                ConfMap.Builder b = new ConfMap.Builder();
                CmnXml.Configuration cxml = this.getConfXml(conf);
                boolean isDefault = "[default]".equals(conf);
                if (cxml == null) {
                    if (!isDefault) {
                        b.add(conf);
                    }
                } else {
                    ConfMap inc = EBuildUtil.parseConfMap(cxml.includes);
                    for (String c : inc) {
                        b.addAll(this.getConfs(c));
                    }
                    if (!cxml.alias && !isDefault) {
                        b.add(conf);
                    }
                    ConfMap exc = EBuildUtil.parseConfMap(cxml.excludes);
                    for (String c : exc.asCollection()) {
                        b.removeAll(this.getConfs(c));
                    }
                }
                r = b.build();
                this.confMap.put(conf, r);
            }
            ConfMap confMap = r;
            return confMap;
        }
        finally {
            this.confNorecur.remove(conf);
        }
    }

    private ConfMap actualConfiguration(ConfMap configurationSelected) throws EBuildException {
        ConfMap.Builder b = new ConfMap.Builder();
        ConfMap defaultConfs = this.getConfs("[default]");
        b.addAll(defaultConfs);
        for (String c : configurationSelected) {
            b.addAll(this.getConfs(c));
        }
        return b.build();
    }

    public Set<String> listCheckedIn() {
        File dir = this.getFile("checkedin");
        if (!dir.isDirectory()) {
            return CollectionUtil.EMPTY_SET;
        }
        String[] fs = dir.list();
        HashSet<String> r = new HashSet<String>(fs.length);
        String[] stringArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            r.add(f);
            ++n2;
        }
        return r;
    }

    public ElementC getDefault() throws EBuildException {
        return this.getCPart(ConfKey.DEFAULT);
    }

    public ElementC getCPart(ConfKey subKey0) throws EBuildException {
        ConfMap configuration = this.actualConfiguration(subKey0.conf);
        ConfKey subKey = new ConfKey(configuration, subKey0.exclude);
        ElementC r = this.cElements.get(subKey);
        if (r == null) {
            r = this.newCElement(subKey, subKey0.conf);
            this.cElements.put(r.key.subkey, r);
        }
        return r;
    }

    public WorkspaceProject createEclipseProject(ElementC cElement) {
        if (this.eclipseProject == null) {
            this.eclipseProject = cElement.newEclipseProject();
            try {
                this.eclipseProject.storeConfiguration();
            }
            catch (IOException e) {
                throw new Error("Unable to store configuration", e);
            }
            return this.eclipseProject;
        }
        if (cElement.getConfiguration().equals(this.eclipseProject.getConfiguration())) {
            return this.eclipseProject;
        }
        throw new Error("Attempted to have eclipse project for '" + this.key + "'with 2 different configurations: " + "\n" + cElement.getConfiguration() + "\n" + this.eclipseProject.getConfiguration());
    }

    public WorkspaceProject expectEclipseProject() {
        if (this.eclipseProject == null) {
            throw new RuntimeException("No eclipse project for " + this.key);
        }
        return this.eclipseProject;
    }

    public boolean isSource() {
        return this.nature.isSource();
    }

    public void addIgnores(List<String> patterns) {
        if (!this.isWorkspace()) {
            throw new Error("Tryed to add a ignores to a non-workspace element: " + this);
        }
        AbstractWorkingCopy wc = this.getWorkingCopy();
        if (wc == null) {
            return;
        }
        wc.addIgnores(patterns);
    }

    public void addIgnores(String ... patterns) {
        this.addIgnores(CollectionUtil.newList(patterns));
    }

    public Date getLastCommitDate() {
        if (this.isWorkspace()) {
            return new Date();
        }
        Date r = FileUtil.readTimestampFile(this.getMetaDirectory());
        if (r == null) {
            r = new Date(this.getProjectDirectory().lastModified());
        }
        return r;
    }

    public String elementName() {
        return this.key.type.name();
    }

    public String builderName() {
        if (this.key.type == ElementType.product) {
            return "assembler";
        }
        return "builder";
    }
}

