/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.EBuildException;
import ebuild.core.BuildProject;
import ebuild.core.Element;
import ebuild.core.ElementDeps;
import ebuild.core.ElementRelease;
import ebuild.core.WorkspaceProject;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.KeyC;
import ebuild.util.FileUtil;
import ebuild.version.EBuildVersion;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementC<P extends Element> {
    public final KeyC key;
    public final P element;
    public final ConfMap configurationSelected;
    private Map<String, ElementRelease<P>> releases;
    public BuildProject<P> build;
    public WorkspaceProject<P> eclipse;
    private Long lastModificationOfInput = null;

    public BuildProject<P> createBuildProject() {
        this.build = this.newBuildProject();
        return this.build;
    }

    public WorkspaceProject<P> createEclipseProject() {
        this.eclipse = this.newEclipseProject();
        return this.eclipse;
    }

    public WorkspaceProject getWorkspaceProject() {
        return this.eclipse;
    }

    public BuildProject<P> getOrCreateBuildProject() {
        if (this.build == null) {
            return this.newBuildProject();
        }
        return this.build;
    }

    public ElementC(P element, ConfKey subKey, ConfMap configurationSelected) {
        this.key = new KeyC(((Element)element).key, subKey);
        this.element = element;
        this.configurationSelected = configurationSelected;
    }

    protected boolean is0_7() {
        return ((Element)this.element).getDeclaration().getEBuildVersion() == EBuildVersion._0_7;
    }

    public abstract WorkspaceProject newEclipseProject();

    public abstract BuildProject newBuildProject();

    public abstract List<? extends ElementRelease> listReleases();

    public abstract ElementDeps getDependencies(Scope var1);

    public ConfKey getSubKey() {
        return this.key.subkey;
    }

    public P getPart() {
        return this.element;
    }

    public ConfMap getConfiguration() {
        return this.key.subkey.conf;
    }

    public ConfMap getConfigurationSelected() {
        return this.configurationSelected;
    }

    public ElementRelease<P> expectRelease(String artifact) throws EBuildException {
        ElementRelease<P> r;
        if (artifact == null) {
            if (this.releases.size() == 0) {
                throw EBuildException.newConfProblem("No default artifact, because there are no released artifacts: " + this);
            }
            artifact = this.releases.keySet().iterator().next();
        }
        if ((r = this.getRelease(artifact)) == null) {
            throw EBuildException.newConfProblem("No such released artifact '" + artifact + "': " + this);
        }
        return r;
    }

    public ElementRelease<P> getRelease(String artifact) {
        return this.getReleases().get(artifact);
    }

    public Map<String, ElementRelease<P>> getReleases() {
        if (this.releases == null) {
            List<ElementRelease> rs = this.listReleases();
            this.releases = new LinkedHashMap<String, ElementRelease<P>>(rs.size());
            for (ElementRelease r : rs) {
                this.releases.put(r.artifact, r);
            }
        }
        return this.releases;
    }

    public Collection<ElementRelease> iterateReleases() {
        return this.getReleases().values();
    }

    public long lastModificationOfInput(Scope scope) {
        if (this.lastModificationOfInput == null) {
            long r = this.getDependencies(scope).lastModified();
            if (((Element)this.element).isSource()) {
                r = Math.max(r, ((Element)this.element).lastModificationOfSource());
            }
            this.lastModificationOfInput = r;
        }
        return this.lastModificationOfInput;
    }

    public long lastModification(Scope scope) {
        long r = this.lastModificationOfInput(scope);
        r = Math.max(r, FileUtil.deepLastModified(this.getReleaseDirectory()));
        return r;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElementC)) {
            return false;
        }
        ElementC b = (ElementC)obj;
        return this.key.equals(b.key);
    }

    public String toString() {
        return this.key.toString();
    }

    public File getReleaseDirectory() {
        return new File(((Element)this.getPart()).getReleaseDirectory(), this.getConfiguration().asDirectoryName());
    }
}

