/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.util.WorkMarker;
import ebuild.util.FileUtil;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementRelease<P extends Element> {
    public final ElementC<P> cElement;
    public final String artifact;
    private final WorkMarker workMarker;

    public ElementRelease(ElementC cElement, String artifact, WorkMarker workMarker) {
        this.cElement = cElement;
        this.artifact = artifact;
        this.workMarker = workMarker;
    }

    public abstract File[] getFiles();

    public WorkMarker getWorkMarker() {
        return this.workMarker;
    }

    public boolean exists() {
        File[] fileArray = this.getFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.exists()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void delete() {
        File[] fileArray = this.getFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            FileUtil.deleteDir(f);
            ++n2;
        }
    }
}

