/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.compat.IBuildPlugin;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementNature;
import ebuild.core.ModuleC;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.KeyE;
import ebuild.version.EBuildVersion;
import ebuild.xml.ModXml;
import java.io.File;
import org.simpleframework.xml.core.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module
extends Element {
    final IBuildPlugin buildPlugin = this.getBuildPlugin();

    public Module(EBuildMode mode, File directory, EBuild ebuild, KeyE key, ElementNature nature) throws EBuildException {
        super(mode, directory, ebuild, key, nature);
    }

    private IBuildPlugin getBuildPlugin() throws EBuildException {
        File pluginFile = this.getMetaFile(MetaType.BUILD_PLUGIN);
        EBuildVersion v = this.readMetaVersion(pluginFile);
        if (v == null) {
            return null;
        }
        try {
            return this.ebuild.getCompatability(v).getPlugin(pluginFile);
        }
        catch (PersistenceException e) {
            throw EBuildException.newConfProblem("Could not parse build plugin.\n[Simple Xml Exception Message] " + e.getMessage());
        }
        catch (Exception e) {
            throw EBuildException.wrapException("Could not load build plugin: " + this.key, e);
        }
    }

    @Override
    public ModuleC newCElement(ConfKey subKey, ConfMap confSelected) {
        return new ModuleC(this, subKey, confSelected);
    }

    @Override
    public ModuleC getCPart(ConfKey subKey) throws EBuildException {
        return (ModuleC)super.getCPart(subKey);
    }

    @Override
    public ModuleProjectHelper newProjectHelper() {
        return new ModuleProjectHelper(this);
    }

    @Override
    public ModuleProjectHelper getProjectHelper() {
        return (ModuleProjectHelper)super.getProjectHelper();
    }

    @Override
    public ModXml.EbuildModule getDeclaration() {
        return (ModXml.EbuildModule)this.expectMetaAlreadyParsed(MetaType.MODULE);
    }

    @Override
    public ElementType getType() {
        return ElementType.module;
    }

    @Override
    public MetaType getMetaType() {
        return MetaType.MODULE;
    }

    @Override
    public MetaType getMetaTypeOfBuild() {
        return MetaType.MODULE_BUILD;
    }

    @Override
    public void check() throws EBuildException {
    }

    public boolean isPlugin() {
        return this.buildPlugin != null;
    }

    public Iterable<ModXml.Dependency> getDependenciesXml() {
        return this.getDeclaration().dependencies.list;
    }

    public String getJavaVersion() {
        for (ModXml.System d : this.getDeclaration().dependencies.systems) {
            if (!"java.jre".equals(d.name) || d.tag == null) continue;
            return d.tag;
        }
        return "1.6";
    }
}

