/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.conf.ConfExpr;
import ebuild.core.conf.ConfMap;
import ebuild.core.conf.ConfMapping;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Task;
import ebuild.core.impl.TaskSet;
import ebuild.xml.ModXml;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleBuildPlan
extends BuildPlan {
    private final Map<KeyE, Node> nodes = new HashMap<KeyE, Node>();
    private final SelectionNode initialNode = new SelectionNode();
    final Exclude excludeDeep;
    private ConfMap groupConfs = ConfMap.EMPTY;
    private TaskSet resolvedFor = TaskSet.NONE;
    private static final KeyE INITNODE_KEY = KeyE.newUnversioned(null, "-system-", "-dummy-");

    public ModuleBuildPlan(EBuild ebuild, Object key, Exclude excludeDeep) {
        super(ebuild, key);
        this.nodes.put(this.initialNode.key, this.initialNode);
        this.excludeDeep = excludeDeep;
    }

    public ModuleBuildPlan(EBuild ebuild, ElementC<Module> cmodule) {
        this(ebuild, cmodule, Exclude.NONE);
    }

    public ModuleBuildPlan(EBuild ebuild, ElementC<Module> cmodule, Exclude excludes) {
        this(ebuild, cmodule.key, excludes);
        this.addModule((Module)cmodule.element, cmodule.getConfiguration(), Exclude.NONE);
    }

    public void addModule(Module m, ConfMap confs, Exclude exclude) {
        ModuleNode mnode = this.addNode(m, exclude);
        ConfMapping mapping = EBuildUtil.newMapping(confs);
        this.initialNode.addOutgoing(new Outgoing(m.key, mnode, ConfExpr.TRUE, Scope.MAIN, mapping, false, null));
    }

    public void setGroupConfs(ConfMap groupConfs) {
        this.groupConfs = groupConfs;
    }

    public Module expectModule() {
        return (Module)this.expectLoneCPart().element;
    }

    public ModuleC expectLoneCPart() {
        Collection<ModuleC> cElements = this.getPrimaryModules();
        if (cElements.size() != 1) {
            throw new Error("Expected single module, got '" + cElements.size() + ". Is plan ModuleSelection?");
        }
        return cElements.iterator().next();
    }

    public Collection<ModuleC> getPrimaryModules() {
        Map os = this.initialNode.outgoing;
        ArrayList<ModuleC> r = new ArrayList<ModuleC>(os.size());
        for (KeyE ekey : os.keySet()) {
            Outgoing o = (Outgoing)os.get(ekey);
            if (o.scope != Scope.MAIN) continue;
            r.add(o.node.moduleC);
        }
        return r;
    }

    private ModuleNode addNode(Module p, Exclude exclude) {
        ModuleNode r = this.addNode(p.key);
        r.set(p, exclude);
        return r;
    }

    private ModuleNode addNode(KeyE key) {
        ModuleNode r = (ModuleNode)this.nodes.get(key);
        if (r == null) {
            r = new ModuleNode(key);
            this.nodes.put(r.key, r);
        }
        return r;
    }

    @Override
    public void resolveAndConfigureDependencies(TaskSet tasks) throws EBuildException {
        if (this.resolvedFor.includes(tasks)) {
            return;
        }
        this.resolvedFor = this.resolvedFor.combine(tasks);
        this.initialNode.resolveDependencies(tasks);
        this.configure();
    }

    protected Collection<ElementC> gatherReleases() {
        HashSet<ElementC> r = new HashSet<ElementC>();
        for (Node n : this.nodes.values()) {
            if (!(n instanceof ModuleNode)) continue;
            ModuleNode mn = (ModuleNode)n;
            r.add(mn.moduleC);
        }
        return r;
    }

    @Override
    protected void resolveBuilders(TaskSet tasks) throws EBuildException {
        this.initialNode.resolveBuilders(tasks);
    }

    private void configure() throws EBuildException {
        LinkedList<Node> reverseOrder;
        block8: {
            int sizeBefore;
            int sizeAfter;
            HashSet<Node> nodes = new HashSet<Node>(this.nodes.values());
            reverseOrder = new LinkedList<Node>();
            do {
                sizeBefore = nodes.size();
                Iterator I = nodes.iterator();
                while (I.hasNext()) {
                    Node n = (Node)I.next();
                    if (n.ignore()) {
                        I.remove();
                        continue;
                    }
                    if (!n.isConfigurable()) continue;
                    Backtrace.start("configure module", n.key);
                    try {
                        n.configure();
                    }
                    finally {
                        Backtrace.end(n.key);
                    }
                    I.remove();
                    reverseOrder.addFirst(n);
                    break;
                }
                sizeAfter = nodes.size();
                if (sizeAfter == 0) break block8;
            } while (sizeAfter != sizeBefore);
            throw EBuildException.newConfProblem("Could not configure due to cyclical dependency: " + nodes);
        }
        for (Node n : reverseOrder) {
            if (!(n instanceof ModuleNode)) continue;
            ModuleNode mn = (ModuleNode)n;
            mn.setDependencies();
        }
    }

    @Override
    protected void buildActionListForPlan(ActionQueue queue, TaskSet tasks) throws Exception {
        this.initialNode.buildActionList(queue, tasks);
    }

    private class ModuleNode
    extends Node {
        private Module module;
        private boolean processed;
        private Exclude exclude;
        private TaskSet resolvedFor;
        private ModuleC moduleC;

        public ModuleNode(KeyE key) {
            super(key);
            this.processed = false;
            this.exclude = Exclude.NONE;
            this.resolvedFor = TaskSet.NONE;
            this.moduleC = null;
        }

        void set(Module module, Exclude exclude) {
            if (this.module != null) assert (this.module == module);
            this.module = module;
            this.exclude = Exclude.combine(this.exclude, exclude);
        }

        protected boolean skipDependency(Outgoing o) {
            return this.skipDependency(o.dkey, o.subsumed);
        }

        private boolean skipDependency(KeyE dkey, boolean subsumed) {
            if (this.module.isSource()) {
                return false;
            }
            if (subsumed) {
                return true;
            }
            if (this.exclude.match(dkey)) {
                return true;
            }
            return ModuleBuildPlan.this.excludeDeep.match(dkey);
        }

        private void resolveContextAndProcessDependencies() throws EBuildException {
            if (this.processed) {
                return;
            }
            this.processed = true;
            EBuildContext context = this.module.context.resolveSelf();
            Backtrace.start("process dependencies", context);
            try {
                Iterable<ModXml.Dependency> deps = this.module.getDependenciesXml();
                for (ModXml.Dependency d : deps) {
                    String source = d.source;
                    if ("system".equals(source)) continue;
                    KeyE dkey = context.newModuleKeyE(d);
                    Scope dscope = EBuildUtil.getScope(d.scope, Scope.MAIN);
                    ConfExpr dconfs = EBuildUtil.parseConfExpr(d.conf);
                    Exclude dexcludes = Exclude.newExclude(d.excludes);
                    Backtrace.start("process dependency", dkey);
                    try {
                        ModuleNode dnode = ModuleBuildPlan.this.addNode(dkey);
                        ConfMapping dmapping = EBuildUtil.parseMapping(d.confMapping, ConfMapping.EMPTY);
                        this.addOutgoing(new Outgoing(dkey, dnode, dconfs, dscope, dmapping, d.subsumed, d.loadgroup, source, dexcludes));
                    }
                    finally {
                        Backtrace.end(dkey);
                    }
                }
            }
            finally {
                Backtrace.end(context);
            }
        }

        void resolveDependencies(TaskSet tasks) throws EBuildException {
            if (this.resolvedFor.includes(tasks)) {
                return;
            }
            this.resolvedFor = this.resolvedFor.combine(tasks);
            this.resolveContextAndProcessDependencies();
            Scope scope = tasks.getScope();
            Backtrace.start("resolve dependencies", this.module.context);
            try {
                ModuleBuildPlan.this.report.startResolve(this.module.context, "module dependencies");
                ArrayList<Outgoing> resolved = new ArrayList<Outgoing>(this.outgoing.size());
                for (Outgoing o : this.outgoing.values()) {
                    if (!scope.includes(o.scope) || this.skipDependency(o)) continue;
                    o.resolve(this.module);
                    resolved.add(o);
                }
                ModuleBuildPlan.this.report.endResolve();
                for (Outgoing o : resolved) {
                    o.resolveDependencies(tasks);
                }
            }
            finally {
                Backtrace.end(this.module.context);
            }
        }

        public boolean ignore() {
            return this.module == null;
        }

        void configure() throws EBuildException {
            super.configure();
            ModuleBuildPlan.this.report.configure(this.module.key, this.conf_node);
            this.moduleC = this.module.getCPart(new ConfKey(this.conf_node, this.exclude));
        }

        public void setDependencies() throws EBuildException {
            this.setDependencies(this.resolvedFor.getScope());
        }

        public void setDependencies(Scope scope) throws EBuildException {
            if (this.moduleC.getDependencies(scope) != null) {
                return;
            }
            Scope pscope = scope.getParent();
            ModuleDeps pdeps = null;
            if (pscope != null) {
                this.setDependencies(pscope);
                pdeps = this.moduleC.getDependencies(pscope);
            }
            ModuleDeps deps = new ModuleDeps(this.moduleC, scope, pdeps);
            this.setDependencies(scope, deps);
            this.moduleC.setDependencies(scope, deps);
        }

        private void setDependencies(Scope scope, ModuleDeps deps) throws EBuildException {
            Backtrace.start("setup dependencies", this.module.context);
            try {
                Scope dscope;
                for (Outgoing o : this.outgoing.values()) {
                    if (o.scope != scope || !o.confs.evaluate(this.conf_node) || this.skipDependency(o)) continue;
                    ModuleC cElement = o.node.moduleC;
                    deps.addPart(new ModuleDeps.ModuleDep(o.scope, cElement, o.subsumed, o.loadgroup));
                }
                for (ModXml.CheckedIn checkedIn : this.module.getDeclaration().dependencies.checkedIns) {
                    dscope = EBuildUtil.getScope(checkedIn.scope, Scope.MAIN);
                    if (scope != dscope || !EBuildUtil.evaluateExpr(checkedIn.conf, this.conf_node)) continue;
                    ModuleDeps moduleDeps = deps;
                    moduleDeps.getClass();
                    deps.addCheckedIn(new ModuleDeps.CheckedInDep(moduleDeps, dscope, checkedIn.name, checkedIn.type));
                }
                for (ModXml.System system : this.module.getDeclaration().dependencies.systems) {
                    dscope = EBuildUtil.getScope(system.scope, Scope.MAIN);
                    if (scope != dscope || !EBuildUtil.evaluateExpr(system.conf, this.conf_node)) continue;
                    ModuleDeps moduleDeps = deps;
                    moduleDeps.getClass();
                    deps.addSystem(new ModuleDeps.SystemDep(moduleDeps, dscope, system.name, system.tag));
                }
            }
            finally {
                Backtrace.end(this.module.context);
            }
        }

        void resolveBuilders(TaskSet tasks) throws EBuildException {
            ModuleBuildPlan.this.resolveBuildPluginsForPart(this.moduleC);
            super.resolveBuilders(tasks);
        }

        public void buildActionListForNode(ActionQueue queue, TaskSet tasks) throws Exception {
            ModuleBuildPlan.this.buildActionListForPart(queue, (ElementC)this.moduleC, tasks);
        }
    }

    private abstract class Node {
        final KeyE key;
        final Map<KeyE, Node> incoming = new HashMap<KeyE, Node>();
        final Map<KeyE, ConfMap> incomingConfs = new HashMap<KeyE, ConfMap>();
        final Map<KeyE, Outgoing> outgoing = new HashMap<KeyE, Outgoing>();
        ConfMap conf_node = null;

        Node(KeyE key) {
            this.key = key;
        }

        public boolean ignore() {
            return false;
        }

        protected boolean skipDependency(Outgoing o) {
            return false;
        }

        private KeyE key() {
            return this.key;
        }

        public void addOutgoing(Outgoing outgoing) {
            this.outgoing.put(outgoing.dkey, outgoing);
            outgoing.node.incoming.put(this.key(), this);
        }

        void resolveBuilders(TaskSet tasks) throws EBuildException {
            Backtrace.start("resolve builders", this.key);
            try {
                Scope scope = tasks.getScope();
                for (Outgoing o : this.outgoing.values()) {
                    if (!scope.includes(o.scope) || !o.confs.evaluate(this.conf_node) || this.skipDependency(o)) continue;
                    o.node.resolveBuilders(tasks);
                }
            }
            finally {
                Backtrace.end(this.key);
            }
        }

        boolean isConfigured() {
            return this.conf_node != null;
        }

        boolean isConfigurable() {
            for (Node node : this.incoming.values()) {
                if (node.isConfigured()) continue;
                return false;
            }
            return true;
        }

        void configure() throws EBuildException {
            Module m;
            ConfMap.Builder builder = new ConfMap.Builder();
            for (ConfMap confs : this.incomingConfs.values()) {
                builder.addAll(confs);
            }
            if (this instanceof ModuleNode && (m = ((ModuleNode)this).module).isSource()) {
                builder.addAll(ModuleBuildPlan.this.groupConfs);
            }
            this.conf_node = builder.build();
            for (Outgoing o : this.outgoing.values()) {
                if (!o.confs.evaluate(this.conf_node)) continue;
                ConfMap out = o.mapping.evaluate(this.conf_node);
                o.node.incomingConfs.put(this.key(), out);
            }
        }

        private TaskSet requiredTasks(ElementC elementC, TaskSet tasks) {
            if (!((Element)elementC.element).isWorkspace()) {
                tasks = tasks.replace(Task.eclipse_unsetup, Task.build_clean);
                tasks = tasks.replace(Task.eclipse_setup, Task.build_release);
            }
            return tasks;
        }

        public void buildActionListForNode(ActionQueue queue, TaskSet tasks) throws Exception {
        }

        public void buildActionList(ActionQueue queue, TaskSet tasks) throws Exception {
            Backtrace.start("plan", this.key);
            try {
                Scope scope = tasks.getScope();
                for (Outgoing o : this.outgoing.values()) {
                    if (!scope.includes(o.scope) || !o.confs.evaluate(this.conf_node) || this.skipDependency(o)) continue;
                    ModuleC moduleC = o.node.moduleC;
                    TaskSet tasks2 = this.requiredTasks(moduleC, tasks);
                    o.node.buildActionList(queue, tasks2);
                }
                this.buildActionListForNode(queue, tasks);
            }
            finally {
                Backtrace.end(this.key);
            }
        }

        public String toString() {
            return this.key + " " + (this.conf_node == null ? "[unconfigured]" : "" + this.conf_node);
        }
    }

    private class Outgoing {
        final KeyE dkey;
        final ModuleNode node;
        final ConfExpr confs;
        final Scope scope;
        final ConfMapping mapping;
        final boolean subsumed;
        final String loadgroup;
        final String source;
        final Exclude exclude;

        Outgoing(KeyE dkey, ModuleNode node, ConfExpr confs, Scope scope, ConfMapping mapping, boolean subsumed, String loadgroup) {
            this(dkey, node, confs, scope, mapping, subsumed, loadgroup, null, null);
            assert (node.module != null);
        }

        Outgoing(KeyE dkey, ModuleNode node, ConfExpr confs, Scope scope, ConfMapping mapping, boolean subsumed, String loadgroup, String source, Exclude exclude) {
            this.dkey = dkey;
            this.node = node;
            this.confs = confs;
            this.scope = scope;
            this.mapping = mapping;
            this.subsumed = subsumed;
            this.loadgroup = loadgroup;
            this.source = source;
            this.exclude = exclude;
        }

        void resolve(Module from) throws EBuildException {
            if (this.node.module == null) {
                Module dmodule = from.context.resolveModule(this.source, this.dkey);
                this.node.set(dmodule, this.exclude);
            }
        }

        void resolveDependencies(TaskSet tasks) throws EBuildException {
            this.node.resolveDependencies(tasks);
        }
    }

    private class SelectionNode
    extends Node {
        SelectionNode() {
            super(INITNODE_KEY);
        }

        public void resolveDependencies(TaskSet tasks) throws EBuildException {
            for (Outgoing o : this.outgoing.values()) {
                o.resolveDependencies(tasks);
            }
        }
    }
}

