/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.common.Scope;
import ebuild.core.ElementDeps;
import ebuild.core.ElementRelease;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleRelease;
import ebuild.core.ModuleWorkspaceProject;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.KeyE;
import ebuild.util.CollectionUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDeps
extends ElementDeps {
    public final ModuleDeps parent;
    public final Module module;
    public final Scope scope;
    public final Exclude exclude;
    private final Set<String> groups = new HashSet<String>();
    private final Map<KeyE, ModuleDep> elements = new LinkedHashMap<KeyE, ModuleDep>();
    private final Map<KeyE, CheckedInDep> checkedIns = new LinkedHashMap<KeyE, CheckedInDep>();
    private final Map<KeyE, SystemDep> systems = new LinkedHashMap<KeyE, SystemDep>();

    public ModuleDeps(ModuleC moduleC, Scope scope, ModuleDeps parent) {
        this.module = (Module)moduleC.element;
        this.scope = scope;
        this.parent = parent;
        this.exclude = moduleC.key.subkey.exclude;
        if (parent != null) {
            this.groups.addAll(parent.groups);
        }
        assert (scope.getParent() != null || parent == null);
        assert (scope.getParent() == null || parent != null);
    }

    public Collection<String> getLoadGroups() {
        return this.groups;
    }

    public Iterable<ModuleDep> getModuleDeps() {
        if (this.parent == null) {
            return this.elements.values();
        }
        return CollectionUtil.concat(this.parent.getModuleDeps(), this.elements.values());
    }

    public Iterable<CheckedInDep> getCheckedInDeps() {
        if (this.parent == null) {
            return this.checkedIns.values();
        }
        return CollectionUtil.concat(this.parent.getCheckedInDeps(), this.checkedIns.values());
    }

    public Iterable<SystemDep> getSystemDeps() {
        if (this.parent == null) {
            return this.systems.values();
        }
        return CollectionUtil.concat(this.parent.getSystemDeps(), this.systems.values());
    }

    public void addPart(ModuleDep dep) {
        if (dep.loadgroup != null) {
            this.groups.add(dep.loadgroup);
        }
        this.elements.put(dep.key, dep);
    }

    public void addCheckedIn(CheckedInDep dep) {
        this.checkedIns.put(dep.key, dep);
    }

    public void addSystem(SystemDep dep) {
        this.systems.put(dep.key, dep);
    }

    @Override
    public long lastModified() {
        long r = Long.MIN_VALUE;
        for (ModuleC m : this.builders.values()) {
            r = Math.max(r, m.lastModification(Scope.MAIN));
        }
        for (ModuleDep pd : this.elements.values()) {
            r = Math.max(r, pd.moduleC.lastModification(Scope.MAIN));
        }
        for (CheckedInDep cid : this.checkedIns.values()) {
            r = Math.max(r, cid.getFile().lastModified());
        }
        return r;
    }

    public Map<KeyE, AbstractDep> getAll() {
        HashMap<KeyE, AbstractDep> r = new HashMap<KeyE, AbstractDep>();
        r.putAll(this.elements);
        return r;
    }

    public void doDeepGather(Gatherer gatherer, RecurseRule rule) {
        for (SystemDep sd : this.getSystemDeps()) {
            gatherer.add(sd);
        }
        for (CheckedInDep cd : this.getCheckedInDeps()) {
            gatherer.add(cd);
        }
        for (ModuleDep md : this.getModuleDeps()) {
            if (!gatherer.isBuild() && this.exclude.match(md.key) || rule.ignore(md)) continue;
            if (rule.use(md)) {
                gatherer.add(md);
            }
            ModuleDeps mddeps = md.getDependencies();
            mddeps.doDeepGather(gatherer, gatherer.continueRule);
        }
    }

    static abstract class AbstractDep {
        public final Scope scope;
        public final KeyE key;

        AbstractDep(Scope scope, KeyE key) {
            this.scope = scope;
            this.key = key;
        }
    }

    public class CheckedInDep
    extends AbstractDep {
        String type;

        public CheckedInDep(Scope scope, String name, String type) {
            super(scope, KeyE.newUnversioned("checkedin", null, name));
            this.type = type;
        }

        File getFile() {
            File dir = new File(ModuleDeps.this.module.getProjectDirectory(), "checkedin");
            return new File(dir, this.key.name);
        }
    }

    public static abstract class Gatherer {
        private RecurseRule continueRule = RecurseRule.DEFAULT_CONT;

        Gatherer() {
        }

        public void setContinueRule(RecurseRule continueRule) {
            this.continueRule = continueRule;
        }

        public abstract boolean isBuild();

        public abstract void add(ModuleDep var1);

        public abstract void add(SystemDep var1);

        public abstract void add(CheckedInDep var1);
    }

    public static class GathererOfFiles
    extends Gatherer {
        public final String[] artifactTypes;
        public final Set<File> files = new LinkedHashSet<File>();
        private final boolean build;

        public GathererOfFiles(boolean build, String ... artifactTypes) {
            this.build = build;
            this.artifactTypes = artifactTypes;
        }

        public boolean isBuild() {
            return this.build;
        }

        public void add(ModuleDep dep) {
            String[] stringArray = this.artifactTypes;
            int n = this.artifactTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String at = stringArray[n2];
                this.add(dep.getRelease(at));
                ++n2;
            }
        }

        public void add(ModuleRelease mr) {
            if (mr != null) {
                this.files.addAll(mr.getArtifacts());
            }
        }

        public void add(SystemDep dep) {
            String[] stringArray = this.artifactTypes;
            int n = this.artifactTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String at = stringArray[n2];
                File f = dep.getFile(at);
                if (f != null && f.exists()) {
                    this.files.add(f);
                }
                ++n2;
            }
        }

        public void add(CheckedInDep dep) {
            String[] stringArray = this.artifactTypes;
            int n = this.artifactTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String at = stringArray[n2];
                if (at.equals(dep.type)) {
                    this.files.add(dep.getFile());
                }
                ++n2;
            }
        }
    }

    public static class GathererOfReleases
    extends Gatherer {
        public final Set<ElementRelease> releases = new LinkedHashSet<ElementRelease>();

        public void add(ModuleDep dep) {
            this.releases.addAll(dep.moduleC.getReleases().values());
        }

        public boolean isBuild() {
            return false;
        }

        public void add(SystemDep dep) {
        }

        public void add(CheckedInDep dep) {
        }
    }

    public static class GathererOfWSProjects
    extends Gatherer {
        public final Set<IModuleWorkspaceProject> projects = new LinkedHashSet<IModuleWorkspaceProject>();

        public void add(ModuleDep dep) {
            ModuleWorkspaceProject wp = dep.moduleC.getWorkspaceProject();
            if (wp != null) {
                this.projects.add(wp);
            }
        }

        public boolean isBuild() {
            return true;
        }

        public void add(SystemDep dep) {
        }

        public void add(CheckedInDep dep) {
        }
    }

    public static class ModuleDep
    extends AbstractDep {
        public final ModuleC moduleC;
        public final boolean subsumed;
        public final String loadgroup;

        public ModuleDep(Scope scope, ModuleC cElement, boolean subsumed, String loadgroup) {
            super(scope, ((Module)cElement.getPart()).key);
            this.moduleC = cElement;
            this.subsumed = subsumed;
            this.loadgroup = loadgroup;
        }

        public ModuleDeps getDependencies() {
            return this.moduleC.getDependencies(Scope.MAIN);
        }

        public ModuleRelease getRelease(String artifact) {
            return this.moduleC.getRelease(artifact);
        }

        public boolean isWorkspace() {
            return this.moduleC.eclipse != null;
        }

        public String toString() {
            return "subsumed=" + this.subsumed + " " + this.moduleC;
        }
    }

    public static abstract class RecurseRule {
        protected static final RecurseRule DEFAULT_CONT = new RecurseRule(){

            public boolean ignore(ModuleDep md) {
                if (md.subsumed) {
                    return true;
                }
                return md.loadgroup != null;
            }
        };

        public boolean ignore(ModuleDep md) {
            return false;
        }

        public boolean use(ModuleDep md) {
            return true;
        }
    }

    public class SystemDep
    extends AbstractDep {
        public SystemDep(Scope scope, String name, String tag) {
            super(scope, KeyE.newTagged(null, "system", "system", name, tag));
        }

        public String name() {
            return this.key.name;
        }

        public File getFile(String artifactType) {
            String prop;
            if ("java_classes.jar".equals(artifactType) && "java.jdk.tools".equals(this.name()) && (prop = ModuleDeps.this.module.ebuild.getSettingProp("java.jdk.tools")) != null) {
                return new File(prop);
            }
            return null;
        }
    }
}

