/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.ElementRelease;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.util.WorkMarker;
import ebuild.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleRelease
extends ElementRelease<Module> {
    public final Scope scope;
    public final File artifactFile;
    public final File artifactGroup;

    public static ModuleRelease newModuleRelease(ModuleC moduleC, String artifact, String filepart, Scope scope, File releaseConfDir) {
        File parentDir = new File(releaseConfDir, "" + scope);
        File artifactGroup = new File(parentDir, String.valueOf(filepart) + ".group");
        File artifactFile = new File(parentDir, filepart);
        WorkMarker marker = new WorkMarker(artifactFile, artifactGroup);
        return new ModuleRelease(moduleC, artifact, marker, scope, artifactFile, artifactGroup);
    }

    private ModuleRelease(ModuleC moduleC, String artifact, WorkMarker marker, Scope scope, File artifactFile, File artifactGroup) {
        super(moduleC, artifact, new WorkMarker(artifactFile, artifactGroup));
        this.scope = scope;
        this.artifactFile = artifactFile;
        this.artifactGroup = artifactGroup;
    }

    public File getParentDir() {
        return this.artifactFile.getParentFile();
    }

    @Override
    public File[] getFiles() {
        return new File[]{this.artifactFile, this.artifactGroup};
    }

    public Collection<File> getArtifacts() {
        ArrayList<File> r = new ArrayList<File>();
        if (this.artifactGroup.isDirectory()) {
            File[] files;
            File[] fileArray = files = this.artifactGroup.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!"COPYRIGHT.txt".equals(f.getName())) {
                    r.add(f);
                }
                ++n2;
            }
            return r;
        }
        if (this.artifactFile.exists()) {
            r.add(this.artifactFile);
        }
        return r;
    }

    public void subsumeDependencies(Scope scope) throws EBuildException {
        Backtrace.startTop("subsume dependencies", this.cElement.key);
        try {
            ModuleDeps deps = (ModuleDeps)this.cElement.getDependencies(scope);
            for (ModuleDeps.ModuleDep pd : deps.getModuleDeps()) {
                if (!pd.subsumed) continue;
                this.artifactGroup.mkdirs();
                pd.getRelease(this.artifact).subsume(this, pd.scope);
            }
        }
        finally {
            Backtrace.endTop(this.cElement.key);
        }
    }

    public void subsume(ModuleRelease subsumer, Scope subsumerScope) throws EBuildException {
        Backtrace.start("subsume", this.cElement.key);
        try {
            try {
                if (this.artifactGroup.isDirectory()) {
                    FileUtil.mergeCopy(this.artifactGroup, subsumer.artifactGroup);
                }
            }
            catch (IOException e) {
                throw EBuildException.newInternalError("Unable to subsume directory", e);
            }
            ModuleDeps deps = (ModuleDeps)this.cElement.getDependencies(Scope.MAIN);
            for (ModuleDeps.ModuleDep pd : deps.getModuleDeps()) {
                if (pd.subsumed || deps.exclude.match(pd.key)) continue;
                ModuleRelease d = pd.moduleC.getRelease(this.artifact);
                d.subsume(subsumer, subsumerScope);
            }
        }
        finally {
            Backtrace.end(this.cElement.key);
        }
    }

    public String toString() {
        return "ModuleRelease: " + this.cElement + " " + this.scope + " " + this.artifact;
    }
}

