/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IEBuild;
import ebuild.api.IGenConfArgument;
import ebuild.api.IModuleBuildProject;
import ebuild.api.IModuleProject;
import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.api.eclipse.IEclipseProject;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.IPropertyMap;
import ebuild.compat.IModuleProjectInCompat;
import ebuild.core.BuilderChain;
import ebuild.core.BuilderInstance;
import ebuild.core.EBuild;
import ebuild.core.ElementC;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.ModuleRelease;
import ebuild.core.WorkspaceProject;
import ebuild.eclipse.EclipseProject;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import ebuild.util.ObjectUtil;
import ebuild.util.tuple.Pair;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleWorkspaceProject
extends WorkspaceProject<Module>
implements IModuleWorkspaceProject,
IModuleBuildProject,
IModuleProjectInCompat {
    public final Module module;
    public final ModuleC moduleC;
    private final ModuleProjectHelper helper;
    private final EclipseProject eclipseProject;
    private static final Scope[] CALL_ORDER = new Scope[]{Scope.MAIN, Scope.TEST, Scope.POKE};

    public ModuleWorkspaceProject(ElementC<Module> cElement) {
        super((ElementC)cElement);
        this.moduleC = (ModuleC)cElement;
        this.module = (Module)this.moduleC.element;
        this.helper = this.module.getProjectHelper();
        this.eclipseProject = new EclipseProject(this);
    }

    @Override
    public ModuleC getCPart() {
        return (ModuleC)super.getCPart();
    }

    @Override
    public File getSrcDirectory(Scope scope, String type) {
        return this.helper.getSrcDirectory(scope, type);
    }

    public String getArtifactPath(String kind, Scope scope, String type) {
        return this.helper.getSrcFolder(kind, scope, type);
    }

    @Override
    public Collection<File> getCheckedInArtifacts(Scope s, String type) {
        return ModuleProjectHelper.getCheckedInArtifacts(this.cElement, s, type);
    }

    public String getJavaVersion() {
        return this.helper.getJavaVersion();
    }

    public IElementKey getKey() {
        return this.module.key;
    }

    public Collection<String> getLoadGroups(Scope scope) {
        return this.moduleC.getDependencies(scope).getLoadGroups();
    }

    public Collection<File> getBuildDependencies(Scope scope, String artifactType) {
        ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(true, artifactType);
        ModuleDeps deps = (ModuleDeps)this.cElement.getDependencies(scope);
        deps.doDeepGather(gatherer, new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                if (md.moduleC.eclipse != null) {
                    return true;
                }
                return md.loadgroup != null;
            }
        });
        return gatherer.files;
    }

    public File getCorespondingBuildDependency(Scope scope, String artifactType, File artifact) {
        return ModuleProjectHelper.getCorespondingBuildDependency(this, scope, artifactType, artifact);
    }

    private String getSrcPath(boolean gen, Scope scope, String type) {
        return this.helper.getSrcFolder(gen, scope, type);
    }

    public ModuleRelease getModuleRelease() {
        throw new UnsupportedOperationException();
    }

    public void addIgnores(String ... patterns) {
        this.module.addIgnores(patterns);
    }

    public IEclipseProject asEclipseProject() {
        return this.eclipseProject;
    }

    public String filePrefix() {
        return null;
    }

    public Collection<IModuleWorkspaceProject> getWorkspaceDependencies(Scope scope) {
        LinkedHashSet<IModuleWorkspaceProject> r = new LinkedHashSet<IModuleWorkspaceProject>();
        for (ModuleDeps.ModuleDep pd : this.moduleC.getDependencies(scope).getModuleDeps()) {
            if (pd.moduleC.eclipse == null || pd.loadgroup != null) continue;
            r.add((IModuleWorkspaceProject)pd.moduleC.eclipse);
        }
        return r;
    }

    public Collection<File> getDependencyArtifacts(final String loadgroup, String artifactType) {
        ModuleDeps deps = (ModuleDeps)this.cElement.getDependencies(Scope.MAIN);
        ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(true, artifactType);
        gatherer.setContinueRule(new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                return DEFAULT_CONT.ignore(md);
            }

            public boolean use(ModuleDeps.ModuleDep md) {
                return !md.isWorkspace();
            }
        });
        deps.doDeepGather(gatherer, new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                if (!ObjectUtil.areEqual(loadgroup, md.loadgroup)) {
                    return true;
                }
                return md.subsumed;
            }

            public boolean use(ModuleDeps.ModuleDep md) {
                return !md.isWorkspace();
            }
        });
        return gatherer.files;
    }

    public Collection<IModuleWorkspaceProject> getDependencyProjects(final String loadgroup, String artifact) {
        ModuleDeps deps = (ModuleDeps)this.cElement.getDependencies(Scope.MAIN);
        ModuleDeps.GathererOfWSProjects gatherer = new ModuleDeps.GathererOfWSProjects();
        deps.doDeepGather(gatherer, new ModuleDeps.RecurseRule(){

            public boolean ignore(ModuleDeps.ModuleDep md) {
                if (!ObjectUtil.areEqual(loadgroup, md.loadgroup)) {
                    return true;
                }
                if (md.subsumed) {
                    return true;
                }
                return !md.isWorkspace();
            }
        });
        return gatherer.projects;
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.eclipseProject.init();
        final EBuild ebuild = this.module.ebuild;
        BuilderChain chain = this.getCPart().configureAndParameterizeBuilderChain();
        Pair<Collection<BuilderInstance>, Collection<BuilderInstance>> builders = chain.getBuildersForEclipse();
        for (final BuilderInstance b : (Collection)builders.a) {
            Scope[] scopeArray = CALL_ORDER;
            int n = CALL_ORDER.length;
            int n2 = 0;
            while (n2 < n) {
                Scope s = scopeArray[n2];
                ModuleProjectHelper.AbstractBuilderArgument arg = new ModuleProjectHelper.AbstractBuilderArgument(this, s, b){

                    public boolean isBuild() {
                        return false;
                    }

                    public boolean isFirstCall() {
                        return this.scope == CALL_ORDER[0];
                    }

                    public File getExportDirectory(String artifactType) {
                        return this.getGenDirectory(artifactType);
                    }

                    public File getGenDirectory(String artifactType) {
                        return new File(this.module.getProjectDirectory(), ModuleWorkspaceProject.this.getSrcPath(true, this.getScope(), artifactType));
                    }

                    public File getIntermediateDir(String uniquePath) {
                        throw new UnsupportedOperationException();
                    }

                    public IModuleBuildProject getModuleBuildProject() {
                        return ModuleWorkspaceProject.this;
                    }

                    public File getOutputArtifact(String artifactType, boolean alwaysNamed) {
                        File export = this.getExportDirectory(artifactType);
                        if (alwaysNamed) {
                            String suffix = FileUtil.fileSuffix(artifactType);
                            String fileName = this.filePrefix;
                            if (suffix != null) {
                                fileName = String.valueOf(fileName) + "." + suffix;
                            }
                            return new File(export, fileName);
                        }
                        return export;
                    }
                };
                b.build(arg);
                ++n2;
            }
        }
        for (final BuilderInstance b : (Collection)builders.b) {
            if (!b.hasEclipseNature()) continue;
            b.generateEclipseProjectSettings(new IGenConfArgument(){

                public IModuleWorkspaceProject getModuleWorkspaceProject() {
                    return ModuleWorkspaceProject.this;
                }

                public ILogger getLogger() {
                    return ebuild.logger.newSubLogger("Eclipse/" + b.name());
                }

                public IEBuild getEBuild() {
                    return ebuild;
                }

                public IPropertyMap getPropertyMap() {
                    return b.props;
                }
            });
        }
        this.eclipseProject.commit();
    }

    @Override
    public void unsetup() throws Exception {
        super.unsetup();
        FileUtil.deleteDir(this.module.getFile("gen"));
        this.module.getFile(".classpath").delete();
    }

    public String readProjectFile(String path) throws IOException {
        return IOUtil.fileToString(this.getProjectFile(path));
    }

    public void writeProjectFile(String path, String text) throws IOException {
        IOUtil.stringToFile(text, this.getProjectFile(path));
    }

    public Collection<IModuleProject> getProjectDependencies(Scope scope) {
        LinkedHashSet<IModuleProject> r = new LinkedHashSet<IModuleProject>();
        for (ModuleDeps.ModuleDep dep : ((ModuleC)this.cElement).getDependencies(scope).getModuleDeps()) {
            if (dep.moduleC.eclipse != null) {
                r.add((IModuleProject)dep.moduleC.eclipse);
                continue;
            }
            if (dep.subsumed) continue;
            r.add((IModuleProject)dep.moduleC.getOrCreateBuildProject());
        }
        return r;
    }

    @Override
    public File getReleaseSubDir() {
        return null;
    }

    @Override
    public Collection getReleasedDependencies(Scope scope) {
        LinkedHashSet r = new LinkedHashSet();
        for (ModuleDeps.ModuleDep pd : ((ModuleC)this.cElement).getDependencies(scope).getModuleDeps()) {
            if (pd.moduleC.eclipse != null || pd.subsumed) continue;
            r.add(pd.moduleC.getOrCreateBuildProject());
        }
        return r;
    }
}

