/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.base.EBuildException;
import ebuild.base.MetaType;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementNature;
import ebuild.core.ProductC;
import ebuild.core.ProductProjectHelper;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.Exclude;
import ebuild.core.impl.KeyE;
import ebuild.core.util.NameTemplate;
import ebuild.xml.PrdXml;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Product
extends Element {
    private Map<String, NameTemplate> artifacts;
    private String defaultArtifact;

    public Product(EBuildMode mode, File directory, EBuild ebuild, KeyE key, ElementNature nature) throws EBuildException {
        super(mode, directory, ebuild, key, nature);
    }

    @Override
    public void check() throws EBuildException {
        PrdXml.EbuildProduct declaration = (PrdXml.EbuildProduct)this.expectMetaAlreadyParsed(MetaType.PRODUCT);
        LinkedHashMap<String, NameTemplate> artifacts = new LinkedHashMap<String, NameTemplate>();
        for (PrdXml.Artifact a : declaration.artifacts) {
            artifacts.put(a.name, this.getNameTemplate(a));
        }
        if (artifacts.size() == 0) {
            throw EBuildException.newConfProblem("Expected at least one <artifact/> in product declaration.");
        }
        this.defaultArtifact = (String)artifacts.keySet().iterator().next();
        this.artifacts = artifacts;
    }

    @Override
    public PrdXml.EbuildProduct getDeclaration() {
        return (PrdXml.EbuildProduct)this.expectMetaAlreadyParsed(MetaType.PRODUCT);
    }

    @Override
    public ElementC newCElement(ConfKey subKey, ConfMap confSelected) {
        return new ProductC(this, subKey, confSelected);
    }

    @Override
    public ProductProjectHelper newProjectHelper() throws EBuildException {
        return new ProductProjectHelper(this);
    }

    @Override
    public ProductProjectHelper getProjectHelper() {
        return (ProductProjectHelper)super.getProjectHelper();
    }

    @Override
    public ElementType getType() {
        return ElementType.product;
    }

    @Override
    public MetaType getMetaType() {
        return MetaType.PRODUCT;
    }

    @Override
    public MetaType getMetaTypeOfBuild() {
        return MetaType.PRODUCT_ASSEMBLY;
    }

    public Map<String, ModuleSelection> getModuleSelections(ConfKey subKey) throws EBuildException {
        ConfMap conf = subKey.conf;
        final HashMap<String, ModuleSelection> r = new HashMap<String, ModuleSelection>();
        ProductProjectHelper productProjectHelper = this.getProjectHelper();
        productProjectHelper.getClass();
        new ProductProjectHelper.AssemblyVisitor(productProjectHelper, conf){

            public Object visitModuleSelection(String path, PrdXml.ModuleSelection moduleSelectionXml) {
                String confMapping = moduleSelectionXml.confMapping;
                List<PrdXml.Include> includes = moduleSelectionXml.includes;
                PrdXml.OurModule ours = moduleSelectionXml.ourModule;
                Exclude excludes = Exclude.newExclude(moduleSelectionXml.excludes);
                if (ours != null) {
                    PrdXml.Include inc = new PrdXml.Include();
                    inc.source = "local";
                    inc.org = Product.this.key.org;
                    inc.name = Product.this.key.name;
                    inc.conf = ours.conf;
                    inc.confMapping = ours.confMapping;
                    inc.revision = Product.this.key.version.getRevision();
                    inc.branch = Product.this.key.version.getBranch();
                    inc.tag = Product.this.key.version.getTag();
                    inc.dependencies = ours.dependencies;
                    ArrayList<PrdXml.Include> l2 = new ArrayList<PrdXml.Include>(includes.size() + 1);
                    l2.addAll(includes);
                    l2.add(inc);
                    includes = l2;
                }
                ModuleSelection msi = new ModuleSelection(moduleSelectionXml.artifact, confMapping, includes, excludes);
                r.put(path, msi);
                return null;
            }
        }.goAll();
        return r;
    }

    public Map<String, PrdXml.Product> getSelectedComponentsXml(ConfKey subKey) throws EBuildException {
        final HashMap<String, PrdXml.Product> r = new HashMap<String, PrdXml.Product>();
        ProductProjectHelper productProjectHelper = this.getProjectHelper();
        productProjectHelper.getClass();
        new ProductProjectHelper.AssemblyVisitor(productProjectHelper, subKey.conf){

            Object visitProduct(String path, PrdXml.Product component) {
                r.put(path, component);
                return null;
            }
        }.goAll();
        return r;
    }

    public String releaseSourceFileName() {
        return this.key.fullnameAndVersion();
    }

    public String expectArtifactName(String artifact, ConfMap confs) {
        String r = this.getArtifactName(artifact, confs);
        if (r == null) {
            throw new Error("No such artifact: " + artifact);
        }
        return r;
    }

    public String getArtifactName(String artifact, ConfMap confs) {
        NameTemplate nt;
        if (artifact == null) {
            artifact = this.defaultArtifact;
        }
        if ((nt = this.artifacts.get(artifact)) == null) {
            return null;
        }
        return nt.apply(EBuildUtil.newNameTemplateModel(this.key.version, confs));
    }

    private NameTemplate getNameTemplate(PrdXml.Artifact a) throws EBuildException {
        String pattern = a.pattern;
        if (pattern == null) {
            String prefix = a.prefix;
            if (prefix == null) {
                prefix = a.name;
            }
            pattern = String.valueOf(prefix) + "{-|confs}{-|version}";
            String suffix = a.suffix;
            if (suffix != null) {
                pattern = String.valueOf(pattern) + suffix;
            }
        }
        return NameTemplate.parse(pattern);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ModuleSelection {
        final String artifact;
        final String groupMapping;
        final List<PrdXml.Include> includes;
        final Exclude excludes;

        ModuleSelection(String artifact, String groupMapping, List<PrdXml.Include> includes, Exclude excludes) {
            this.artifact = artifact;
            this.groupMapping = groupMapping;
            this.includes = includes;
            this.excludes = excludes;
        }
    }
}

