/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.core.BuildProject;
import ebuild.core.ElementC;
import ebuild.core.Product;
import ebuild.core.ProductBuildProject;
import ebuild.core.ProductDeps;
import ebuild.core.ProductRelease;
import ebuild.core.WorkspaceProject;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.xml.PrdXml;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductC
extends ElementC<Product> {
    private ProductDeps dependencies;

    public ProductC(Product component, ConfKey subKey, ConfMap confSelected) {
        super(component, subKey, confSelected);
    }

    @Override
    public BuildProject newBuildProject() {
        return new ProductBuildProject(this);
    }

    @Override
    public WorkspaceProject newEclipseProject() {
        return new WorkspaceProject<Product>((ElementC)this){};
    }

    @Override
    public ProductDeps getDependencies(Scope scope) {
        return this.dependencies;
    }

    public ProductRelease getRelease(String artifact) {
        return (ProductRelease)this.getReleases().get(artifact);
    }

    public ProductDeps getDependencies() {
        return this.getDependencies(Scope.MAIN);
    }

    public void setDependencies(ProductDeps dependencies) {
        this.dependencies = dependencies;
    }

    public String getReleaseFileName(String artifact) {
        return ((Product)this.element).getArtifactName(artifact, this.getConfigurationSelected());
    }

    @Override
    public List<ProductRelease> listReleases() {
        PrdXml.EbuildProduct meta = ((Product)this.element).getDeclaration();
        ArrayList<ProductRelease> r = new ArrayList<ProductRelease>(meta.artifacts.size());
        for (PrdXml.Artifact a : meta.artifacts) {
            String filename = ((Product)this.element).expectArtifactName(a.name, this.getConfigurationSelected());
            File file = new File(((Product)this.element).getReleaseDirectory(), filename);
            r.add(new ProductRelease(this, a.name, file));
        }
        return r;
    }
}

