/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.core.ElementC;
import ebuild.core.ElementDeps;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.ModuleRelease;
import ebuild.core.Product;
import ebuild.core.impl.Exclude;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ProductDeps
extends ElementDeps {
    public final Map<String, ComponentDep> components = new HashMap<String, ComponentDep>();
    public final Map<String, ModuleSelectionDep> moduleSelections = new HashMap<String, ModuleSelectionDep>();

    public void addComponent(ComponentDep dep) {
        this.components.put(dep.key, dep);
    }

    public void addModuleSelection(ModuleSelectionDep dep) {
        this.moduleSelections.put(dep.key, dep);
    }

    public long lastModified() {
        long r = Long.MIN_VALUE;
        for (ModuleC m : this.builders.values()) {
            r = Math.max(r, m.lastModification(Scope.MAIN));
        }
        for (ComponentDep cd : this.components.values()) {
            r = Math.max(r, cd.cElement.lastModification(Scope.MAIN));
        }
        for (ModuleSelectionDep msd : this.moduleSelections.values()) {
            for (ElementC elementC : msd.modules) {
                r = Math.max(r, elementC.lastModification(Scope.MAIN));
            }
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComponentDep {
        final String key;
        final ElementC<Product> cElement;
        final String artifact;

        public ComponentDep(String key, ElementC<Product> cElement, String artifact) {
            this.key = key;
            this.cElement = cElement;
            this.artifact = artifact;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModuleSelectionDep {
        final String key;
        final Collection<ModuleC> modules;

        public ModuleSelectionDep(String key, Collection<ModuleC> modules) {
            this.key = key;
            this.modules = modules;
        }

        public Collection<File> getArtifacts(final Exclude deepExclude, String[] artifactTypes) {
            ModuleDeps.RecurseRule rule = new ModuleDeps.RecurseRule(){

                public boolean ignore(ModuleDeps.ModuleDep md) {
                    if (deepExclude.match(md.key)) {
                        return true;
                    }
                    return DEFAULT_CONT.ignore(md);
                }
            };
            ModuleDeps.GathererOfFiles gatherer = new ModuleDeps.GathererOfFiles(false, artifactTypes);
            gatherer.setContinueRule(rule);
            for (ElementC elementC : this.modules) {
                ModuleDeps mcdeps = (ModuleDeps)elementC.getDependencies(Scope.MAIN);
                mcdeps.doDeepGather(gatherer, rule);
                String[] stringArray = artifactTypes;
                int n = artifactTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String a = stringArray[n2];
                    ModuleRelease mr = (ModuleRelease)elementC.getRelease(a);
                    gatherer.add(mr);
                    ++n2;
                }
            }
            return gatherer.files;
        }
    }
}

