/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.base.EBuildException;
import ebuild.core.ActionQueue;
import ebuild.core.BuildPlan;
import ebuild.core.EBuild;
import ebuild.core.ElementC;
import ebuild.core.impl.TaskSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseBuildPlan
extends BuildPlan {
    final Collection<ElementC> cElements;
    private final List<BuildPlan> subPlans;

    public ReleaseBuildPlan(EBuild ebuild, Collection<ElementC> cElements) {
        super(ebuild, "release");
        this.cElements = cElements;
        this.subPlans = new ArrayList<BuildPlan>(cElements.size());
    }

    @Override
    protected void resolveBuilders(TaskSet tasks) throws EBuildException {
    }

    @Override
    protected void resolveAndConfigureDependencies(TaskSet tasks) throws EBuildException {
        for (ElementC ce : this.cElements) {
            BuildPlan subPlan = this.ebuild.getBuildPlan(ce);
            this.subPlans.add(subPlan);
            this.report.configure(ce.key.ekey, ce.getConfigurationSelected());
        }
        for (BuildPlan bp : this.subPlans) {
            bp.resolveAndConfigure(tasks);
        }
    }

    @Override
    protected void buildActionListForPlan(ActionQueue queue, TaskSet tasks) throws Exception {
        for (BuildPlan subPlan : this.subPlans) {
            subPlan.buildActionList(queue, tasks);
        }
    }
}

