/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.IElementKey;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.IRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.base.EBuildException;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.ElementNature;
import ebuild.core.RepositoryRef;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyE;
import ebuild.core.util.WorkMarker;
import java.io.File;
import java.util.Map;

public class RepositoryContext {
    public final IRepository repo;
    private static final String WORKSPACE = "workspace";

    public RepositoryContext(IRepository repo) {
        this.repo = repo;
    }

    public IRepository expectRepo(KeyE key) throws EBuildException {
        if (this.repo == null) {
            throw EBuildException.newConfProblem("Repository cannot be located for element: " + key);
        }
        return this.repo;
    }

    public AbstractSourceRepository expectSourceRepo(KeyE key) throws EBuildException {
        IRepository r = this.expectRepo(key);
        if (!(r instanceof AbstractSourceRepository)) {
            throw EBuildException.newBadRequest("Not a source repository for element '" + key + "': " + r.getUri());
        }
        return (AbstractSourceRepository)r;
    }

    public void fetchMeta(KeyE key, File dir4version) throws EBuildException {
        File dir4meta = new File(dir4version, "meta");
        WorkMarker marker = new WorkMarker(dir4meta);
        if (!marker.isComplete()) {
            IRepository repo = this.expectRepo(key);
            marker.create();
            try {
                repo.fetchMeta(dir4meta, (IElementKey)key);
            }
            catch (RepositoryPluginException e) {
                throw EBuildException.newRepoIssue("Could not fetch meta for '" + key + "'", e);
            }
            marker.remove();
        }
    }

    public ElementNature determineNature(KeyE key, File dir4version) throws EBuildException {
        if (this.repo != null) {
            if (this.repo instanceof AbstractSourceRepository) {
                return ElementNature.source;
            }
            return ElementNature.binary;
        }
        if (new File(dir4version, "project").exists()) {
            return ElementNature.source;
        }
        if (new File(dir4version, "release").exists()) {
            return ElementNature.binary;
        }
        throw EBuildException.newConfProblem("Cannot determine element nature (repository unknown, no project dir, no release dir): " + dir4version);
    }

    public String toString() {
        return "" + this.repo;
    }

    public static class Source
    extends RepositoryContext {
        final EBuildContext context;
        private final String name;
        private String fixedRevision;

        public Source(EBuildContext context, String name, AbstractSourceRepository repository) {
            super((IRepository)repository);
            this.context = context;
            this.name = name;
        }

        public AbstractSourceRepository getRepository() {
            return (AbstractSourceRepository)this.repo;
        }

        public String expectFixedRevision() throws EBuildException {
            if (this.fixedRevision == null) {
                String repoUrl = this.getRepository().getUri();
                Map<String, String> upstreamRevisions = this.context.getUpstreamRevisions();
                this.fixedRevision = upstreamRevisions.get(repoUrl);
            }
            if (this.fixedRevision == null) {
                throw EBuildException.newConfProblem("Upstream dependency not fixed to a revision: " + this + "-" + this.name);
            }
            if (this.fixedRevision.equals(RepositoryContext.WORKSPACE)) {
                throw EBuildException.newConfProblem("Upstream dependency fixed to workspace: " + this + "-" + this.name);
            }
            return this.fixedRevision;
        }

        public String getUpdatedFixedRevision(RepositoryRef ref, EBuildContext from, KeyE dkey) throws EBuildException {
            if (this.context.element.isWorkspace()) {
                if (this.fixedRevision == null) {
                    EBuild ebuild = from.element.ebuild;
                    String latest = ebuild.getWorkspaceHeadRevision(this.getRepository());
                    this.writeFixedRevision(from, dkey, latest);
                    ebuild.logger.log("  head revision of '" + ref.name + "' -> " + latest);
                } else if (this.fixedRevision.equals(RepositoryContext.WORKSPACE)) {
                    return EBuildUtil.expectHeadRevision(this.getRepository());
                }
                return this.fixedRevision;
            }
            return this.expectFixedRevision();
        }

        public void setFixedRevisionToWorkspace(EBuildContext from, KeyE key) throws EBuildException {
            if (RepositoryContext.WORKSPACE.equals(this.fixedRevision)) {
                return;
            }
            this.writeFixedRevision(from, key, RepositoryContext.WORKSPACE);
        }

        private void writeFixedRevision(EBuildContext from, KeyE dkey, String latest) throws EBuildException {
            String repoUrl = this.getRepository().getUri();
            Map<String, String> upstreamRevisions = this.context.getUpstreamRevisions();
            String latestPreviously = upstreamRevisions.get(repoUrl);
            if (!latest.equals(latestPreviously)) {
                if (!this.context.element.isWorkspace()) {
                    throw EBuildException.newInternalError("Cannot update revision for '" + dkey + "' " + latestPreviously + "->" + latest);
                }
                upstreamRevisions.put(repoUrl, latest);
                this.context.updateUpstreamRevisions(upstreamRevisions);
            }
            this.fixedRevision = latest;
        }
    }
}

