/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.base.Backtrace;
import ebuild.base.BuildPluginType;
import ebuild.base.EBuildException;
import ebuild.base.EBuildLogger;
import ebuild.base.PluginUtil;
import ebuild.compat.AbstractCompatability;
import ebuild.compat_0_8.Compatability;
import ebuild.core.BuildPlanRunner;
import ebuild.core.EBuild;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ModuleC;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Task;
import ebuild.core.impl.Version;
import ebuild.repo.http.HttpRepositoryProvider;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import ebuild.util.JSONUtil;
import ebuild.version.EBuildVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPlugins {
    private static Map<String, Version> name2version = CollectionUtil.newMap("repo.svn", Version.newTag("0.7-2"), "repo.maven", Version.newRevision("374"), "repo.ivy", Version.newRevision("374"), "compat.0_7", Version.newRevision("386"));
    private final EBuild ebuild;
    private final ILogger logger;
    private static Map<String, String> type2plugin = CollectionUtil.newMap("svn", "repo.svn", "maven", "repo.maven", "ivy", "repo.ivy", "http", "repo.http");

    private static Version getVersion(EBuild ebuild0, String name) {
        String versionStr = ebuild0.getSettingProp("version-" + name);
        return Version.fromString(versionStr, name2version.get(name));
    }

    SystemPlugins(EBuild ebuild) {
        this.ebuild = ebuild;
        this.logger = ebuild.logger;
    }

    private Module installModule(String name, Version v) throws EBuildException {
        Module module;
        KeyE key = new KeyE(ElementType.module, "release", "ebuild", name, v);
        EBuild.Options options = (EBuild.Options)this.ebuild.options.clone();
        options.noSkipping = false;
        options.verbosity = options.verbosity.isVeryVerbose() ? EBuild.Verbosity.two : EBuild.Verbosity.normal;
        EBuild ebuild1 = new EBuild(this.ebuild.apiClassLoader, options, (EBuildLogger)this.ebuild.logger.newSubLogger("Installing " + key.fullname()), false);
        String source = "public";
        if (key.version.isMoving()) {
            source = "local";
        }
        Backtrace.startTop("Install module", key);
        try {
            Module module2 = (Module)ebuild1.context.resolveElement(source, key);
            Install install = new Install(ebuild1, module2);
            install.go();
            module = module2;
        }
        catch (Throwable throwable) {
            try {
                Backtrace.endTop(key);
                throw throwable;
            }
            catch (Exception e) {
                throw EBuildException.newInternalError("Failed to install repository provider: " + name, e);
            }
        }
        Backtrace.endTop(key);
        return module;
    }

    private List<String> addInParentDir(List<String> classpath) {
        ArrayList<String> r = new ArrayList<String>(classpath.size());
        for (String s : classpath) {
            if (s.contains("ebuild-api") && !s.contains("remap")) continue;
            File f = new File(s);
            if (!f.isAbsolute()) {
                s = this.ebuild.getFile(s).getAbsolutePath();
            }
            r.add(s);
        }
        return r;
    }

    private File getPluginPathFile(String name) {
        String pathPath = "system/plugins/" + name;
        return this.ebuild.getFile(pathPath);
    }

    private Object loadPlugin(BuildPluginType type, File pathFile, Map path) throws EBuildException {
        String class_ = (String)path.get("class");
        List<String> classpath = this.addInParentDir((List)path.get("classpath"));
        ClassLoader cl = PluginUtil.createPluginClassLoader(type, this.getClass().getClassLoader(), classpath);
        if (this.ebuild.isDEBUG()) {
            if (type == BuildPluginType.COMPAT) {
                this.logger.log("path for '" + pathFile.getName() + "' api part: ");
                this.logger.log(PluginUtil.displayClassloader(this.ebuild, cl.getParent()));
            }
            this.logger.log("path for '" + pathFile.getName() + "': ");
            this.logger.log(PluginUtil.displayClassloader(this.ebuild, cl));
        }
        return PluginUtil.instantiate(this.ebuild, cl, class_);
    }

    private Object loadPlugin(BuildPluginType type, String name, Version v) throws EBuildException {
        try {
            File pathFile = this.getPluginPathFile(name);
            if (!pathFile.exists()) {
                throw EBuildException.newInternalError("Expected _ebuild/system/plugins/" + name);
            }
            String pathString = IOUtil.fileToString(pathFile);
            Map path = JSONUtil.readMap(pathString);
            String version = (String)path.get("version");
            if (version != null && !v.toString().equals(version)) {
                throw EBuildException.newInternalError("Invalid version: " + version);
            }
            return this.loadPlugin(type, pathFile, path);
        }
        catch (Exception e) {
            throw EBuildException.newInternalError("Unable to load system plugin", e);
        }
    }

    private Object loadPluginAttempt(BuildPluginType type, String name, Version v) {
        Map path;
        File pathFile;
        block5: {
            block4: {
                try {
                    pathFile = this.getPluginPathFile(name);
                    if (pathFile.exists()) break block4;
                    return null;
                }
                catch (Exception e) {
                    this.logger.warn("Problem loading previously installed plugin: " + name, e);
                    return null;
                }
            }
            String pathString = IOUtil.fileToString(pathFile);
            path = JSONUtil.readMap(pathString);
            String version = (String)path.get("version");
            if (version == null || v.toString().equals(version)) break block5;
            return null;
        }
        return this.loadPlugin(type, pathFile, path);
    }

    private Object usePlugin(BuildPluginType type, String name) throws EBuildException {
        this.logger.log("*using '" + name + "'");
        Version v = SystemPlugins.getVersion(this.ebuild, name);
        if (v == null) {
            throw EBuildException.newInternalError("No such system module: " + name, null);
        }
        Object plugin = this.loadPluginAttempt(type, name, v);
        if (plugin == null) {
            this.installModule(name, v);
            Backtrace.startTop("load plugin", name);
            try {
                plugin = this.loadPlugin(type, name, v);
            }
            finally {
                Backtrace.endTop(name);
            }
        }
        return plugin;
    }

    public AbstractCompatability useCompatability(EBuildVersion v) throws EBuildException {
        if (EBuildVersion._0_8 == v) {
            return new Compatability();
        }
        String name = "compat." + v.name().substring(1);
        return (AbstractCompatability)this.usePlugin(BuildPluginType.COMPAT, name);
    }

    public AbstractRepositoryProvider useRepoProvider(String repoType) throws EBuildException {
        if ("http".equals(repoType)) {
            HttpRepositoryProvider r = new HttpRepositoryProvider();
            r.initLogger(this.logger.newSubLogger("repo.http"));
            return r;
        }
        String name = type2plugin.get(repoType);
        if (name == null) {
            throw EBuildException.newInternalError("Unknown repository type: " + repoType);
        }
        AbstractRepositoryProvider r = (AbstractRepositoryProvider)this.usePlugin(BuildPluginType.REPO, name);
        r.initLogger(this.logger.newSubLogger(name));
        r.initCredentials(this.ebuild.getCredentialsFile(String.valueOf(name) + ".logins"));
        return r;
    }

    public void registerSystemPlugin(ModuleC moduleC, Collection<String> classpath) {
        Module module = (Module)moduleC.element;
        KeyE key = module.key;
        if (SystemPlugins.getVersion(module.ebuild, key.name) == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", "" + key.version);
        map.put("class", module.buildPlugin.getPluginClass());
        map.put("classpath", new ArrayList<String>(classpath));
        String name = key.org.equals("ebuild") ? key.name : key.fullname();
        try {
            File classpathFile = this.getPluginPathFile(name);
            FileUtil.mkdirOrFail(classpathFile.getParentFile());
            JSONUtil.writeObject(classpathFile, map);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static class Install
    extends BuildPlanRunner {
        final EBuild ebuild;
        final Module module;

        public Install(EBuild ebuild, Module module) throws Exception {
            this.ebuild = ebuild;
            this.module = module;
        }

        protected EBuild getEBuild() {
            return this.ebuild;
        }

        public void go() throws Exception {
            this.go(new ModuleBuildPlan(this.getEBuild(), this.module.getDefault(), ModuleC.NOAPI), Task.build_release);
        }

        public String getKey() {
            return "install " + this.module.key;
        }
    }
}

