/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.conf;

import ebuild.api.common.IConfiguration;
import ebuild.core.conf.ConfExpr;
import ebuild.util.CollectionUtil;
import ebuild.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfMap
implements IConfiguration,
ConfExpr,
Iterable<String> {
    public static final ConfMap EMPTY = new ConfMap(CollectionUtil.EMPTY_SET);
    private final SortedMap<String, String> vals;

    private static SortedMap<String, String> set2map(Set<String> set) {
        TreeMap<String, String> r = new TreeMap<String, String>();
        for (String c : set) {
            r.put(c, null);
        }
        return r;
    }

    public ConfMap(Set<String> vals) {
        this(ConfMap.set2map(vals));
    }

    public ConfMap(SortedMap<String, String> vals) {
        this.vals = vals;
    }

    public boolean isEmpty() {
        return this.vals.size() == 0;
    }

    public boolean includes(String conf) {
        return this.asCollection().contains(conf);
    }

    public boolean includesAll(ConfMap cs) {
        return this.asCollection().containsAll(cs.asCollection());
    }

    @Override
    public boolean evaluate(ConfMap input) {
        return input.includesAll(this);
    }

    @Override
    public Iterator<String> iterator() {
        return this.asCollection().iterator();
    }

    public Collection<String> asCollection() {
        return this.vals.keySet();
    }

    private Collection<String> asKeyValueCollection() {
        ArrayList<String> l = new ArrayList<String>(this.vals.size());
        for (String k : this.vals.keySet()) {
            String v = (String)this.vals.get(k);
            if (v == null) {
                l.add(k);
                continue;
            }
            l.add(String.valueOf(k) + "=" + v);
        }
        return l;
    }

    public String asJson() {
        return JSONValue.toJSONString(new ArrayList<String>(this.asCollection()));
    }

    public static ConfMap fromJson(String json) throws IOException {
        try {
            List vals = (List)JSONValue.parseWithException(json);
            TreeSet<String> vs = new TreeSet<String>();
            for (String s : vs) {
                vals.add(s);
            }
            return new ConfMap(vs);
        }
        catch (ParseException e) {
            throw new IOException("Could not parse JSON: " + e.getMessage());
        }
    }

    public Map<String, String> asMap() {
        return this.vals;
    }

    public String asDirectoryName() {
        if (this.vals.size() == 0) {
            return "_default";
        }
        return StringUtil.join("-", this.asKeyValueCollection().toArray());
    }

    public String asFileTrailingPart() {
        Collection<String> l = this.asKeyValueCollection();
        if (l.size() == 0) {
            return "";
        }
        return "-" + StringUtil.join("-", l.toArray());
    }

    public String toString() {
        return StringUtil.join(",", this.asKeyValueCollection().toArray());
    }

    public int hashCode() {
        return this.vals.hashCode();
    }

    public boolean equals(Object obj) {
        ConfMap b = (ConfMap)obj;
        return this.vals.equals(b.vals);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private SortedMap<String, String> vals = new TreeMap<String, String>();

        public Builder add(String name) {
            return this.add(name, null);
        }

        public Builder add(String name, String value) {
            this.vals.put(name, value);
            return this;
        }

        public Builder addAll(ConfMap confs) {
            this.vals.putAll(confs.vals);
            return this;
        }

        public Builder addAll(Iterable<String> ss) {
            for (String s : ss) {
                this.add(s);
            }
            return this;
        }

        public Builder removeAll(ConfMap confSet) {
            return this.removeAll(confSet.asCollection());
        }

        public Builder removeAll(Collection<String> values) {
            for (String s : values) {
                this.vals.remove(s);
            }
            return this;
        }

        public ConfMap build() {
            return new ConfMap(this.vals);
        }
    }
}

