/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.conf;

import ebuild.core.conf.ConfExpr;
import ebuild.core.conf.ConfExprException;
import ebuild.core.conf.ConfMap;
import ebuild.core.conf.ConfMapping;
import ebuild.core.conf.Lexer;
import ebuild.core.conf.Token;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Stack;

public class Parser
extends Lexer {
    final Stack<Object> stack = new Stack();
    final String source;

    ConfExprException pe(String msg) {
        return new ConfExprException("[parsing error]" + msg + " at " + this.sourceName + ":" + this.parserLine);
    }

    public Parser(String source) {
        super(new StringReader(source));
        this.source = source;
    }

    public static ConfMapping parseConfMapping(String source) throws ConfExprException {
        try {
            return new Parser(source).expectMapping();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static ConfExpr parseConfExpr(String source) throws ConfExprException {
        try {
            if (source == null) {
                return ConfExpr.TRUE;
            }
            return new Parser(source).expectExpr(Token.END);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static ConfMap parseConfMap(String source) throws ConfExprException {
        try {
            if (source == null) {
                return ConfMap.EMPTY;
            }
            return new Parser(source).expectMap(Token.END);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private ConfMapping expectMapping() throws IOException, ConfExprException {
        LinkedList<ConfMapping.Item> items = new LinkedList<ConfMapping.Item>();
        items.add(this.expectMappingItem());
        while (this.peek() == Token.SEMI) {
            this.nextToken();
            items.add(this.expectMappingItem());
        }
        return new ConfMapping(items);
    }

    private ConfMapping.Item expectMappingItem() throws IOException, ConfExprException {
        ConfMap set;
        Token t = this.peek();
        if (this.isExprEnd(t) && t != Token.MAP) {
            throw new ConfExprException("Empty expression not allowed");
        }
        ConfExpr expr = this.expectExpr();
        if (this.peek() == Token.MAP) {
            this.nextToken();
            set = this.expectMap();
        } else {
            set = ConfMap.EMPTY;
        }
        return new ConfMapping.Item(expr, set);
    }

    private ConfExpr expectExpr(Token end) throws IOException, ConfExprException {
        ConfExpr r = this.expectExpr();
        this.expect(end, this.nextToken());
        return r;
    }

    private boolean isExprEnd(Token t) {
        switch (t) {
            case RP: 
            case MAP: 
            case END: {
                return true;
            }
        }
        return false;
    }

    private ConfExpr expectExpr() throws IOException, ConfExprException {
        if (this.isExprEnd(this.peek())) {
            return ConfExpr.TRUE;
        }
        return this.expectExpr(Parser.precedence(Token.LP));
    }

    private ConfExpr expectExpr(int minPrecedence) throws IOException, ConfExprException {
        ConfExpr r = this.startExpr(minPrecedence);
        ConfExpr r2;
        while (r != (r2 = this.continueExpr(minPrecedence, r))) {
            r = r2;
        }
        return r;
    }

    private ConfExpr startExpr(int minPrecedence) throws IOException, ConfExprException {
        Token t = this.nextToken();
        switch (t) {
            case BANG: {
                return new ConfExpr.Not(this.expectExpr(Parser.precedence(Token.BANG)));
            }
            case LP: {
                return this.expectExpr(Token.RP);
            }
            case ANY: {
                return ConfExpr.TRUE;
            }
            case NAME: {
                ConfExpr.Conf conf = new ConfExpr.Conf(this.string);
                return this.continueExpr(minPrecedence, conf);
            }
        }
        throw this.pe("Unexpected token: " + (Object)((Object)t));
    }

    private ConfExpr continueExpr(int minPrecedence, ConfExpr a) throws IOException, ConfExprException {
        Token t = this.peek();
        int nextPrecedence = Parser.precedence(t);
        if (minPrecedence <= nextPrecedence && Parser.isContinueExpr(t)) {
            this.nextToken();
            ConfExpr b = this.expectExpr(nextPrecedence);
            if (t == Token.OR) {
                return new ConfExpr.Or(a, b);
            }
            return new ConfExpr.And(a, b);
        }
        return a;
    }

    private ConfMap expectMap(Token end) throws IOException, ConfExprException {
        ConfMap r = this.expectMap();
        this.expectNext(Token.END);
        return r;
    }

    private void addConf(ConfMap.Builder b) throws IOException, ConfExprException {
        this.expectNext(Token.NAME);
        String key = this.string;
        String value = null;
        if (this.peek() == Token.EQ) {
            this.nextToken();
            this.expectNext(Token.NAME);
            value = this.string;
        }
        b.add(key, value);
    }

    private ConfMap expectMap() throws IOException, ConfExprException {
        ConfMap.Builder b = new ConfMap.Builder();
        Token t = this.peek();
        if (t == Token.NAME) {
            this.addConf(b);
        }
        while (this.peek() == Token.COMMA) {
            this.nextToken();
            this.addConf(b);
        }
        return b.build();
    }

    private void expectNext(Token actual) throws ConfExprException, IOException {
        this.expect(this.nextToken(), actual);
    }

    private void expect(Token expected, Token actual) throws ConfExprException {
        if (expected != actual) {
            throw this.pe("Expected " + (Object)((Object)expected) + ", got " + (Object)((Object)actual));
        }
    }

    static boolean isContinueExpr(Token t) {
        return t == Token.OR || t == Token.COMMA;
    }

    static int precedence(Token t) {
        switch (t) {
            case LP: {
                return 0;
            }
            case COMMA: {
                return 1;
            }
            case OR: {
                return 2;
            }
            case BANG: {
                return 3;
            }
        }
        return -1;
    }
}

