/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.base.EBuildException;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.Exclude;
import ebuild.util.ObjectUtil;

public class ConfKey {
    public static final ConfKey DEFAULT = new ConfKey(ConfMap.EMPTY);
    public final ConfMap conf;
    public final Exclude exclude;

    public ConfKey(String confs) throws EBuildException {
        this(EBuildUtil.parseConfMap(confs), Exclude.NONE);
    }

    public ConfKey(ConfMap conf) {
        this(conf, Exclude.NONE);
    }

    public ConfKey(ConfMap conf, Exclude exclude) {
        this.conf = conf;
        this.exclude = exclude;
        if (exclude == null) {
            throw new NullPointerException();
        }
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.conf) + ObjectUtil.hashOf(this.exclude);
    }

    public boolean equals(Object obj) {
        ConfKey b = (ConfKey)obj;
        return ObjectUtil.areEqual(this.conf, b.conf) && ObjectUtil.areEqual(this.exclude, b.exclude);
    }

    public String toString() {
        return this.conf + " " + this.exclude;
    }
}

