/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.common.IVersion;
import ebuild.util.ObjectUtil;
import ebuild.util.StringUtil;

public class Version
implements IVersion {
    public static final Version TRUNK_HEAD = Version.newRevision("head");
    private final String branch;
    private final String version;

    public static Version newTag(String version) {
        return new Version(null, version);
    }

    public static Version newRevision(String revision) {
        return Version.newRevision("trunk", revision);
    }

    public static Version newRevision(String branch, String revision) {
        if (StringUtil.isEmptyString(branch)) {
            branch = "trunk";
        }
        if (StringUtil.isEmptyString(revision)) {
            revision = "head";
        }
        return new Version(branch, revision);
    }

    private Version(String branch, String version) {
        this.branch = branch;
        this.version = version;
    }

    public Version withRevision(String revision) {
        String branch = this.branch;
        if (branch == null) {
            branch = "trunk";
        }
        return new Version(branch, revision);
    }

    public Version withTag(String tag) {
        return new Version(null, tag);
    }

    public boolean isTag() {
        return this.branch == null;
    }

    public boolean isWorking() {
        return "working".equals(this.version);
    }

    public boolean isHead() {
        return "head".equals(this.getRevision());
    }

    public boolean isMoving() {
        return this.isHead() || this.isWorking();
    }

    public boolean isTrunk() {
        return "trunk".equals(this.branch);
    }

    public String getBranch() {
        return this.branch;
    }

    public String getRevision() {
        return this.isTag() ? null : this.version;
    }

    public String getTag() {
        return this.isTag() ? this.version : null;
    }

    public String getTagSuper() {
        String t = this.getTag();
        int dash = t.indexOf(45);
        if (dash == -1) {
            return t;
        }
        return t.substring(0, dash);
    }

    public boolean hasTagSub() {
        return this.getTag().indexOf(45) != -1;
    }

    public Version withoutTagSub() {
        return this.withTag(this.getTagSuper());
    }

    public int hashCode() {
        return ObjectUtil.hashOf(this.branch) + ObjectUtil.hashOf(this.version);
    }

    public boolean equals(Object obj) {
        Version b = (Version)obj;
        return ObjectUtil.areEqual(this.branch, b.branch) && ObjectUtil.areEqual(this.version, b.version);
    }

    public static Version fromString(String s, Version v) {
        if (s == null) {
            return v;
        }
        return Version.fromString(s);
    }

    public static Version fromString(String s) {
        String revision = null;
        String branch = null;
        if (s.startsWith("branch_")) {
            int dash = (s = s.substring("branch_".length())).indexOf(45);
            branch = dash != -1 ? s.substring(0, dash) : s;
            s = s.substring(branch.length());
        }
        if (s.startsWith("rev_")) {
            revision = s = s.substring("rev_".length());
        } else if (s.equals("working")) {
            revision = s;
        }
        if (revision == null && branch == null) {
            return Version.newTag(s);
        }
        return Version.newRevision(branch, revision);
    }

    public String toString() {
        if (this.isTag()) {
            return this.version;
        }
        String r = this.isWorking() ? "working" : "rev_" + this.getRevision();
        if (!"trunk".equals(this.branch)) {
            r = "branch_" + this.branch + "-" + r;
        }
        return r;
    }
}

