/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.run;

import ebuild.api.core.IEBuildRunner;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.base.EBuildLogger;
import ebuild.base.PluginUtil;
import ebuild.base.ReportBuilder;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.ActionStatus;
import ebuild.core.BuildPlan;
import ebuild.core.BuildPlanRunner;
import ebuild.core.EBuild;
import ebuild.core.ElementC;
import ebuild.core.ModuleVersion;
import ebuild.core.impl.Task;
import ebuild.core.impl.TaskSet;
import ebuild.core.run.ReleaseRunner;
import ebuild.options.OptionsBuilder;
import ebuild.options.OptionsUtil;
import ebuild.util.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EBuildRunner
extends BuildPlanRunner
implements IEBuildRunner {
    private Map<String, AbstractRepositoryProvider> repoProviders = new LinkedHashMap<String, AbstractRepositoryProvider>(0);
    private EBuild ebuild;

    protected EBuildRunner() {
    }

    @Override
    protected EBuildLogger getLogger() {
        return this.getEBuild().logger;
    }

    @Override
    protected EBuild getEBuild() {
        if (this.ebuild == null) {
            throw new Error("Not initialised");
        }
        return this.ebuild;
    }

    @Override
    public abstract String getKey();

    @Override
    public abstract void go() throws Exception;

    @Override
    protected void log(String msg) {
        this.getLogger().log(msg);
    }

    @Override
    protected void loge(String msg) {
        String[] stringArray = msg.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.getLogger().log("!! " + s);
            ++n2;
        }
    }

    private static String versionCode() {
        if (ModuleVersion.TAG != null) {
            return ModuleVersion.TAG;
        }
        String r = "";
        if ("trunk" != null) {
            r = "trunk/";
        }
        return String.valueOf(r) + "411";
    }

    @Override
    public void go(ElementC cElement, Task task) throws Exception {
        this.go(this.ebuild.newBuildPlan(cElement), task);
    }

    @Override
    public void go(BuildPlan mainPlan, Task task) throws Exception {
        TaskSet tasks = new TaskSet(task);
        this.log("");
        this.log("");
        this.log("////////////////////////////////////");
        this.log("////// Resolve And Configure ///////");
        this.log("");
        this.resolveAndConfigure(mainPlan, tasks);
        this.log("");
        this.log("");
        this.log("////////////////////////////");
        this.log("////// Plan Task List //////");
        this.log("");
        this.buildActionList(mainPlan, tasks);
        this.log("");
        this.log("");
        this.log("//////////////////////////");
        this.log("////// Execute Plan //////");
        this.log("");
        this.run(this.ebuild.queue);
    }

    @Override
    protected void resolveAndConfigure(BuildPlan mainPlan, TaskSet tasks) throws EBuildException {
        mainPlan.resolveAndConfigure(tasks);
        if (this.ebuild.isDEBUG()) {
            this.log("");
            this.log("Build Plans");
            for (Object k : this.ebuild.buildPlans.keySet()) {
                this.log("  " + k);
            }
        }
    }

    private void buildActionList(BuildPlan mainPlan, TaskSet tasks) throws Exception {
        String key = this.getKey();
        Backtrace.startTop("plan actions", key);
        try {
            mainPlan.buildActionList(this.ebuild.queue, tasks);
        }
        finally {
            Backtrace.endTop(key);
        }
        this.ebuild.queue.removeDuplicates();
        for (Action a : this.ebuild.queue) {
            this.log("queued " + StringUtil.rpad(7, a.getStatus().displayString()) + " " + a.format());
        }
    }

    private void run(ActionQueue queue) throws Exception {
        for (Action action : queue) {
            if (action.getStatus() == ActionStatus.done && !this.ebuild.options.noSkipping) {
                this.log("- skipping  " + action + " -");
                this.getLogger().setProvisionalHeading("\n");
                action.finish(true);
                this.getLogger().setProvisionalHeading(null);
                continue;
            }
            this.log("- executing " + action + " -");
            this.getLogger().setProvisionalHeading("\n");
            action.run(this.getLogger());
            action.finish(false);
            this.getLogger().setProvisionalHeading(null);
        }
    }

    protected abstract EBuild.Options getOptions();

    protected abstract void readOptions(OptionsBuilder var1, String[] var2) throws Exception;

    protected abstract void formatOptionValues(OptionsBuilder var1);

    protected void init(EBuild ebuild) throws Exception {
        this.ebuild = ebuild;
        for (String repoType : this.repoProviders.keySet()) {
            ebuild.addProviderPlugin(repoType, this.repoProviders.get(repoType));
        }
    }

    public Callable<String> run(String[] args) throws Exception {
        EBuild.Options options = this.getOptions();
        if (OptionsUtil.isPrintOptions(args)) {
            System.err.println(OptionsUtil.formatOptions(ReleaseRunner.Options.class));
            return null;
        }
        System.err.println("Pass argument ? to print out options");
        OptionsBuilder<EBuild.Options> optionsBuilder = new OptionsBuilder<EBuild.Options>(options);
        this.readOptions(optionsBuilder, args);
        Callable<String> r = optionsBuilder.verify();
        if (r != null) {
            return r;
        }
        this.formatOptionValues(optionsBuilder);
        ClassLoader apiClassLoader = this.getClass().getClassLoader().getParent();
        this.init(new EBuild(apiClassLoader, options));
        return this.run();
    }

    public void addRepoProvider(String repoType, AbstractRepositoryProvider provider) {
        this.repoProviders.put(repoType, provider);
    }

    public Callable<String> run() throws Exception {
        if (this.getEBuild().isDEBUG()) {
            this.log("system classloader path: ");
            this.log(PluginUtil.displayClassloader(this.ebuild, ClassLoader.getSystemClassLoader()));
            this.log("core classloader path: ");
            this.log(PluginUtil.displayClassloader(this.ebuild, EBuildRunner.class.getClassLoader()));
        }
        ReportBuilder.Stream report = new ReportBuilder.Stream(this.getLogger().out);
        try {
            try {
                this.go();
            }
            finally {
                this.getLogger().printReportOfWarnings(report);
            }
            return null;
        }
        catch (Throwable e) {
            this.getLogger().log("");
            this.getLogger().printReportOfError(report, e, EBuildRunner.versionCode());
            Callable<String> callable = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    ReportBuilder.Memory report = new ReportBuilder.Memory();
                    EBuildRunner.this.getLogger().printReportOfError(report, e, EBuildRunner.versionCode());
                    return report.toString();
                }
            };
            return callable;
        }
        finally {
            this.getLogger().prime();
        }
    }
}

