/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.run;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.base.EBuildException;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.Element;
import ebuild.core.ElementC;
import ebuild.core.ElementRelease;
import ebuild.core.Module;
import ebuild.core.ModuleC;
import ebuild.core.ModuleDeps;
import ebuild.core.Product;
import ebuild.core.ProductC;
import ebuild.core.ProductRelease;
import ebuild.core.ReleaseBuildPlan;
import ebuild.core.RepositoryRef;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyC;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Select;
import ebuild.core.impl.Task;
import ebuild.core.impl.Version;
import ebuild.core.run.EBuildRunner;
import ebuild.options.DisplayOrder;
import ebuild.options.OptionsBuilder;
import ebuild.options.OptionsUtil;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.Logger;
import ebuild.util.StringUtil;
import ebuild.util.ZipUtil;
import ebuild.xml.CmnXml;
import ebuild.xml.OptXml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseRunner
extends EBuildRunner {
    private final Options options = new Options();
    private EBuildContext releaseContext;
    private List<Select> selected = new ArrayList<Select>();
    private Map<Select, ElementC> selectedElementCs;
    private OptXml.EBuildReleaseOptions fileOptions;
    private Map<String, RepositoryRef> projectRepos = new HashMap<String, RepositoryRef>();

    @Override
    protected EBuild.Options getOptions() {
        return this.options;
    }

    @Override
    protected void readOptions(OptionsBuilder optionsBuilder, String[] args) throws Exception {
        Options optionsObj = (Options)optionsBuilder.getOptionsObj();
        Map<String, String> optionsMap = OptionsUtil.read(args);
        optionsBuilder.merge(optionsMap);
        if (optionsObj.optionsFile != null) {
            this.fileOptions = OptXml.deserialize(optionsObj.optionsFile);
            optionsBuilder.merge(this.fileOptions.options);
        }
        if (!optionsObj.home.exists()) {
            optionsBuilder.addError("_ebuild directory does not exist: " + optionsObj.home);
        }
    }

    @Override
    protected void formatOptionValues(OptionsBuilder optionsBuilder) {
        final Options options = (Options)optionsBuilder.getOptionsObj();
        final Set<String> set = optionsBuilder.getSetOptions();
        System.err.println("////////////////////////////////////////////////////////////");
        System.err.println(OptionsUtil.formatOptionValues((Object)options, new CollectionUtil.Filter<String>(){

            @Override
            public boolean accept(String f) {
                Object v = OptionsUtil.getValue(options, f);
                if ("noSkipping".equals(f) || "verbose".equals(f) || "debug".equals(f)) {
                    return v == Boolean.TRUE;
                }
                if ("home".equals(f)) {
                    return options.debug;
                }
                return set.contains(f);
            }
        }));
        System.err.println("////////////////////////////////////////////////////////////");
        System.err.println("");
    }

    @Override
    protected void init(EBuild ebuild) throws Exception {
        super.init(ebuild);
        this.releaseContext = new EBuildContext(ebuild);
        this.releaseContext.addParents(ebuild.context);
        this.interpretFileOptions(this.fileOptions);
    }

    private void addRepos(List<CmnXml.Repository> repos) throws EBuildException {
        this.releaseContext.addNamedRepository("workspace", (IRepository)this.getEBuild().getWorkspaceWorkingCopy().getRepository(), null);
        for (CmnXml.Repository r : repos) {
            this.releaseContext.addRepository(r);
        }
    }

    private OptXml.Select getSelect(Options options) throws EBuildException {
        OptXml.Select r = new OptXml.Select();
        r.elementType = options.elementType;
        r.org = options.org;
        r.name = options.name;
        r.artifact = options.artifact;
        r.tag = options.tag;
        r.branch = options.branch;
        r.revision = options.revision;
        r.confs = options.confs;
        return r;
    }

    private void addKeys(List<OptXml.Select> selects, OptXml.Select prototype) throws EBuildException {
        if (selects.size() == 0) {
            Version version = EBuildUtil.asVersion(prototype, Version.TRUNK_HEAD);
            KeyE ekey = new KeyE(prototype.elementType, "project", prototype.org, prototype.name, version);
            KeyC cekey = new KeyC(ekey, new ConfKey(prototype.confs));
            this.selected.add(new Select(prototype.source, cekey, prototype.artifact));
        } else {
            for (OptXml.Select selDef : selects) {
                OptXml.Select prototype2 = prototype.clone(selDef);
                this.addKeys(selDef.subSelects, prototype2);
            }
        }
    }

    private void interpretFileOptions(OptXml.EBuildReleaseOptions fileOptions) throws EBuildException {
        List<OptXml.Select> selects = CollectionUtil.EMPTY_LIST;
        if (fileOptions != null) {
            this.addRepos(fileOptions.repositories);
            selects = fileOptions.selects;
        }
        this.addKeys(selects, this.getSelect(this.options));
        if (this.selected.size() == 0) {
            throw EBuildException.newBadRequest("No element selected - set org,name ... etc. or  <select/> in options file ");
        }
    }

    @Override
    public void go() throws Exception {
        this.releaseContext.addRepository(new RepositoryRef(this.releaseContext, "local"){

            protected IRepository locateRepository() throws EBuildException {
                return ReleaseRunner.this.useRepo(ReleaseRunner.this.getLogger(), ReleaseRunner.this.getEBuild().getWorkspaceWorkingCopy(), "_ebuild");
            }
        });
        this.selectedElementCs = new LinkedHashMap<Select, ElementC>(this.selected.size());
        for (Select select : this.selected) {
            this.selectedElementCs.put(select, this.resolveTop(select));
        }
        ReleaseBuildPlan plan = new ReleaseBuildPlan(this.getEBuild(), this.selectedElementCs.values());
        if (this.options.source) {
            this.go(plan, Task.fetch_source);
        } else {
            this.go(plan, Task.build_release);
        }
        if (this.options.source) {
            for (Select s : this.selected) {
                this.copySource(s.key.ekey);
            }
        } else {
            this.copyReleases();
        }
    }

    private Element resolveTop(String source, KeyE key) throws Exception {
        Version v;
        RepositoryRef repoRef = source == null ? this.guessInitialSourceRepository(key) : this.releaseContext.lookupRepository(source);
        if (StringUtil.isEmptyString(key.org) && repoRef != null) {
            key = key.withOrg(repoRef.expectDefaultOrg());
        }
        if ((v = key.version).isHead()) {
            AbstractSourceRepository srepo = repoRef.getContext().expectSourceRepo(key);
            String revision = this.getEBuild().getWorkspaceHeadRevision(srepo);
            this.log("");
            this.log("head -> " + revision);
            this.log("");
            v = Version.newRevision(v.getBranch(), revision);
            key = key.withVersion(v);
        }
        return this.getEBuild().resolveLibraryPart(repoRef, key);
    }

    private ElementC resolveTop(Select select) throws Exception {
        Element el = this.resolveTop(select.source, select.key.ekey);
        ConfKey subKey = select.key.subkey;
        return el.getCPart(subKey);
    }

    private IRepository useRepo(ILogger logger, AbstractWorkingCopy wc, String path) throws EBuildException {
        if (wc != null) {
            AbstractSourceRepository r = wc.getRepository();
            logger.log("... using location [workspace]/" + path + " to locate repository");
            logger.log("Repository: " + r);
            return r;
        }
        logger.log("[workspace]/" + path + " exists, but not linked to a repository");
        return null;
    }

    private RepositoryRef guessInitialSourceRepository(KeyE key) throws Exception {
        Logger logger = this.getLogger().newSubLogger("Guess initial repository");
        logger.log("No repository supplied, attempting to guess repository");
        logger.log("");
        Element ebd = this.getEBuild().resolveWorkspaceElement(key.withVersion(Version.newRevision("[any]", "working")));
        if (ebd != null) {
            IRepository r = this.useRepo(logger, ebd.getWorkingCopy(), ebd.javaFile().getName());
            String n = r.getUri();
            RepositoryRef ref = this.projectRepos.get(n);
            if (ref == null) {
                ref = this.releaseContext.addNamedRepository(n, r, null);
                this.projectRepos.put(n, ref);
            }
            return ref;
        }
        logger.log("... " + key + " not in workspace");
        return this.releaseContext.getRepository("local");
    }

    private String sourceReleaseName() {
        if (this.selected.size() != 1) {
            throw new Error("Multiple released elements for source release not supported");
        }
        Object p = this.selectedElementCs.get((Object)this.selected.get((int)0)).element;
        if (p instanceof Product) {
            return ((Product)p).releaseSourceFileName();
        }
        return ((Element)p).key.fullnameAndVersion();
    }

    void copySource(KeyE key) throws Exception {
        EBuild ebuild = this.getEBuild();
        String sourceReleaseName = this.sourceReleaseName();
        File releaseDir = new File(this.options.outputDirectory, this.sourceReleaseName());
        this.log("");
        this.log("Releasing to library: " + ebuild.formatAsDisplayPath(releaseDir));
        File library = new File(releaseDir, "_ebuild/library/ebuild");
        File seed = new File(releaseDir, "_ebuild/seed");
        library.mkdirs();
        seed.mkdirs();
        for (Element e : ebuild.getResolvedLibraryElements()) {
            Element p;
            if (!e.hasMetaDirectory()) continue;
            File releasePartDir = e.key.getSubDirectory(library);
            releasePartDir.mkdirs();
            File builtMeta = e.getMetaDirectory();
            FileUtil.copyToDir(builtMeta, releasePartDir);
            if (!(e instanceof Element) || !(p = e).isSource()) continue;
            File builtSource = p.getProjectDirectory();
            FileUtil.copyToDir(builtSource, releasePartDir);
        }
        FileUtil.copyToDir(ebuild.getFile("seed/version"), seed);
        FileUtil.copyToDir(ebuild.getFile("seed/build.xml"), seed);
        File archive = new File(this.options.outputDirectory, String.valueOf(sourceReleaseName) + "-source.zip");
        this.log("Archiving library as: " + ebuild.formatAsDisplayPath(archive));
        ZipUtil.zipDirectoryIncludeName(archive, releaseDir);
        FileUtil.deleteDir(releaseDir);
    }

    private void doCopy(File f, File toDir) throws IOException {
        this.log("  <-" + this.getEBuild().formatAsDisplayPath(f));
        FileUtil.copyToDir(f, toDir);
    }

    private void copyToReleaseLib(File releaseLib, ElementC builtElementC) throws IOException {
        Object builtPart = builtElementC.element;
        File builtMeta = new File(((Element)builtPart).getMetaDirectory(), EBuildUtil.elementType2xmlName(((Element)builtPart).getType()));
        File builtPlugin = new File(((Element)builtPart).getMetaDirectory(), "build-plugin.xml");
        File releasePartDir = ((Element)builtPart).key.getSubDirectory(releaseLib);
        File releaseReleaseDir = new File(releasePartDir, "release");
        File releaseMetaDir = new File(releasePartDir, "meta");
        releaseReleaseDir.mkdirs();
        releaseMetaDir.mkdirs();
        File[] fileArray = ((Element)builtPart).getReleaseDirectory().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            this.doCopy(f, releaseReleaseDir);
            ++n2;
        }
        this.doCopy(builtMeta, releaseMetaDir);
        if (builtPlugin.exists()) {
            this.doCopy(builtPlugin, releaseMetaDir);
        }
    }

    void copyReleases() throws Exception {
        File releaseDir;
        Object elementC;
        File releaseLib = this.options.outputLibrary;
        if (releaseLib != null) {
            this.log("");
            this.log("Releasing to library: " + this.getEBuild().formatAsDisplayPath(releaseLib));
            ModuleDeps.GathererOfReleases gatherer = new ModuleDeps.GathererOfReleases();
            gatherer.setContinueRule(new ModuleDeps.RecurseRule(){

                public boolean ignore(ModuleDeps.ModuleDep md) {
                    if (md.subsumed) {
                        return true;
                    }
                    return ModuleC.NOAPI.match(md.key);
                }
            });
            for (Select s : this.selected) {
                elementC = this.selectedElementCs.get(s);
                if (((ElementC)elementC).element instanceof Module) {
                    ModuleDeps deps = (ModuleDeps)((ElementC)elementC).getDependencies(Scope.MAIN);
                    deps.doDeepGather(gatherer, new ModuleDeps.RecurseRule(){

                        public boolean ignore(ModuleDeps.ModuleDep md) {
                            return md.subsumed;
                        }
                    });
                }
                Collection<ElementRelease> ers = ((ElementC)elementC).iterateReleases();
                for (ElementRelease elementRelease : ers) {
                    gatherer.releases.add(elementRelease);
                }
            }
            HashSet elementCs = new HashSet();
            for (ElementRelease elementRelease : gatherer.releases) {
                elementCs.add(elementRelease.cElement);
            }
            for (ElementC elementC2 : elementCs) {
                this.copyToReleaseLib(releaseLib, elementC2);
            }
        }
        if (!(releaseDir = this.options.outputDirectory).isAbsolute()) {
            releaseDir = new File(this.options.home, releaseDir.getPath());
        }
        if (releaseDir != null) {
            releaseDir.mkdirs();
            this.log("");
            this.log("Copying released components to " + this.getEBuild().formatAsDisplayPath(releaseDir));
            for (Select select : this.selected) {
                elementC = this.selectedElementCs.get(select);
                if (!(elementC instanceof ProductC)) continue;
                Collection<ElementRelease> prs = ((ElementC)elementC).iterateReleases();
                for (ProductRelease productRelease : prs) {
                    this.doCopy(productRelease.artifactFile, releaseDir);
                }
            }
        }
    }

    @Override
    public String getKey() {
        return "release";
    }

    @DisplayOrder(value={"org", "name", "branch", "revision", "tag", "confs", "", "output-library", "output-directory"})
    public static class Options
    extends EBuild.Options {
        public File optionsFile;
        public ElementType elementType;
        public String org;
        public String name;
        public String artifact;
        public String branch;
        public String revision;
        public String tag;
        public String confs;
        public boolean source;
        public File outputLibrary;
        public File outputDirectory;

        boolean hasTag() {
            return !StringUtil.isEmptyString(this.tag);
        }
    }
}

