/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.run;

import ebuild.base.Backtrace;
import ebuild.base.EBuildException;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.conf.ConfMap;
import ebuild.core.impl.ConfKey;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.KeyE;
import ebuild.core.impl.Task;
import ebuild.core.run.EBuildRunner;
import ebuild.options.DisplayOrder;
import ebuild.options.OptionsBuilder;
import ebuild.options.OptionsUtil;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import java.io.File;
import java.util.Map;
import java.util.Set;

public class WorkspaceRunner
extends EBuildRunner {
    private final Options options = new Options();

    protected EBuild.Options getOptions() {
        return this.options;
    }

    protected void readOptions(OptionsBuilder optionsBuilder, String[] args) {
        Options optionsObj = (Options)optionsBuilder.getOptionsObj();
        Map<String, String> optionsMap = OptionsUtil.read(args);
        optionsBuilder.merge(optionsMap);
        optionsBuilder.mergeDefault("workspaces", new File(optionsObj.projectDir, "..").getPath());
        optionsBuilder.mergeDefault("home", new File(optionsObj.projectDir, "../_ebuild").getPath());
        if (!optionsObj.home.exists()) {
            optionsBuilder.addError("_ebuild directory does not exist: " + optionsObj.home);
        }
    }

    protected void formatOptionValues(OptionsBuilder optionsBuilder) {
        final Options options = (Options)optionsBuilder.getOptionsObj();
        final Set<String> set = optionsBuilder.getSetOptions();
        System.err.println("////////////////////////////////////////////////////////////");
        System.err.println(OptionsUtil.formatOptionValues((Object)options, new CollectionUtil.Filter<String>(){

            @Override
            public boolean accept(String f) {
                Object v = OptionsUtil.getValue(options, f);
                if ("noSkipping".equals(f) || "verbose".equals(f) || "debug".equals(f)) {
                    return Boolean.TRUE.equals(v);
                }
                if ("home".equals(f)) {
                    return !"../_ebuild".equals(f) || options.debug;
                }
                return set.contains(f);
            }
        }));
        System.err.println("////////////////////////////////////////////////////////////");
        System.err.println("");
    }

    private Element resolveFirst(File projectDir) throws EBuildException {
        KeyE elementKey = KeyE.newWorkingKey(null, projectDir);
        Backtrace.startTop("resolve first", elementKey);
        try {
            Element r = this.getEBuild().resolveWorkspaceElement(elementKey);
            if (r == null) {
                throw EBuildException.newBadRequest("Not an ebuild project: " + projectDir);
            }
            Element element = r;
            return element;
        }
        finally {
            Backtrace.endTop(elementKey);
        }
    }

    public String getKey() {
        return "workspace";
    }

    public void go() throws Exception {
        Task task = this.options.task;
        Element element = this.resolveFirst(this.options.projectDir);
        ConfMap confSet = EBuildUtil.parseConfMap(this.options.confs);
        this.go(element.getCPart(new ConfKey(confSet)), task);
    }

    @DisplayOrder(value={"task", "confs", "projectDir", ""})
    public static class Options
    extends EBuild.Options {
        public Task task = Task.eclipse_setup;
        public String confs = "";
        public String artifact = null;
        public File projectDir = FileUtil.canonicalFile(new File("."));
    }
}

