/*
 * Decompiled with CFR 0.152.
 */
package ebuild.options;

import ebuild.options.DisplayOrder;
import ebuild.options.OptionsBuilder;
import ebuild.options.Required;
import ebuild.util.CollectionUtil;
import ebuild.util.SafeCallable;
import ebuild.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsUtil {
    public static boolean isPrintOptions(String[] args) {
        return args.length >= 1 && "?".equals(args[0]);
    }

    public static Object getValue(Object optionsObj, String fieldName) {
        Class<?> optionsClass = optionsObj.getClass();
        try {
            Field field = optionsClass.getField(fieldName);
            return field.get(optionsObj);
        }
        catch (NoSuchFieldException e) {
            throw new Error("No such field: " + fieldName);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static Object newDefault(Class optionsClass) {
        try {
            return optionsClass.newInstance();
        }
        catch (Exception e) {
            throw new Error("Could not instantiate options object", e);
        }
    }

    private static List<Field> displayOrder(Class optionsClass, CollectionUtil.Filter<String> filter) {
        DisplayOrder displayOrderAnnotation = optionsClass.getAnnotation(DisplayOrder.class);
        String[] displayOrder = new String[]{};
        if (displayOrderAnnotation != null) {
            displayOrder = displayOrderAnnotation.value();
        }
        Field[] fields = optionsClass.getFields();
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<Field> r = new ArrayList<Field>(displayOrder.length + fields.length);
        HashSet<Field> done = new HashSet<Field>(displayOrder.length);
        for (String fieldName : displayOrder) {
            if ("".equals(fieldName)) {
                r.add(null);
                continue;
            }
            if (!filter.accept(StringUtil.camelCaseFromDashed(fieldName))) continue;
            try {
                Field f = optionsClass.getField(fieldName);
                r.add(f);
                done.add(f);
            }
            catch (Exception e) {
                throw new Error("No such field '" + fieldName + "'", e);
            }
        }
        if (displayOrder.length > 0 && fields.length > 0) {
            r.add(null);
        }
        for (Field f : fields) {
            if (!filter.accept(f.getName()) || done.contains(f)) continue;
            r.add(f);
        }
        return r;
    }

    public static String formatOptions(Class optionsClass) {
        return OptionsUtil.formatOptions(optionsClass, CollectionUtil.ACCEPT_ALL);
    }

    public static String formatOptions(final Class optionsClass, final CollectionUtil.Filter<String> filter) {
        final Object optionsDefault = OptionsUtil.newDefault(optionsClass);
        final StringBuilder sb = new StringBuilder();
        sb.append("Available Options:-\n");
        return new SafeCallable<String>(){

            @Override
            public String run() {
                List displayOrder = OptionsUtil.displayOrder(optionsClass, filter);
                boolean seperate = false;
                for (Field f : displayOrder) {
                    if (f == null) {
                        seperate = true;
                        continue;
                    }
                    if (seperate) {
                        sb.append("\n");
                        seperate = false;
                    }
                    this.format(f);
                }
                return sb.toString();
            }

            public boolean format(Field f) {
                try {
                    Object default_ = f.get(optionsDefault);
                    if (!filter.accept(f.getName())) {
                        return false;
                    }
                    sb.append(StringUtil.lpad(20, StringUtil.camelCaseToDashed(f.getName())));
                    sb.append("=<" + f.getType().getSimpleName() + ">");
                    if (f.getAnnotation(Required.class) != null) {
                        sb.append("*");
                    } else if (!StringUtil.isEmptyString(default_)) {
                        sb.append("/" + default_);
                    }
                    sb.append("\n");
                    return true;
                }
                catch (Exception e) {
                    throw new Error("Unable to format option field '" + f.getName() + "'", e);
                }
            }
        }.run();
    }

    public static String formatOptionValues(Object optionsObj) {
        return OptionsUtil.formatOptionValues(optionsObj, CollectionUtil.ACCEPT_ALL);
    }

    public static String formatOptionValues(Object optionsObj, Set<String> set) {
        return OptionsUtil.formatOptionValues(optionsObj, OptionsUtil.newFilter(set));
    }

    public static String formatOptionValues(final Object optionsObj, final CollectionUtil.Filter<String> filter) {
        final Class<?> optionsClass = optionsObj.getClass();
        return new SafeCallable<String>(){
            StringBuilder sb = new StringBuilder();

            @Override
            public String run() {
                List displayOrder = OptionsUtil.displayOrder(optionsClass, filter);
                boolean seperate = false;
                for (Field f : displayOrder) {
                    if (f == null) {
                        seperate = true;
                        continue;
                    }
                    if (seperate) {
                        this.sb.append("////\n");
                        seperate = false;
                    }
                    this.format(f);
                }
                return this.sb.toString();
            }

            public void format(Field f) {
                try {
                    Object v = f.get(optionsObj);
                    this.sb.append("//// ");
                    this.sb.append(StringUtil.lpad(20, StringUtil.camelCaseToDashed(f.getName())));
                    this.sb.append(": ");
                    this.sb.append("" + v);
                    this.sb.append("\n");
                }
                catch (Exception e) {
                    throw new Error("Unable to format option field '" + f.getName() + "'", e);
                }
            }
        }.run();
    }

    public static Map<String, String> read(String[] args) {
        HashMap<String, String> options = new HashMap<String, String>(args.length);
        for (String s : args) {
            String[] ss = s.split("=", 2);
            String key = ss[0];
            String value = ss.length == 1 ? "true" : ss[1];
            options.put(key, value);
        }
        return options;
    }

    public static Map<String, String> readPropertyFile(File f) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(f));
        return properties;
    }

    public static List<String> interpret(Object optionsObj, String[] args) {
        Map<String, String> optionsMap = OptionsUtil.read(args);
        OptionsBuilder<Object> optionsBuilder = new OptionsBuilder<Object>(optionsObj);
        optionsBuilder.merge(optionsMap);
        return optionsBuilder.check();
    }

    private static CollectionUtil.Filter<String> newFilter(final Set<String> set) {
        return new CollectionUtil.Filter<String>(){

            @Override
            public boolean accept(String f) {
                return set.contains(f);
            }
        };
    }
}

