/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import ebuild.api.log.ILogger;
import ebuild.api.log.ISwitch;
import ebuild.util.ObjectUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Logger
implements ILogger,
Appendable {
    private static ISwitch ALWAYS_ON = new ISwitch(){

        public boolean isOn() {
            return true;
        }
    };
    protected static final PrintStream system_err = System.err;
    private static String SEPARATOR;
    static Logger current;
    final ISwitch onSwitch;
    final Logger parent;
    public final PrintStream out;
    final String name;
    final String indent;
    final String prefix;
    final Object identity;
    private String provisionalHeader;

    static {
        Logger.interceptStd();
        SEPARATOR = "------------------------------------------------------------------------------------------------------------------------";
    }

    private static PrintStream newInterceptStream(final char m) {
        return new PrintStream(new OutputStream(){
            private boolean nl = true;

            public void write(int b) throws IOException {
                if (this.nl) {
                    Logger.current.out.print(String.valueOf(Logger.current.indent) + m + " ");
                    this.nl = false;
                }
                if (10 == b) {
                    this.nl = true;
                }
                Logger.current.out.print((char)b);
            }
        });
    }

    private static void interceptStd() {
        System.setErr(Logger.newInterceptStream('!'));
        System.setOut(Logger.newInterceptStream('~'));
    }

    public static Logger newRootLogger() {
        return Logger.newRootLogger(system_err);
    }

    public static Logger newRootLogger(PrintStream out) {
        return new Logger(out);
    }

    protected Logger(PrintStream out) {
        this.onSwitch = ALWAYS_ON;
        this.parent = null;
        this.name = null;
        this.indent = "";
        this.prefix = " ";
        this.out = out;
        this.identity = this;
        current = this;
    }

    protected Logger(Logger parent, String name, ISwitch onSwitch, String indent, String prefix, Object identity) {
        this.onSwitch = onSwitch;
        this.parent = parent;
        this.name = name;
        this.out = parent.out;
        this.indent = indent;
        this.prefix = prefix;
        this.identity = identity == null ? this : identity;
    }

    public boolean isOn() {
        if (this.parent != null && !this.parent.isOn()) {
            return false;
        }
        return this.onSwitch.isOn();
    }

    private boolean isAncestorOf(Logger l) {
        if (l == null) {
            return false;
        }
        if (this.identity.equals(l.identity)) {
            return true;
        }
        return this.isAncestorOf(l.parent);
    }

    private boolean isSameIndentation(Logger l) {
        return this.identity.equals(l.identity);
    }

    private String padSeparator(String s) {
        return String.valueOf(s) + SEPARATOR.substring(Math.min(SEPARATOR.length(), s.length()));
    }

    public Logger newSubLogger(String name) {
        return this.newSubLogger(name, null);
    }

    public Logger newSubLogger(ISwitch onSwitch) {
        return this.newSubLogger(null, onSwitch);
    }

    public Logger newSubLogger(String name, ISwitch onSwitch) {
        return this.newSubLogger(name, onSwitch, "| ");
    }

    protected Logger newSubLoggerInstance(String name, ISwitch onSwitch, String indent2, String prefix2, Object identity2) {
        return new Logger(this, name, onSwitch, indent2, prefix2, identity2);
    }

    public Logger newSubLogger(String name, ISwitch onSwitch, String prefix2) {
        Object identity2;
        String indent2;
        if (onSwitch == null) {
            onSwitch = ALWAYS_ON;
        }
        if (name == null) {
            indent2 = this.indent;
            identity2 = this.identity;
        } else {
            indent2 = "";
            Logger p = this;
            while (p != null) {
                indent2 = String.valueOf(indent2) + "    ";
                p = p.parent;
            }
            identity2 = null;
        }
        prefix2 = String.valueOf(indent2) + prefix2;
        return this.newSubLoggerInstance(name, onSwitch, indent2, prefix2, identity2);
    }

    public void prime() {
        if (!this.isSameIndentation(current)) {
            if (this.isAncestorOf(current)) {
                this.out.println(this.padSeparator(this.indent));
            } else {
                if (this.parent != null && this.parent != current && this.parent != Logger.current.parent) {
                    this.parent.log("");
                }
                int insetLength = this.indent.length() - Logger.current.indent.length();
                String inset = SEPARATOR.substring(0, Math.max(0, insetLength));
                this.out.println(this.padSeparator(String.valueOf(Logger.current.indent) + inset + "-------- " + this.name + " "));
            }
            current = this;
        }
    }

    private void doLog(String msg) {
        if (msg == null) {
            this.out.print(this.prefix);
            this.out.println("*null*");
        } else {
            String[] lines;
            String[] stringArray = lines = msg.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                this.out.print(this.prefix);
                this.out.println(l);
                ++n2;
            }
        }
    }

    protected void doLogWarning(Warning w) {
        this.prime();
        this.printProvisionalHeading();
        this.doLog("[WARNING] " + w.message);
        if (w.throwable != null) {
            this.log(w.throwable);
        }
    }

    public void warn(String msg, Exception e) {
        this.doLogWarning(new Warning(msg, e));
    }

    public void warn(String msg) {
        this.doLogWarning(new Warning(msg, null));
    }

    public void log(String msg) {
        if (this.isOn()) {
            this.prime();
            this.printProvisionalHeading();
            this.doLog(msg);
        }
    }

    public void log(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.log(sw.toString());
    }

    public void logPartial(String msg) {
        if (this.isOn()) {
            this.printProvisionalHeading();
            this.out.print(msg);
            this.out.flush();
        }
    }

    private String getProvisionalHeading() {
        String r = null;
        if (this.parent != null) {
            r = this.parent.getProvisionalHeading();
        }
        if (r == null) {
            r = this.provisionalHeader;
        }
        return r;
    }

    private void printProvisionalHeading() {
        String h;
        while ((h = this.getProvisionalHeading()) != null) {
            this.doLog(h);
            this.unsetProvisionalHeading(h);
        }
    }

    public void setProvisionalHeading(String provisionalHeader) {
        this.provisionalHeader = provisionalHeader;
    }

    private void unsetProvisionalHeading(String provisionalHeader) {
        if (this.provisionalHeader == provisionalHeader) {
            this.provisionalHeader = null;
        }
        if (this.parent != null) {
            this.parent.unsetProvisionalHeading(provisionalHeader);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Logger b = (Logger)obj;
        if (!ObjectUtil.areEqual(this.parent, b.parent)) {
            return false;
        }
        return ObjectUtil.areEqual(this.name, b.name);
    }

    public Appendable append(CharSequence csq) {
        return this.append(csq, 0, csq.length());
    }

    public Appendable append(CharSequence csq, int start, int end) {
        if (this.isOn()) {
            this.printProvisionalHeading();
            this.out.append(csq, start, end);
            this.out.flush();
        }
        return this;
    }

    public Appendable append(char c) {
        if (this.isOn()) {
            this.printProvisionalHeading();
            this.out.append(c);
            this.out.flush();
        }
        return this;
    }

    public static class Warning {
        public final String message;
        public final Throwable throwable;

        Warning(String message, Throwable throwable) {
            this.message = message;
            this.throwable = throwable;
        }
    }
}

