/*
 * Decompiled with CFR 0.152.
 */
package ebuild;

import ebuild.api.common.ElementType;
import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.api.repo.IRepository;
import ebuild.core.CPart;
import ebuild.core.Component;
import ebuild.core.ComponentRelease;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildException;
import ebuild.core.EBuildRunner;
import ebuild.core.EBuildUtil;
import ebuild.core.EKey;
import ebuild.core.Element;
import ebuild.core.GeneralOptions;
import ebuild.core.Part;
import ebuild.core.Release;
import ebuild.core.RepositoryContext;
import ebuild.core.RepositoryRef;
import ebuild.core.Task;
import ebuild.core.Version;
import ebuild.options.DisplayOrder;
import ebuild.options.OptionsUtil;
import ebuild.options.Required;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.Logger;
import ebuild.util.StringUtil;
import java.io.File;
import java.util.List;

public class DoRelease
extends EBuildRunner {
    final Options options;

    public static void main(String[] args) throws Exception {
        if (OptionsUtil.isPrintOptions(args)) {
            System.err.println(OptionsUtil.formatOptions(Options.class));
        } else {
            System.err.println("Pass argument ? to print out options");
            Options options = new Options();
            List<String> errors = OptionsUtil.interpret(options, args);
            if (!options.home.exists()) {
                errors.add("_ebuild directory does not exist: " + options.home);
            }
            if (errors.size() > 0) {
                for (String e : errors) {
                    System.err.println(e);
                }
                System.exit(1);
            }
            new DoRelease(options).run();
        }
    }

    public DoRelease(Options options) {
        super(options);
        this.options = options;
    }

    private EKey getFirstKey() throws EBuildException {
        if (this.options.hasVersion()) {
            return EKey.newVersioned(this.options.elementType, null, this.options.org, this.options.name, this.options.version);
        }
        return EKey.newRevision(this.options.elementType, null, this.options.org, this.options.name, this.options.branch, this.options.revision);
    }

    public void go() throws Exception {
        this.log("////////////////////////////////////////////////////////////");
        this.log(OptionsUtil.formatOptionValues(this.options, new CollectionUtil.Filter<String>(){

            @Override
            public boolean accept(String f) {
                Options default_ = new Options();
                Object v = OptionsUtil.getValue(DoRelease.this.options, f);
                if ("branch".equals(f) || "revision".equals(f)) {
                    return StringUtil.isEmptyString(DoRelease.this.options.version);
                }
                if ("repositoryType".equals(f)) {
                    return !StringUtil.isEmptyString(DoRelease.this.options.repositoryUrl);
                }
                if ("noSkipping".equals(f) || "verbose".equals(f) || "debug".equals(f)) {
                    return v == Boolean.TRUE;
                }
                if ("home".equals(f)) {
                    return DoRelease.this.options.debug;
                }
                if ("outputDirectory".equals(f)) {
                    return DoRelease.this.options.outputDirectory.equals(default_.outputDirectory);
                }
                return !StringUtil.isEmptyString(v);
            }
        }));
        this.log("////////////////////////////////////////////////////////////");
        this.log("");
        EKey key = this.getFirstKey();
        Part part = this.resolveFirst(key);
        if (this.options.source) {
            this.go(part, this.options.confs, Task.fetch_source);
            this.copySource(part.key);
        } else {
            this.go(part, this.options.confs, Task.build_release);
            this.copyRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Part resolveFirst(EKey key) throws Exception {
        EBuildContext.start(this.ebuild.context);
        try {
            RepositoryRef repoRef;
            if (StringUtil.isEmptyString(key.org) && (repoRef = this.ebuild.context.lookupRepository("local")) != null) {
                key = key.withOrg(repoRef.getDefaultOrg());
            }
            RepositoryContext repoContext = new RepositoryContext(this.locateInitialSourceRepository(key));
            Version v = key.version;
            if (v.isHead()) {
                AbstractSourceRepository repo = repoContext.expectSourceRepo(key);
                String revision = EBuildUtil.getHeadRevision(repo);
                this.logger.log("");
                this.logger.log("head -> " + revision);
                this.logger.log("");
                v = Version.newRevision(v.getBranch(), revision);
                key = key.withVersion(v);
            }
            Part part = (Part)this.ebuild.resolveLibraryPart(repoContext, key);
            return part;
        }
        finally {
            EBuildContext.end();
        }
    }

    private IRepository useRepo(ILogger logger, File workspace, String path) throws EBuildException {
        AbstractWorkingCopy rc = this.ebuild.inferWorkingCopy(new File(workspace, path));
        if (rc != null) {
            AbstractSourceRepository r = rc.getRepository();
            logger.log("... using location [workspace]/" + path + " to locate repository");
            logger.log("Repository: " + r);
            return r;
        }
        logger.log("[workspace]/" + path + " exists, but not linked to a repository");
        return null;
    }

    private IRepository locateInitialSourceRepository(EKey key) throws Exception {
        if (this.options.repositoryUrl != null) {
            return this.ebuild.getRepository(this.options.repositoryType, this.options.repositoryUrl);
        }
        Logger logger = this.ebuild.logger.newSubLogger("Guess initial repository");
        logger.log("No repository supplied, attempting to guess repository");
        logger.log("");
        Element ebd = this.ebuild.resolveWorkspaceElement(key);
        if (ebd != null) {
            IRepository r = this.useRepo(logger, this.ebuild.workspaceDir, ebd.javaFile().getName());
            if (r != null) {
                return r;
            }
        } else {
            logger.log("... " + key + " not in workspace");
        }
        return this.useRepo(logger, this.ebuild.workspaceDir, "_ebuild/seed");
    }

    private String sourceReleaseName() {
        Object p = this.principalRelease.part;
        if (p instanceof Component) {
            return ((Component)p).releaseSourceFileName();
        }
        return ((Part)p).key.fullnameAndVersion();
    }

    void copySource(EKey key) throws Exception {
        String sourceReleaseName = this.sourceReleaseName();
        File releaseDir = new File(this.options.outputDirectory, this.sourceReleaseName());
        this.log("");
        this.log("Releasing to library: " + this.ebuild.formatAsDisplayPath(releaseDir));
        File library = new File(releaseDir, "_ebuild/library/ebuild");
        File seed = new File(releaseDir, "_ebuild/seed");
        library.mkdirs();
        seed.mkdirs();
        for (Element e : this.ebuild.getResolvedLibraryElements()) {
            Part p;
            if (!e.hasMetaDirectory()) continue;
            File releasePartDir = e.key.getSubDirectory(library);
            releasePartDir.mkdirs();
            File builtMeta = e.getMetaDirectory();
            FileUtil.copyToDir(builtMeta, releasePartDir);
            if (!(e instanceof Part) || !(p = (Part)e).isSource()) continue;
            File builtSource = p.getProjectDirectory();
            FileUtil.copyToDir(builtSource, releasePartDir);
        }
        FileUtil.copyToDir(new File(this.ebuild.javaFile(), "seed/version"), seed);
        FileUtil.copyToDir(new File(this.ebuild.javaFile(), "seed/build.xml"), seed);
        File archive = new File(this.options.outputDirectory, sourceReleaseName + "-source.zip");
        this.log("Archiving library as: " + this.ebuild.formatAsDisplayPath(archive));
        FileUtil.zipDirectoryIncludeName(archive, releaseDir);
        FileUtil.deleteDir(releaseDir);
    }

    void copyRelease() throws Exception {
        File releaseDir;
        File releaseLib = this.options.outputLibrary;
        if (releaseLib != null) {
            this.log("");
            this.log("Releasing to library: " + this.ebuild.formatAsDisplayPath(releaseLib));
            for (CPart cpart : this.releases) {
                Object builtPart = cpart.part;
                Release builtRelease = cpart.release;
                File builtMeta = new File(((Element)builtPart).getMetaDirectory(), EBuildUtil.elementType2xmlName(((Element)builtPart).getType()));
                File builtPlugin = new File(((Element)builtPart).getMetaDirectory(), "build-plugin.xml");
                File releasePartDir = ((Part)builtPart).key.getSubDirectory(releaseLib);
                File releaseReleaseDir = new File(releasePartDir, "release");
                File releaseMetaDir = new File(releasePartDir, "meta");
                releaseReleaseDir.mkdirs();
                releaseMetaDir.mkdirs();
                FileUtil.copyToDir(builtRelease.getFile(), releaseReleaseDir);
                FileUtil.copyToDir(builtMeta, releaseMetaDir);
                if (!builtPlugin.exists()) continue;
                FileUtil.copyToDir(builtPlugin, releaseMetaDir);
            }
        }
        if (this.principalRelease.part instanceof Component && (releaseDir = this.options.outputDirectory) != null) {
            releaseDir.mkdirs();
            ComponentRelease release = (ComponentRelease)this.principalRelease.release;
            this.log("");
            this.log("Copying released component");
            this.log("    " + this.ebuild.formatAsDisplayPath(release.getFile()));
            this.log("  ->" + this.ebuild.formatAsDisplayPath(releaseDir));
            FileUtil.copyToDir(release.getFile(), releaseDir);
        }
    }

    @DisplayOrder(value={"org", "name", "branch", "revision", "version", "confs", "", "repositoryUrl", "repositoryType", "", "outputLibrary", "outputDirectory"})
    public static class Options
    extends GeneralOptions {
        public ElementType elementType = null;
        @Required
        public String org = null;
        @Required
        public String name = null;
        public String branch = "trunk";
        public String revision = "head";
        public String version = "";
        public String confs = "";
        public boolean source = false;
        public File outputLibrary = null;
        public File outputDirectory = new File("releases");
        public String repositoryUrl = null;
        public String repositoryType = "svn";

        boolean hasVersion() {
            return !StringUtil.isEmptyString(this.version);
        }
    }
}

