/*
 * Decompiled with CFR 0.152.
 */
package ebuild;

import ebuild.core.EBuildContext;
import ebuild.core.EBuildException;
import ebuild.core.EBuildRunner;
import ebuild.core.EKey;
import ebuild.core.Element;
import ebuild.core.GeneralOptions;
import ebuild.core.Part;
import ebuild.core.Task;
import ebuild.options.DisplayOrder;
import ebuild.options.OptionsUtil;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.StringUtil;
import java.io.File;
import java.util.List;

public class DoWorkspace
extends EBuildRunner {
    final Options options;

    public static void main(String[] args) throws Exception {
        if (OptionsUtil.isPrintOptions(args)) {
            System.err.println(OptionsUtil.formatOptions(Options.class));
        } else {
            System.err.println("Pass argument ? to print out options");
            Options options = new Options();
            List<String> errors = OptionsUtil.interpret(options, args);
            if (!options.home.exists()) {
                errors.add("_ebuild directory does not exist: " + options.home);
            }
            if (errors.size() > 0) {
                for (String e : errors) {
                    System.err.println(e);
                }
                System.exit(1);
            }
            new DoWorkspace(options).run();
        }
    }

    public DoWorkspace(Options options) {
        super(options);
        this.options = options;
    }

    public void go() throws Exception {
        this.log("////////////////////////////////////////////////////////////");
        this.log(OptionsUtil.formatOptionValues(this.options, new CollectionUtil.Filter<String>(){

            @Override
            public boolean accept(String f) {
                Object v = OptionsUtil.getValue(DoWorkspace.this.options, f);
                if ("noSkipping".equals(f) || "verbose".equals(f) || "debug".equals(f)) {
                    return v == Boolean.TRUE;
                }
                if ("home".equals(f)) {
                    return DoWorkspace.this.options.debug;
                }
                return !StringUtil.isEmptyString(v);
            }
        }));
        this.log("////////////////////////////////////////////////////////////");
        this.log("");
        File projectDir = FileUtil.canonicalFile(new File(this.ebuild.workspaceDir, this.options.project));
        Part part = this.resolveFirst(projectDir);
        this.go(part, this.options.confs, this.options.task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Part resolveFirst(File projectDir) throws EBuildException {
        EBuildContext.start(this.ebuild.context);
        try {
            EKey partKey = EKey.newWorkingKey(null, projectDir);
            Element r = this.ebuild.resolveWorkspaceElement(partKey);
            if (r == null) {
                this.log("Not an ebuild project.");
                System.exit(1);
            } else if (!(r instanceof Part)) {
                this.log("Cannot directly build " + (Object)((Object)r.getType()));
                System.exit(1);
            }
            Part part = (Part)r;
            return part;
        }
        finally {
            EBuildContext.end();
        }
    }

    @DisplayOrder(value={"task", "confs", "project", ""})
    public static class Options
    extends GeneralOptions {
        static String[] _formatOrder = new String[]{"task", "confs", "project", ""};
        public Task task = Task.eclipse_setup;
        public String confs = "";
        public String project = FileUtil.canonicalFile(new File(".")).getName();
    }
}

