/*
 * Decompiled with CFR 0.152.
 */
package ebuild.conf;

import ebuild.conf.ConfSet;
import ebuild.util.CollectionUtil;
import ebuild.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfMapping {
    public static final ConfMapping EMPTY = new ConfMapping(CollectionUtil.EMPTY_SET);
    public final Collection<Expr> exprs;

    ConfMapping(Collection<Expr> exprs) {
        this.exprs = exprs;
    }

    public ConfSet select(ConfSet from) {
        ConfSet.Builder r = new ConfSet.Builder();
        for (Expr e : this.exprs) {
            e.select(from, r);
        }
        return r.build();
    }

    public String toString() {
        ArrayList<String> r = new ArrayList<String>(this.exprs.size());
        for (Expr e : this.exprs) {
            r.add(e.toString());
        }
        Collections.sort(r);
        return StringUtil.join(";", r);
    }

    public static class Expr {
        public final ConfSet from;
        public final ConfSet to;

        public Expr(ConfSet from, ConfSet to) {
            this.from = from;
            this.to = to;
        }

        public void select(ConfSet input, ConfSet.Builder r) {
            for (String f : this.from.values()) {
                if (input.has(f)) continue;
                return;
            }
            r.addAll(this.to.values());
        }

        public String toString() {
            return this.from.toString() + "->" + this.to.toString();
        }
    }
}

