/*
 * Decompiled with CFR 0.152.
 */
package ebuild.conf;

import ebuild.conf.ConfMapping;
import ebuild.conf.ConfSet;
import ebuild.conf.MappingException;
import java.util.HashSet;

public abstract class ConfParser {
    public static ConfMapping parseMapping(String mapping) throws MappingException {
        String[] exprStrs = mapping.split(";");
        HashSet<ConfMapping.Expr> exprs = new HashSet<ConfMapping.Expr>();
        for (String e : exprStrs) {
            exprs.add(ConfParser.parseExpr(e));
        }
        return new ConfMapping(exprs);
    }

    private static ConfMapping.Expr parseExpr(String e) throws MappingException {
        String[] ee = e.split("->", 2);
        if (ee.length < 2) {
            throw new MappingException("Invalid mapping expression, no '->': " + e);
        }
        String from = ee[0];
        String to = ee[1];
        return new ConfMapping.Expr(ConfParser.parseConfSet(from), ConfParser.parseConfSet(to));
    }

    public static ConfSet parseConfSet(String target) throws MappingException {
        String[] selectionList;
        if (target == null || "".equals(target.trim())) {
            return ConfSet.EMPTY;
        }
        ConfSet.Builder r = new ConfSet.Builder();
        for (String s : selectionList = target.split(",")) {
            r.add(ConfParser.parseConf(s));
        }
        return r.build();
    }

    private static String parseConf(String s) throws MappingException {
        return s.trim();
    }
}

