/*
 * Decompiled with CFR 0.152.
 */
package ebuild.conf;

import ebuild.api.common.IConfiguration;
import ebuild.util.CollectionUtil;
import ebuild.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfSet
implements IConfiguration {
    public static final ConfSet EMPTY = new ConfSet(CollectionUtil.EMPTY_SET);
    private final SortedSet<String> vals;

    public ConfSet(Set<String> vals) {
        this((SortedSet<String>)new TreeSet<String>(vals));
    }

    public ConfSet(SortedSet<String> vals) {
        this.vals = vals;
    }

    public Collection<String> values() {
        return this.vals;
    }

    public boolean has(String f) {
        return this.vals.contains(f);
    }

    public Collection<String> toStringCollection() {
        ArrayList<String> l = new ArrayList<String>(this.vals.size());
        for (String s : this.vals) {
            l.add(s);
        }
        return l;
    }

    public boolean isEmpty() {
        return this.vals.size() == 0;
    }

    public boolean includes(String conf) {
        return this.vals.contains(conf);
    }

    public boolean includesAll(ConfSet cs) {
        return this.vals.containsAll(cs.vals);
    }

    public String toString() {
        return StringUtil.join(",", this.vals.toArray());
    }

    public int hashCode() {
        return this.vals.hashCode();
    }

    public boolean equals(Object obj) {
        ConfSet b = (ConfSet)obj;
        return this.vals.equals(b.vals);
    }

    @Override
    public Collection<String> asCollection() {
        return this.vals;
    }

    @Override
    public String asDirectoryName() {
        if (this.vals.size() == 0) {
            return "_default";
        }
        return StringUtil.join("-", this.vals.toArray());
    }

    public String asFileTrailingPart(Collection<String> ignore) {
        TreeSet<String> vs = new TreeSet<String>(this.vals);
        vs.removeAll(ignore);
        if (vs.size() == 0) {
            return "";
        }
        return StringUtil.join("-", vs.toArray());
    }

    public String asJson() {
        return JSONValue.toJSONString(new ArrayList<String>(this.vals));
    }

    public static ConfSet fromJson(String json) throws IOException {
        try {
            List vals = (List)JSONValue.parseWithException(json);
            TreeSet<String> vs = new TreeSet<String>();
            for (String s : vs) {
                vals.add(s);
            }
            return new ConfSet((SortedSet<String>)vs);
        }
        catch (ParseException e) {
            throw new IOException("Could not parse JSON: " + e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private Set<String> vals = new HashSet<String>();

        public Builder add(String v) {
            this.vals.add(v);
            return this;
        }

        public void addAll(Iterable<String> ss) {
            for (String s : ss) {
                this.add(s);
            }
        }

        public Builder addAll(Collection<String> values) {
            this.vals.addAll(values);
            return this;
        }

        public void addAll(ConfSet confs) {
            this.vals.addAll(confs.vals);
        }

        public ConfSet build() {
            Set<String> vals = this.vals;
            this.vals = null;
            return new ConfSet(vals);
        }
    }
}

