/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.repo.IRepository;
import ebuild.conf.ConfSet;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.ActionStatus;
import ebuild.core.BuildProject;
import ebuild.core.CDependencies;
import ebuild.core.CEKey;
import ebuild.core.CPart;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildDirectory;
import ebuild.core.EBuildException;
import ebuild.core.EBuildRunner;
import ebuild.core.EBuildUtil;
import ebuild.core.EKey;
import ebuild.core.EclipseProject;
import ebuild.core.Element;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.Part;
import ebuild.core.ProjectHelper;
import ebuild.core.Task;
import ebuild.util.WorkMarker;
import ebuild.xml.Xml;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class BuildPlan {
    final EBuild ebuild;
    final EBuildRunner runner;
    final ILogger logger;
    final Object key;
    protected final Set<Object> builderPlans = new LinkedHashSet<Object>();
    private Set<String> resolved = new HashSet<String>();

    public BuildPlan(EBuildRunner runner, ILogger logger, Object key) {
        this.ebuild = runner.ebuild;
        this.runner = runner;
        this.logger = logger;
        this.key = key;
        runner.buildPlans.put(this.getKey(), this);
    }

    public Object getKey() {
        return this.key;
    }

    public abstract CPart expectLoneCPart() throws EBuildException;

    protected abstract void resolveBuilders(Scope var1) throws EBuildException;

    protected abstract void resolveAndConfigure_(Scope var1, Scope var2) throws EBuildException;

    protected abstract void buildActionList_(ActionQueue var1, Task var2) throws Exception;

    public void resolveAndConfigure(Scope scope, Scope builderScope) throws EBuildException {
        this.logger.setProvisionalHeading("\n--- Subject ---");
        this.logger.log(this.getKey() + " " + scope);
        this.resolveAndConfigure_(scope, builderScope);
        this.logger.setProvisionalHeading("\n--- Resolve Builders ---");
        this.resolveBuilders(scope);
        this.logger.setProvisionalHeading(null);
        for (Object subKey : this.builderPlans) {
            ModuleBuildPlan subPlan = (ModuleBuildPlan)this.runner.buildPlans.get(subKey);
            subPlan.resolveAndConfigure(builderScope, builderScope);
        }
    }

    public void buildActionList(ActionQueue queue, Task task) throws Exception {
        for (Object subKey : this.builderPlans) {
            BuildPlan subPlan = this.runner.buildPlans.get(subKey);
            subPlan.buildActionList(queue, task);
            if (task != Task.eclipse_setup || !(this instanceof ModuleBuildPlan)) continue;
            subPlan.buildActionList(queue, Task.build_release);
        }
        this.buildActionList_(queue, task);
    }

    protected void buildActionListForPart(ActionQueue queue, Task task, CPart cpart) throws Exception {
        Object part = cpart.getPart();
        if (!((EBuildDirectory)part).isWorkspace()) {
            if (((Part)part).isSource()) {
                WorkMarker marker = new WorkMarker(((Part)part).getProjectDirectory());
                Action.FetchSource action = new Action.FetchSource(marker, (Part)part);
                queue.add(action);
            } else {
                String confDir = cpart.configuration.asDirectoryName();
                WorkMarker marker = new WorkMarker(new File(((Part)part).getReleaseDirectory(), confDir));
                queue.add(new Action.FetchArtifacts(marker, cpart));
            }
            if (task.isIDE()) {
                throw new Error("Tried to do IDE task on a library part");
            }
            if (task == Task.fetch_source) {
                return;
            }
        }
        switch (task) {
            case build_release: {
                if (!((Part)part).isSource()) break;
                BuildProject bproject = cpart.createBuildProject();
                ActionStatus status = bproject.isDirty() ? ActionStatus.dirty : (bproject.isClean() ? ActionStatus.todo : ActionStatus.done);
                queue.add(new Action.BuildRelease(status, cpart, this.runner));
                break;
            }
            case build_clean: {
                if (!((Part)part).isSource()) break;
                ActionStatus status = ((Part)part).buildIsClean() ? ActionStatus.done : ActionStatus.todo;
                queue.add(new Action.BuildClean(status, cpart));
                break;
            }
            case eclipse_setup: {
                if (!((EBuildDirectory)part).isWorkspace()) break;
                EclipseProject eproject = cpart.createEclipseProject();
                ActionStatus status = eproject.isProjectDirty() ? ActionStatus.dirty : ActionStatus.todo;
                queue.add(new Action.EclipseSetup(status, cpart));
                break;
            }
            case eclipse_unsetup: {
                cpart.createEclipseProject();
                ActionStatus status = ActionStatus.todo;
                queue.add(new Action.EclipseUnsetup(status, cpart));
            }
        }
    }

    private String resolutionMessage(EKey k1, EKey k2) {
        if (k1.version.equals(k2.version)) {
            return k1 + "";
        }
        return k1 + " -> " + k2.version;
    }

    protected Element resolveElement(EBuildContext from, String source, EKey dkey) throws EBuildException {
        Element r = from.resolveElement(source, dkey);
        String msg = this.resolutionMessage(dkey, r.key);
        if (!this.resolved.contains(msg)) {
            this.resolved.add(msg);
            this.logger.log(msg);
        }
        return r;
    }

    private Module resolveModule(EBuildContext from, Xml.Select d) throws EBuildException {
        EKey dkey = from.newElementKey(ElementType.module, d);
        return (Module)this.resolveElement(from, d.source, dkey);
    }

    protected void resolveContext(Element element) throws EBuildException {
        this.resolveContext(element.context, (Xml.EBuildRoot)element.getDeclaration());
    }

    protected void resolveContext(ProjectHelper phelper) throws EBuildException {
        this.resolveContext(phelper.context, phelper.getBuildXml());
    }

    protected void resolveContext(EBuildContext context, Xml.EBuildRoot xml) throws EBuildException {
        for (Xml.Repository repoXml : xml.repositories) {
            IRepository repo = this.ebuild.getRepository(repoXml);
            context.addRepository(repoXml.name, repo, repoXml.org);
        }
        ArrayList<EBuildContext> add = new ArrayList<EBuildContext>(Math.min(1, xml.usings.size()));
        for (Xml.Select d : xml.usings) {
            Module dpart = this.resolveModule(context, d);
            this.resolveContext(dpart);
            add.add(dpart.context);
        }
        if (add.size() == 0) {
            add.add(this.ebuild.context);
        }
        context.init(add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveBuildersForPart(CPart cpart, ConfSet conf) throws EBuildException {
        Object part = cpart.part;
        if (!((Part)part).isSource()) {
            return;
        }
        ProjectHelper phelper = ((Part)part).getProjectHelper();
        EBuildContext.start(phelper.context);
        try {
            this.resolveContext(phelper);
            CDependencies deps = cpart.getDependencies();
            Iterable<Xml.Select> ds = phelper.getBuildDependencies(conf);
            for (Xml.Select d : ds) {
                EKey bekey = phelper.context.newModuleKey(d);
                CEKey bcekey = new CEKey(bekey, ConfSet.EMPTY);
                ModuleBuildPlan subPlan = (ModuleBuildPlan)this.runner.buildPlans.get(bcekey);
                if (subPlan == null) {
                    Module bpart = (Module)this.resolveElement(phelper.context, d.source, bekey);
                    if (!(bpart instanceof Module)) {
                        throw EBuildUtil.newProblem("Builder part is not a module, got: " + (Object)((Object)bpart.getType()));
                    }
                    ILogger subLogger = this.logger.newSubLogger("" + bpart);
                    subPlan = bpart.newBuildPlan(this.runner, ConfSet.EMPTY, subLogger);
                }
                this.builderPlans.add(subPlan.getKey());
                deps.addBuilder(bekey, subPlan.expectModule());
            }
        }
        finally {
            EBuildContext.end();
        }
    }

    public String toString() {
        return this.getKey() + "";
    }
}

