/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.BuildMode;
import ebuild.core.CPart;
import ebuild.core.EBuildDirectory;
import ebuild.core.EBuildUtil;
import ebuild.core.Element;
import ebuild.core.Part;
import ebuild.core.Project;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.WorkMarker;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildProject<P extends Part>
extends Project<P> {
    private File intermediateDir;
    private WorkMarker buildMarker;

    BuildProject(CPart cpart) {
        super(cpart);
        String confDir = this.getConfiguration().asDirectoryName();
        this.intermediateDir = new File(((Part)this.getPart()).getBuildDirectory(), confDir);
        this.buildMarker = new WorkMarker(this.intermediateDir);
    }

    public boolean isProjectDirty() {
        return false;
    }

    @Override
    public BuildMode mode() {
        return BuildMode.build;
    }

    public void clean() throws Exception {
        FileUtil.deleteDir(this.getIntermediateDirectory());
        FileUtil.deleteDir(this.cpart.release.getFile());
    }

    public boolean isClean() {
        return !this.hasIntermediateDirectory() && !this.hasRelease();
    }

    public boolean isReleased() {
        return !this.isClean() && !this.isDirty();
    }

    public boolean isDirty() {
        if (this.isClean()) {
            return false;
        }
        if (!this.buildMarker.isComplete()) {
            return true;
        }
        if (((Part)this.getPart()).key.version.isMoving()) {
            long outputDate;
            long inputDate = this.cpart.lastModificationOfInput();
            return inputDate > (outputDate = FileUtil.deepLastModified(this.cpart.getReleaseDirectory()));
        }
        return false;
    }

    public File getIntermediateDirectory() {
        return this.intermediateDir;
    }

    public boolean hasIntermediateDirectory() {
        return this.intermediateDir.exists();
    }

    public boolean hasRelease() {
        return this.cpart.release.getFile().exists();
    }

    public void build() throws Exception {
        this.buildPrep();
        this.buildRun();
        this.buildEnd();
    }

    protected void buildPrep() throws IOException {
        this.buildMarker.create();
        this.getIntermediateDirectory().mkdirs();
    }

    public abstract void buildRun() throws Exception;

    protected void buildEnd() throws Exception {
        this.cpart.registerRelease();
        String filename = EBuildUtil.elementType2xmlName(((Element)this.getPart()).getType());
        FileUtil.copyToDirIfNewer(new File(((Element)this.getPart()).getMetaDirectory(), filename), ((Part)this.getPart()).getReleaseDirectory());
        if (((EBuildDirectory)this.cpart.part).isWorkspace()) {
            ((Part)this.cpart.getPart()).addIgnores(CollectionUtil.newList("build", "release"));
        }
        this.buildMarker.remove();
        this.cpart.getReleaseDirectory().setLastModified(System.currentTimeMillis());
    }
}

