/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.conf.ConfSet;
import ebuild.core.BuildProject;
import ebuild.core.CDependencies;
import ebuild.core.EBuildException;
import ebuild.core.EclipseProject;
import ebuild.core.Element;
import ebuild.core.Module;
import ebuild.core.Part;
import ebuild.core.Release;
import ebuild.util.FileUtil;
import ebuild.util.ObjectUtil;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CPart<P extends Part> {
    public final P part;
    public final ConfSet configuration;
    public final ConfSet configurationSelected;
    public final Release<P> release;
    private CDependencies dependencies;
    public BuildProject<P> build;
    public EclipseProject<P> eclipse;
    private Long lastModificationOfInput = null;

    public BuildProject<P> createBuildProject() {
        this.build = this.newBuildProject();
        return this.build;
    }

    public EclipseProject<P> createEclipseProject() {
        this.eclipse = this.newEclipseProject();
        return this.eclipse;
    }

    public Release<P> registerRelease() throws EBuildException {
        if (this.part instanceof Module) {
            Module m = (Module)this.part;
            try {
                m.registerRelease(this);
            }
            catch (Exception e) {
                System.err.println("[WARNING] Unable to register plugin: " + e.getMessage());
            }
        }
        return this.release;
    }

    public CPart(P part, ConfSet configuration, ConfSet configurationSelected) {
        this.part = part;
        this.configuration = configuration;
        this.configurationSelected = configurationSelected;
        this.release = this.newRelease();
    }

    abstract EclipseProject newEclipseProject();

    abstract BuildProject newBuildProject();

    abstract Release newRelease();

    public P getPart() {
        return this.part;
    }

    public CDependencies getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(CDependencies dependencies) {
        this.dependencies = dependencies;
    }

    public ConfSet getConfiguration() {
        return this.configuration;
    }

    public ConfSet getConfigurationSelected() {
        return this.configurationSelected;
    }

    public long lastModificationOfInput() {
        if (this.lastModificationOfInput == null) {
            long r = this.dependencies.lastModified();
            if (((Part)this.part).isSource()) {
                r = Math.max(r, ((Part)this.part).lastModificationOfSource());
            }
            this.lastModificationOfInput = r;
        }
        return this.lastModificationOfInput;
    }

    public long lastModification() {
        long r = this.lastModificationOfInput();
        r = Math.max(r, FileUtil.deepLastModified(this.getReleaseDirectory()));
        return r;
    }

    public int hashCode() {
        return ((Part)this.part).key.hashCode() + ObjectUtil.hashOf(this.configuration);
    }

    public boolean equals(Object obj) {
        CPart b = (CPart)obj;
        return ((Part)this.part).key.equals(((Part)b.part).key) && ObjectUtil.areEqual(this.configuration, b.configuration);
    }

    public String toString() {
        return ((Element)this.part).toString() + " - " + this.configuration.toString();
    }

    public File getReleaseDirectory() {
        return new File(((Part)this.getPart()).getReleaseDirectory(), this.configuration.asDirectoryName());
    }
}

